/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.LongUnaryOperator;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.elasticsearch.common.util.BytesRefHash;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.common.util.ObjectArray;
import org.elasticsearch.common.util.SetBackedScalingCuckooFilter;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.AggregationExecutionContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.bucket.BestBucketsDeferringCollector;
import org.elasticsearch.search.aggregations.bucket.terms.AbstractRareTermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.BytesKeyedBucketOrds;
import org.elasticsearch.search.aggregations.bucket.terms.IncludeExclude;
import org.elasticsearch.search.aggregations.bucket.terms.LongRareTermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.StringRareTerms;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;

public class StringRareTermsAggregator
extends AbstractRareTermsAggregator {
    private final ValuesSource.Bytes valuesSource;
    private final IncludeExclude.StringFilter filter;
    private final BytesKeyedBucketOrds bucketOrds;

    StringRareTermsAggregator(String name, AggregatorFactories factories, ValuesSource.Bytes valuesSource, DocValueFormat format, IncludeExclude.StringFilter filter, AggregationContext context, Aggregator parent, Map<String, Object> metadata, long maxDocCount, double precision, CardinalityUpperBound cardinality) throws IOException {
        super(name, factories, context, parent, metadata, maxDocCount, precision, format);
        this.valuesSource = valuesSource;
        this.filter = filter;
        this.bucketOrds = BytesKeyedBucketOrds.build(this.bigArrays(), cardinality);
    }

    @Override
    public LeafBucketCollector getLeafCollector(AggregationExecutionContext aggCtx, LeafBucketCollector sub) throws IOException {
        SortedBinaryDocValues values = this.valuesSource.bytesValues(aggCtx.getLeafReaderContext());
        BinaryDocValues singleton = FieldData.unwrapSingleton(values);
        return singleton != null ? this.getLeafCollector(singleton, sub) : this.getLeafCollector(values, sub);
    }

    private LeafBucketCollector getLeafCollector(final SortedBinaryDocValues values, final LeafBucketCollector sub) {
        return new LeafBucketCollectorBase(sub, values){
            final BytesRefBuilder previous;
            {
                super(sub2, values2);
                this.previous = new BytesRefBuilder();
            }

            @Override
            public void collect(int docId, long owningBucketOrd) throws IOException {
                if (values.advanceExact(docId)) {
                    this.previous.clear();
                    for (int i = 0; i < values.docValueCount(); ++i) {
                        BytesRef bytes = values.nextValue();
                        if (i > 0 && this.previous.get().equals((Object)bytes)) continue;
                        StringRareTermsAggregator.this.collectValue(bytes, docId, owningBucketOrd, sub);
                        this.previous.copyBytes(bytes);
                    }
                }
            }
        };
    }

    private LeafBucketCollector getLeafCollector(final BinaryDocValues values, final LeafBucketCollector sub) {
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int docId, long owningBucketOrd) throws IOException {
                if (values.advanceExact(docId)) {
                    StringRareTermsAggregator.this.collectValue(values.binaryValue(), docId, owningBucketOrd, sub);
                }
            }
        };
    }

    private void collectValue(BytesRef val, int doc, long owningBucketOrd, LeafBucketCollector sub) throws IOException {
        if (this.filter == null || this.filter.accept(val)) {
            long bucketOrdinal = this.bucketOrds.add(owningBucketOrd, val);
            if (bucketOrdinal < 0L) {
                bucketOrdinal = -1L - bucketOrdinal;
                this.collectExistingBucket(sub, doc, bucketOrdinal);
            } else {
                this.collectBucket(sub, doc, bucketOrdinal);
            }
        }
    }

    @Override
    public InternalAggregation[] buildAggregations(LongArray owningBucketOrds) throws IOException {
        try (ObjectArray<B[]> rarestPerOrd = this.bigArrays().newObjectArray(owningBucketOrds.size());){
            InternalAggregation[] internalAggregationArray;
            block30: {
                ObjectArray filters = this.bigArrays().newObjectArray(owningBucketOrds.size());
                try {
                    try (LongArray mergeMap = this.bigArrays().newLongArray(this.bucketOrds.size());){
                        mergeMap.fill(0L, mergeMap.size(), -1L);
                        long keepCount = 0L;
                        long offset = 0L;
                        for (long owningOrdIdx = 0L; owningOrdIdx < owningBucketOrds.size(); ++owningOrdIdx) {
                            try (BytesRefHash bucketsInThisOwningBucketToCollect = new BytesRefHash(1L, this.bigArrays());){
                                filters.set(owningOrdIdx, this.newFilter());
                                ArrayList<StringRareTerms.Bucket> builtBuckets = new ArrayList<StringRareTerms.Bucket>();
                                BytesKeyedBucketOrds.BucketOrdsEnum collectedBuckets = this.bucketOrds.ordsEnum(owningBucketOrds.get(owningOrdIdx));
                                BytesRef scratch = new BytesRef();
                                while (collectedBuckets.next()) {
                                    collectedBuckets.readValue(scratch);
                                    long docCount = this.bucketDocCount(collectedBuckets.ord());
                                    if (docCount <= this.maxDocCount) {
                                        StringRareTerms.Bucket bucket = new StringRareTerms.Bucket(BytesRef.deepCopyOf((BytesRef)scratch), docCount, null, this.format);
                                        bucket.bucketOrd = offset + bucketsInThisOwningBucketToCollect.add(scratch);
                                        mergeMap.set(collectedBuckets.ord(), bucket.bucketOrd);
                                        builtBuckets.add(bucket);
                                        ++keepCount;
                                        continue;
                                    }
                                    ((SetBackedScalingCuckooFilter)filters.get(owningOrdIdx)).add(scratch);
                                }
                                rarestPerOrd.set(owningOrdIdx, (StringRareTerms.Bucket[])builtBuckets.toArray(StringRareTerms.Bucket[]::new));
                                offset += bucketsInThisOwningBucketToCollect.size();
                                continue;
                            }
                        }
                        if (keepCount != mergeMap.size()) {
                            LongUnaryOperator howToMerge = mergeMap::get;
                            this.rewriteBuckets(offset, howToMerge);
                            if (this.deferringCollector() != null) {
                                ((BestBucketsDeferringCollector)this.deferringCollector()).rewriteBuckets(howToMerge);
                            }
                        }
                    }
                    this.buildSubAggsForAllBuckets(rarestPerOrd, b -> b.bucketOrd, (b, aggs) -> {
                        b.aggregations = aggs;
                    });
                    InternalAggregation[] result = new InternalAggregation[Math.toIntExact(owningBucketOrds.size())];
                    for (int ordIdx = 0; ordIdx < result.length; ++ordIdx) {
                        StringRareTerms.Bucket[] buckets = (StringRareTerms.Bucket[])rarestPerOrd.get(ordIdx);
                        Arrays.sort(buckets, ORDER.comparator());
                        result[ordIdx] = new StringRareTerms(this.name, ORDER, this.metadata(), this.format, Arrays.asList(buckets), this.maxDocCount, (SetBackedScalingCuckooFilter)filters.get(ordIdx));
                    }
                    internalAggregationArray = result;
                    if (filters == null) break block30;
                }
                catch (Throwable throwable) {
                    if (filters != null) {
                        try {
                            filters.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                filters.close();
            }
            return internalAggregationArray;
        }
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new StringRareTerms(this.name, LongRareTermsAggregator.ORDER, this.metadata(), this.format, Collections.emptyList(), 0L, this.newFilter());
    }

    @Override
    public void doClose() {
        Releasables.close((Releasable)this.bucketOrds);
    }
}

