/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.field.vectors;

import java.util.Iterator;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.index.mapper.vectors.VectorEncoderDecoder;
import org.elasticsearch.script.field.vectors.MultiDenseVector;

public class FloatMultiDenseVector
implements MultiDenseVector {
    private final BytesRef magnitudes;
    private float[] magnitudesArray = null;
    private final int dims;
    private final int numVectors;
    private final Iterator<float[]> decodedDocVector;

    public FloatMultiDenseVector(Iterator<float[]> decodedDocVector, BytesRef magnitudes, int numVectors, int dims) {
        assert (magnitudes.length == numVectors * 4);
        this.decodedDocVector = decodedDocVector;
        this.magnitudes = magnitudes;
        this.numVectors = numVectors;
        this.dims = dims;
    }

    @Override
    public Iterator<float[]> getVectors() {
        return this.decodedDocVector;
    }

    @Override
    public float[] getMagnitudes() {
        if (this.magnitudesArray == null) {
            this.magnitudesArray = VectorEncoderDecoder.getMultiMagnitudes(this.magnitudes);
        }
        return this.magnitudesArray;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public int getDims() {
        return this.dims;
    }

    @Override
    public int size() {
        return this.numVectors;
    }
}

