/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.field.vectors;

import java.util.Iterator;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.script.field.vectors.ByteMultiDenseVector;

public class BitMultiDenseVector
extends ByteMultiDenseVector {
    public BitMultiDenseVector(Iterator<byte[]> vectorValues, BytesRef magnitudesBytes, int numVecs, int dims) {
        super(vectorValues, magnitudesBytes, numVecs, dims);
    }

    @Override
    public void checkDimensions(int qvDims) {
        if (qvDims != this.dims) {
            throw new IllegalArgumentException("The query vector has a different number of dimensions [" + qvDims * 8 + "] than the document vectors [" + this.dims * 8 + "].");
        }
    }

    @Override
    public int getDims() {
        return this.dims * 8;
    }
}

