/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.search;

import java.util.HashSet;
import java.util.Set;
import org.elasticsearch.Build;
import org.elasticsearch.index.mapper.vectors.MultiDenseVectorFieldMapper;

public final class SearchCapabilities {
    private static final String RANGE_REGEX_INTERVAL_QUERY_CAPABILITY = "range_regexp_interval_queries";
    private static final String BIT_DENSE_VECTOR_SYNTHETIC_SOURCE_CAPABILITY = "bit_dense_vector_synthetic_source";
    private static final String BYTE_FLOAT_BIT_DOT_PRODUCT_CAPABILITY = "byte_float_bit_dot_product_with_bugfix";
    private static final String DENSE_VECTOR_DOCVALUE_FIELDS = "dense_vector_docvalue_fields";
    private static final String KQL_QUERY_SUPPORTED = "kql_query";
    private static final String MULTI_DENSE_VECTOR_FIELD_MAPPER = "multi_dense_vector_field_mapper";
    private static final String NESTED_RETRIEVER_INNER_HITS_SUPPORT = "nested_retriever_inner_hits_support";
    private static final String MULTI_DENSE_VECTOR_SCRIPT_ACCESS = "multi_dense_vector_script_access";
    private static final String MOVING_FN_RIGHT_MATH = "moving_fn_right_math";
    private static final String RANDOM_SAMPLER_WITH_SCORED_SUBAGGS = "random_sampler_with_scored_subaggs";
    private static final String RRF_WINDOW_SIZE_SUPPORT_DEPRECATED = "rrf_window_size_support_deprecated";
    private static final String SIGNIFICANT_TERMS_ON_NESTED_FIELDS = "significant_terms_on_nested_fields";
    private static final String BUCKET_SCRIPT_PARENT_MULTI_BUCKET_ERROR = "bucket_script_parent_multi_bucket_error";
    public static final Set<String> CAPABILITIES;

    private SearchCapabilities() {
    }

    static {
        HashSet<String> capabilities = new HashSet<String>();
        capabilities.add(RANGE_REGEX_INTERVAL_QUERY_CAPABILITY);
        capabilities.add(BIT_DENSE_VECTOR_SYNTHETIC_SOURCE_CAPABILITY);
        capabilities.add(BYTE_FLOAT_BIT_DOT_PRODUCT_CAPABILITY);
        capabilities.add(DENSE_VECTOR_DOCVALUE_FIELDS);
        capabilities.add(NESTED_RETRIEVER_INNER_HITS_SUPPORT);
        capabilities.add(RANDOM_SAMPLER_WITH_SCORED_SUBAGGS);
        capabilities.add(MOVING_FN_RIGHT_MATH);
        if (MultiDenseVectorFieldMapper.FEATURE_FLAG.isEnabled()) {
            capabilities.add(MULTI_DENSE_VECTOR_FIELD_MAPPER);
            capabilities.add(MULTI_DENSE_VECTOR_SCRIPT_ACCESS);
        }
        if (Build.current().isSnapshot()) {
            capabilities.add(KQL_QUERY_SUPPORTED);
        }
        capabilities.add(RRF_WINDOW_SIZE_SUPPORT_DEPRECATED);
        capabilities.add(SIGNIFICANT_TERMS_ON_NESTED_FIELDS);
        capabilities.add(BUCKET_SCRIPT_PARENT_MULTI_BUCKET_ERROR);
        CAPABILITIES = Set.copyOf(capabilities);
    }
}

