/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor.metrics;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.store.AlreadyClosedException;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.util.SingleObjectCache;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.shard.DocsStats;
import org.elasticsearch.index.shard.IllegalIndexShardStateException;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.monitor.metrics.IndexStats;
import org.elasticsearch.telemetry.metric.LongWithAttributes;
import org.elasticsearch.telemetry.metric.MeterRegistry;

public class IndicesMetrics
extends AbstractLifecycleComponent {
    private final Logger logger = LogManager.getLogger(IndicesMetrics.class);
    private final MeterRegistry registry;
    private final List<AutoCloseable> metrics = new ArrayList<AutoCloseable>();
    private final IndicesStatsCache stateCache;

    public IndicesMetrics(MeterRegistry meterRegistry, IndicesService indicesService, TimeValue metricsInterval) {
        this.registry = meterRegistry;
        TimeValue cacheExpiry = new TimeValue(metricsInterval.getMillis() / 2L);
        this.stateCache = new IndicesStatsCache(indicesService, cacheExpiry);
    }

    private static List<AutoCloseable> registerAsyncMetrics(MeterRegistry registry, IndicesStatsCache cache) {
        int TOTAL_METRICS = 48;
        ArrayList<AutoCloseable> metrics = new ArrayList<AutoCloseable>(48);
        for (IndexMode indexMode : IndexMode.values()) {
            String name = indexMode.getName();
            metrics.add(registry.registerLongGauge("es.indices." + name + ".total", "total number of " + name + " indices", "unit", () -> new LongWithAttributes(((IndexStats)((Map)cache.getOrRefresh()).get((Object)((Object)((Object)indexMode)))).numIndices)));
            metrics.add(registry.registerLongGauge("es.indices." + name + ".docs.total", "total documents of " + name + " indices", "unit", () -> new LongWithAttributes(((IndexStats)((Map)cache.getOrRefresh()).get((Object)((Object)((Object)indexMode)))).numDocs)));
            metrics.add(registry.registerLongGauge("es.indices." + name + ".size", "total size in bytes of " + name + " indices", "bytes", () -> new LongWithAttributes(((IndexStats)((Map)cache.getOrRefresh()).get((Object)((Object)((Object)indexMode)))).numBytes)));
            metrics.add(registry.registerLongGauge("es.indices." + name + ".query.total", "current queries of " + name + " indices", "unit", IndicesMetrics.diffGauge(() -> ((IndexStats)((Map)cache.getOrRefresh()).get((Object)((Object)((Object)indexMode)))).search.getQueryCount())));
            metrics.add(registry.registerLongGauge("es.indices." + name + ".query.time", "current query time of " + name + " indices", "ms", IndicesMetrics.diffGauge(() -> ((IndexStats)((Map)cache.getOrRefresh()).get((Object)((Object)((Object)indexMode)))).search.getQueryTimeInMillis())));
            metrics.add(registry.registerLongGauge("es.indices." + name + ".query.failure.total", "current query failures of " + name + " indices", "unit", IndicesMetrics.diffGauge(() -> ((IndexStats)((Map)cache.getOrRefresh()).get((Object)((Object)((Object)indexMode)))).search.getQueryFailure())));
            metrics.add(registry.registerLongGauge("es.indices." + name + ".fetch.total", "current fetches of " + name + " indices", "unit", IndicesMetrics.diffGauge(() -> ((IndexStats)((Map)cache.getOrRefresh()).get((Object)((Object)((Object)indexMode)))).search.getFetchCount())));
            metrics.add(registry.registerLongGauge("es.indices." + name + ".fetch.time", "current fetch time of " + name + " indices", "ms", IndicesMetrics.diffGauge(() -> ((IndexStats)((Map)cache.getOrRefresh()).get((Object)((Object)((Object)indexMode)))).search.getFetchTimeInMillis())));
            metrics.add(registry.registerLongGauge("es.indices." + name + ".fetch.failure.total", "current fetch failures of " + name + " indices", "unit", IndicesMetrics.diffGauge(() -> ((IndexStats)((Map)cache.getOrRefresh()).get((Object)((Object)((Object)indexMode)))).search.getFetchFailure())));
            metrics.add(registry.registerLongGauge("es.indices." + name + ".indexing.total", "current indexing operations of " + name + " indices", "unit", IndicesMetrics.diffGauge(() -> ((IndexStats)((Map)cache.getOrRefresh()).get((Object)((Object)((Object)indexMode)))).indexing.getIndexCount())));
            metrics.add(registry.registerLongGauge("es.indices." + name + ".indexing.time", "current indexing time of " + name + " indices", "ms", IndicesMetrics.diffGauge(() -> ((IndexStats)((Map)cache.getOrRefresh()).get((Object)((Object)((Object)indexMode)))).indexing.getIndexTime().millis())));
            metrics.add(registry.registerLongGauge("es.indices." + name + ".indexing.failure.total", "current indexing failures of " + name + " indices", "unit", IndicesMetrics.diffGauge(() -> ((IndexStats)((Map)cache.getOrRefresh()).get((Object)((Object)((Object)indexMode)))).indexing.getIndexFailedCount())));
        }
        assert (metrics.size() == 48) : "total number of metrics has changed";
        return metrics;
    }

    static Supplier<LongWithAttributes> diffGauge(Supplier<Long> currentValue) {
        AtomicLong counter = new AtomicLong();
        return () -> {
            Long curr = (Long)currentValue.get();
            long prev = counter.getAndUpdate(v -> Math.max(curr, v));
            return new LongWithAttributes(Math.max(0L, curr - prev));
        };
    }

    @Override
    protected void doStart() {
        this.metrics.addAll(IndicesMetrics.registerAsyncMetrics(this.registry, this.stateCache));
    }

    @Override
    protected void doStop() {
        this.stateCache.stopRefreshing();
    }

    @Override
    protected void doClose() throws IOException {
        this.metrics.forEach(metric -> {
            try {
                metric.close();
            }
            catch (Exception e) {
                this.logger.warn("metrics close() method should not throw Exception", (Throwable)e);
            }
        });
    }

    static Map<IndexMode, IndexStats> getStatsWithoutCache(IndicesService indicesService) {
        EnumMap<IndexMode, IndexStats> stats = new EnumMap<IndexMode, IndexStats>(IndexMode.class);
        for (IndexMode mode : IndexMode.values()) {
            stats.put(mode, new IndexStats());
        }
        for (IndexService indexService : indicesService) {
            for (IndexShard indexShard : indexService) {
                if (indexShard.isSystem()) continue;
                ShardRouting shardRouting = indexShard.routingEntry();
                IndexMode indexMode = indexShard.indexSettings().getMode();
                IndexStats indexStats = (IndexStats)stats.get((Object)indexMode);
                try {
                    if (shardRouting.primary() && shardRouting.recoverySource() == null) {
                        if (shardRouting.shardId().id() == 0) {
                            ++indexStats.numIndices;
                        }
                        DocsStats docStats = indexShard.docStats();
                        indexStats.numDocs += docStats.getCount();
                        indexStats.numBytes += docStats.getTotalSizeInBytes();
                        indexStats.indexing.add(indexShard.indexingStats().getTotal());
                    }
                    indexStats.search.add(indexShard.searchStats(new String[0]).getTotal());
                }
                catch (AlreadyClosedException | IllegalIndexShardStateException throwable) {}
            }
        }
        return stats;
    }

    private static class IndicesStatsCache
    extends SingleObjectCache<Map<IndexMode, IndexStats>> {
        private static final Map<IndexMode, IndexStats> MISSING_STATS = new EnumMap<IndexMode, IndexStats>(IndexMode.class);
        private boolean refresh;
        private final IndicesService indicesService;

        IndicesStatsCache(IndicesService indicesService, TimeValue interval) {
            super(interval, MISSING_STATS);
            this.indicesService = indicesService;
            this.refresh = true;
        }

        @Override
        protected Map<IndexMode, IndexStats> refresh() {
            return this.refresh ? IndicesMetrics.getStatsWithoutCache(this.indicesService) : (Map)this.getNoRefresh();
        }

        @Override
        protected boolean needsRefresh() {
            return this.getNoRefresh() == MISSING_STATS || super.needsRefresh();
        }

        void stopRefreshing() {
            this.refresh = false;
        }

        static {
            for (IndexMode value : IndexMode.values()) {
                MISSING_STATS.put(value, new IndexStats());
            }
        }
    }
}

