/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.inference;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.configuration.SettingsConfigurationDependency;
import org.elasticsearch.inference.configuration.SettingsConfigurationDisplayType;
import org.elasticsearch.inference.configuration.SettingsConfigurationFieldType;
import org.elasticsearch.inference.configuration.SettingsConfigurationSelectOption;
import org.elasticsearch.inference.configuration.SettingsConfigurationValidation;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParseException;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;

public class SettingsConfiguration
implements Writeable,
ToXContentObject {
    @Nullable
    private final String category;
    @Nullable
    private final Object defaultValue;
    @Nullable
    private final List<SettingsConfigurationDependency> dependsOn;
    @Nullable
    private final SettingsConfigurationDisplayType display;
    private final String label;
    @Nullable
    private final List<SettingsConfigurationSelectOption> options;
    @Nullable
    private final Integer order;
    @Nullable
    private final String placeholder;
    private final boolean required;
    private final boolean sensitive;
    @Nullable
    private final String tooltip;
    @Nullable
    private final SettingsConfigurationFieldType type;
    @Nullable
    private final List<String> uiRestrictions;
    @Nullable
    private final List<SettingsConfigurationValidation> validations;
    @Nullable
    private final Object value;
    static final ParseField CATEGORY_FIELD = new ParseField("category", new String[0]);
    static final ParseField DEFAULT_VALUE_FIELD = new ParseField("default_value", new String[0]);
    static final ParseField DEPENDS_ON_FIELD = new ParseField("depends_on", new String[0]);
    static final ParseField DISPLAY_FIELD = new ParseField("display", new String[0]);
    static final ParseField LABEL_FIELD = new ParseField("label", new String[0]);
    static final ParseField OPTIONS_FIELD = new ParseField("options", new String[0]);
    static final ParseField ORDER_FIELD = new ParseField("order", new String[0]);
    static final ParseField PLACEHOLDER_FIELD = new ParseField("placeholder", new String[0]);
    static final ParseField REQUIRED_FIELD = new ParseField("required", new String[0]);
    static final ParseField SENSITIVE_FIELD = new ParseField("sensitive", new String[0]);
    static final ParseField TOOLTIP_FIELD = new ParseField("tooltip", new String[0]);
    static final ParseField TYPE_FIELD = new ParseField("type", new String[0]);
    static final ParseField UI_RESTRICTIONS_FIELD = new ParseField("ui_restrictions", new String[0]);
    static final ParseField VALIDATIONS_FIELD = new ParseField("validations", new String[0]);
    static final ParseField VALUE_FIELD = new ParseField("value", new String[0]);
    private static final ConstructingObjectParser<SettingsConfiguration, Void> PARSER = new ConstructingObjectParser("service_configuration", true, args -> {
        int i = 0;
        return new Builder().setCategory((String)args[i++]).setDefaultValue(args[i++]).setDependsOn((List)args[i++]).setDisplay((SettingsConfigurationDisplayType)((Object)((Object)args[i++]))).setLabel((String)args[i++]).setOptions((List)args[i++]).setOrder((Integer)args[i++]).setPlaceholder((String)args[i++]).setRequired((Boolean)args[i++]).setSensitive((Boolean)args[i++]).setTooltip((String)args[i++]).setType((SettingsConfigurationFieldType)((Object)((Object)args[i++]))).setUiRestrictions((List)args[i++]).setValidations((List)args[i++]).setValue(args[i]).build();
    });

    private SettingsConfiguration(String category, Object defaultValue, List<SettingsConfigurationDependency> dependsOn, SettingsConfigurationDisplayType display, String label, List<SettingsConfigurationSelectOption> options, Integer order, String placeholder, boolean required, boolean sensitive, String tooltip, SettingsConfigurationFieldType type, List<String> uiRestrictions, List<SettingsConfigurationValidation> validations, Object value) {
        this.category = category;
        this.defaultValue = defaultValue;
        this.dependsOn = dependsOn;
        this.display = display;
        this.label = label;
        this.options = options;
        this.order = order;
        this.placeholder = placeholder;
        this.required = required;
        this.sensitive = sensitive;
        this.tooltip = tooltip;
        this.type = type;
        this.uiRestrictions = uiRestrictions;
        this.validations = validations;
        this.value = value;
    }

    public SettingsConfiguration(StreamInput in) throws IOException {
        this.category = in.readString();
        this.defaultValue = in.readGenericValue();
        this.dependsOn = in.readOptionalCollectionAsList(SettingsConfigurationDependency::new);
        this.display = in.readEnum(SettingsConfigurationDisplayType.class);
        this.label = in.readString();
        this.options = in.readOptionalCollectionAsList(SettingsConfigurationSelectOption::new);
        this.order = in.readOptionalInt();
        this.placeholder = in.readOptionalString();
        this.required = in.readBoolean();
        this.sensitive = in.readBoolean();
        this.tooltip = in.readOptionalString();
        this.type = in.readEnum(SettingsConfigurationFieldType.class);
        this.uiRestrictions = in.readOptionalStringCollectionAsList();
        this.validations = in.readOptionalCollectionAsList(SettingsConfigurationValidation::new);
        this.value = in.readGenericValue();
    }

    public String getCategory() {
        return this.category;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public List<SettingsConfigurationDependency> getDependsOn() {
        return this.dependsOn;
    }

    public SettingsConfigurationDisplayType getDisplay() {
        return this.display;
    }

    public String getLabel() {
        return this.label;
    }

    public List<SettingsConfigurationSelectOption> getOptions() {
        return this.options;
    }

    public Integer getOrder() {
        return this.order;
    }

    public String getPlaceholder() {
        return this.placeholder;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isSensitive() {
        return this.sensitive;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public SettingsConfigurationFieldType getType() {
        return this.type;
    }

    public List<String> getUiRestrictions() {
        return this.uiRestrictions;
    }

    public List<SettingsConfigurationValidation> getValidations() {
        return this.validations;
    }

    public Object getValue() {
        return this.value;
    }

    public static Object parseConfigurationValue(XContentParser p) throws IOException {
        if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
            return p.text();
        }
        if (p.currentToken() == XContentParser.Token.VALUE_NUMBER) {
            return p.numberValue();
        }
        if (p.currentToken() == XContentParser.Token.VALUE_BOOLEAN) {
            return p.booleanValue();
        }
        if (p.currentToken() == XContentParser.Token.START_OBJECT) {
            return p.map();
        }
        if (p.currentToken() == XContentParser.Token.VALUE_NULL) {
            return null;
        }
        throw new XContentParseException("Unsupported token [" + String.valueOf(p.currentToken()) + "]");
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.category != null) {
            builder.field(CATEGORY_FIELD.getPreferredName(), this.category);
        }
        builder.field(DEFAULT_VALUE_FIELD.getPreferredName(), this.defaultValue);
        if (this.dependsOn != null) {
            builder.xContentList(DEPENDS_ON_FIELD.getPreferredName(), this.dependsOn);
        } else {
            builder.xContentList(DEPENDS_ON_FIELD.getPreferredName(), new ArrayList());
        }
        if (this.display != null) {
            builder.field(DISPLAY_FIELD.getPreferredName(), this.display.toString());
        }
        builder.field(LABEL_FIELD.getPreferredName(), this.label);
        if (this.options != null) {
            builder.xContentList(OPTIONS_FIELD.getPreferredName(), this.options);
        }
        if (this.order != null) {
            builder.field(ORDER_FIELD.getPreferredName(), this.order);
        }
        if (this.placeholder != null) {
            builder.field(PLACEHOLDER_FIELD.getPreferredName(), this.placeholder);
        }
        builder.field(REQUIRED_FIELD.getPreferredName(), this.required);
        builder.field(SENSITIVE_FIELD.getPreferredName(), this.sensitive);
        if (this.tooltip != null) {
            builder.field(TOOLTIP_FIELD.getPreferredName(), this.tooltip);
        }
        if (this.type != null) {
            builder.field(TYPE_FIELD.getPreferredName(), this.type.toString());
        }
        if (this.uiRestrictions != null) {
            builder.stringListField(UI_RESTRICTIONS_FIELD.getPreferredName(), this.uiRestrictions);
        } else {
            builder.stringListField(UI_RESTRICTIONS_FIELD.getPreferredName(), new ArrayList());
        }
        if (this.validations != null) {
            builder.xContentList(VALIDATIONS_FIELD.getPreferredName(), this.validations);
        } else {
            builder.xContentList(VALIDATIONS_FIELD.getPreferredName(), new ArrayList());
        }
        builder.field(VALUE_FIELD.getPreferredName(), this.value);
        builder.endObject();
        return builder;
    }

    public static SettingsConfiguration fromXContent(XContentParser parser) throws IOException {
        return (SettingsConfiguration)PARSER.parse(parser, null);
    }

    public static SettingsConfiguration fromXContentBytes(BytesReference source, XContentType xContentType) {
        SettingsConfiguration settingsConfiguration;
        block8: {
            XContentParser parser = XContentHelper.createParser(XContentParserConfiguration.EMPTY, source, xContentType);
            try {
                settingsConfiguration = SettingsConfiguration.fromXContent(parser);
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ElasticsearchParseException("Failed to parse service configuration.", (Throwable)e, new Object[0]);
                }
            }
            parser.close();
        }
        return settingsConfiguration;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.category);
        out.writeGenericValue(this.defaultValue);
        out.writeOptionalCollection(this.dependsOn);
        out.writeEnum(this.display);
        out.writeString(this.label);
        out.writeOptionalCollection(this.options);
        out.writeOptionalInt(this.order);
        out.writeOptionalString(this.placeholder);
        out.writeBoolean(this.required);
        out.writeBoolean(this.sensitive);
        out.writeOptionalString(this.tooltip);
        out.writeEnum(this.type);
        out.writeOptionalStringCollection(this.uiRestrictions);
        out.writeOptionalCollection(this.validations);
        out.writeGenericValue(this.value);
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Optional.ofNullable(this.category).ifPresent(c -> map.put(CATEGORY_FIELD.getPreferredName(), c));
        map.put(DEFAULT_VALUE_FIELD.getPreferredName(), this.defaultValue);
        Optional.ofNullable(this.dependsOn).ifPresent(d -> map.put(DEPENDS_ON_FIELD.getPreferredName(), d.stream().map(SettingsConfigurationDependency::toMap).toList()));
        Optional.ofNullable(this.display).ifPresent(d -> map.put(DISPLAY_FIELD.getPreferredName(), d.toString()));
        map.put(LABEL_FIELD.getPreferredName(), this.label);
        Optional.ofNullable(this.options).ifPresent(o -> map.put(OPTIONS_FIELD.getPreferredName(), o.stream().map(SettingsConfigurationSelectOption::toMap).toList()));
        Optional.ofNullable(this.order).ifPresent(o -> map.put(ORDER_FIELD.getPreferredName(), o));
        Optional.ofNullable(this.placeholder).ifPresent(p -> map.put(PLACEHOLDER_FIELD.getPreferredName(), p));
        map.put(REQUIRED_FIELD.getPreferredName(), this.required);
        map.put(SENSITIVE_FIELD.getPreferredName(), this.sensitive);
        Optional.ofNullable(this.tooltip).ifPresent(t -> map.put(TOOLTIP_FIELD.getPreferredName(), t));
        Optional.ofNullable(this.type).ifPresent(t -> map.put(TYPE_FIELD.getPreferredName(), t.toString()));
        Optional.ofNullable(this.uiRestrictions).ifPresent(u -> map.put(UI_RESTRICTIONS_FIELD.getPreferredName(), u));
        Optional.ofNullable(this.validations).ifPresent(v -> map.put(VALIDATIONS_FIELD.getPreferredName(), v.stream().map(SettingsConfigurationValidation::toMap).toList()));
        map.put(VALUE_FIELD.getPreferredName(), this.value);
        return map;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SettingsConfiguration that = (SettingsConfiguration)o;
        return this.required == that.required && this.sensitive == that.sensitive && Objects.equals(this.category, that.category) && Objects.equals(this.defaultValue, that.defaultValue) && Objects.equals(this.dependsOn, that.dependsOn) && this.display == that.display && Objects.equals(this.label, that.label) && Objects.equals(this.options, that.options) && Objects.equals(this.order, that.order) && Objects.equals(this.placeholder, that.placeholder) && Objects.equals(this.tooltip, that.tooltip) && this.type == that.type && Objects.equals(this.uiRestrictions, that.uiRestrictions) && Objects.equals(this.validations, that.validations) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.category, this.defaultValue, this.dependsOn, this.display, this.label, this.options, this.order, this.placeholder, this.required, this.sensitive, this.tooltip, this.type, this.uiRestrictions, this.validations, this.value});
    }

    static {
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), CATEGORY_FIELD);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> {
            if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                return p.text();
            }
            if (p.currentToken() == XContentParser.Token.VALUE_NUMBER) {
                return p.numberValue();
            }
            if (p.currentToken() == XContentParser.Token.VALUE_BOOLEAN) {
                return Boolean.valueOf(p.booleanValue());
            }
            if (p.currentToken() == XContentParser.Token.VALUE_NULL) {
                return null;
            }
            throw new XContentParseException("Unsupported token [" + String.valueOf(p.currentToken()) + "]");
        }, DEFAULT_VALUE_FIELD, ObjectParser.ValueType.VALUE);
        PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> SettingsConfigurationDependency.fromXContent(p), DEPENDS_ON_FIELD);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> SettingsConfigurationDisplayType.displayType(p.text()), DISPLAY_FIELD, ObjectParser.ValueType.STRING_OR_NULL);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), LABEL_FIELD);
        PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> SettingsConfigurationSelectOption.fromXContent(p), OPTIONS_FIELD);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), ORDER_FIELD);
        PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), PLACEHOLDER_FIELD);
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), REQUIRED_FIELD);
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), SENSITIVE_FIELD);
        PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), TOOLTIP_FIELD);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.currentToken() == XContentParser.Token.VALUE_NULL ? null : SettingsConfigurationFieldType.fieldType(p.text()), TYPE_FIELD, ObjectParser.ValueType.STRING_OR_NULL);
        PARSER.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), UI_RESTRICTIONS_FIELD);
        PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> SettingsConfigurationValidation.fromXContent(p), VALIDATIONS_FIELD);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> SettingsConfiguration.parseConfigurationValue(p), VALUE_FIELD, ObjectParser.ValueType.VALUE_OBJECT_ARRAY);
    }

    public static class Builder {
        private String category;
        private Object defaultValue;
        private List<SettingsConfigurationDependency> dependsOn;
        private SettingsConfigurationDisplayType display;
        private String label;
        private List<SettingsConfigurationSelectOption> options;
        private Integer order;
        private String placeholder;
        private boolean required;
        private boolean sensitive;
        private String tooltip;
        private SettingsConfigurationFieldType type;
        private List<String> uiRestrictions;
        private List<SettingsConfigurationValidation> validations;
        private Object value;

        public Builder setCategory(String category) {
            this.category = category;
            return this;
        }

        public Builder setDefaultValue(Object defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder setDependsOn(List<SettingsConfigurationDependency> dependsOn) {
            this.dependsOn = dependsOn;
            return this;
        }

        public Builder setDisplay(SettingsConfigurationDisplayType display) {
            this.display = display;
            return this;
        }

        public Builder setLabel(String label) {
            this.label = label;
            return this;
        }

        public Builder setOptions(List<SettingsConfigurationSelectOption> options) {
            this.options = options;
            return this;
        }

        public Builder setOrder(Integer order) {
            this.order = order;
            return this;
        }

        public Builder setPlaceholder(String placeholder) {
            this.placeholder = placeholder;
            return this;
        }

        public Builder setRequired(Boolean required) {
            this.required = Objects.requireNonNullElse(required, false);
            return this;
        }

        public Builder setSensitive(Boolean sensitive) {
            this.sensitive = Objects.requireNonNullElse(sensitive, false);
            return this;
        }

        public Builder setTooltip(String tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        public Builder setType(SettingsConfigurationFieldType type) {
            this.type = type;
            return this;
        }

        public Builder setUiRestrictions(List<String> uiRestrictions) {
            this.uiRestrictions = uiRestrictions;
            return this;
        }

        public Builder setValidations(List<SettingsConfigurationValidation> validations) {
            this.validations = validations;
            return this;
        }

        public Builder setValue(Object value) {
            this.value = value;
            return this;
        }

        public SettingsConfiguration build() {
            return new SettingsConfiguration(this.category, this.defaultValue, this.dependsOn, this.display, this.label, this.options, this.order, this.placeholder, this.required, this.sensitive, this.tooltip, this.type, this.uiRestrictions, this.validations, this.value);
        }
    }
}

