/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.MatchNoneQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class ExistsQueryBuilder
extends AbstractQueryBuilder<ExistsQueryBuilder> {
    public static final String NAME = "exists";
    public static final ParseField FIELD_FIELD = new ParseField("field", new String[0]);
    private final String fieldName;

    public ExistsQueryBuilder(String fieldName) {
        if (Strings.isEmpty(fieldName)) {
            throw new IllegalArgumentException("field name is null or empty");
        }
        this.fieldName = fieldName;
    }

    public ExistsQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.fieldName = in.readString();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.fieldName);
    }

    public String fieldName() {
        return this.fieldName;
    }

    @Override
    protected QueryBuilder doIndexMetadataRewrite(QueryRewriteContext context) throws IOException {
        if (ExistsQueryBuilder.getMappedFields(context, this.fieldName).isEmpty()) {
            return new MatchNoneQueryBuilder("The \"" + this.getName() + "\" query was rewritten to a \"match_none\" query.");
        }
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.field(FIELD_FIELD.getPreferredName(), this.fieldName);
        this.printBoostAndQueryName(builder);
        builder.endObject();
    }

    public static ExistsQueryBuilder fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String fieldPattern = null;
        String queryName = null;
        float boost = 1.0f;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if (FIELD_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    fieldPattern = parser.text();
                    continue;
                }
                if (AbstractQueryBuilder.NAME_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    queryName = parser.text();
                    continue;
                }
                if (AbstractQueryBuilder.BOOST_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    boost = parser.floatValue();
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[exists] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            throw new ParsingException(parser.getTokenLocation(), "[exists] unknown token [" + String.valueOf(token) + "] after [" + currentFieldName + "]", new Object[0]);
        }
        if (fieldPattern == null) {
            throw new ParsingException(parser.getTokenLocation(), "[exists] must be provided with a [field]", new Object[0]);
        }
        ExistsQueryBuilder builder = new ExistsQueryBuilder(fieldPattern);
        builder.queryName(queryName);
        builder.boost(boost);
        return builder;
    }

    @Override
    protected Query doToQuery(SearchExecutionContext context) throws IOException {
        return ExistsQueryBuilder.newFilter(context, this.fieldName, true);
    }

    public static Query newFilter(SearchExecutionContext context, String fieldPattern, boolean checkRewrite) {
        List<MappedFieldType> fields = ExistsQueryBuilder.getMappedFields(context, fieldPattern).stream().map(context::getFieldType).toList();
        if (fields.isEmpty()) {
            if (checkRewrite) {
                throw new IllegalStateException("Rewrite first");
            }
            return new MatchNoDocsQuery("unmapped field:" + fieldPattern);
        }
        if (fields.size() == 1) {
            MappedFieldType field = (MappedFieldType)fields.iterator().next();
            return new ConstantScoreQuery(field.existsQuery(context));
        }
        BooleanQuery.Builder boolFilterBuilder = new BooleanQuery.Builder();
        for (MappedFieldType field : fields) {
            boolFilterBuilder.add(field.existsQuery(context), BooleanClause.Occur.SHOULD);
        }
        return new ConstantScoreQuery((Query)boolFilterBuilder.build());
    }

    private static Collection<String> getMappedFields(QueryRewriteContext context, String fieldPattern) {
        Set<String> matchingFieldNames = context.getMatchingFieldNames(fieldPattern);
        if (matchingFieldNames.isEmpty()) {
            matchingFieldNames = context.getMatchingFieldNames(fieldPattern + ".*");
        }
        return matchingFieldNames;
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.fieldName);
    }

    @Override
    protected boolean doEquals(ExistsQueryBuilder other) {
        return Objects.equals(this.fieldName, other.fieldName);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.ZERO;
    }
}

