/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.ByteArrayStreamInput;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.plain.BytesBinaryIndexFieldData;
import org.elasticsearch.index.mapper.BinaryDocValuesSyntheticFieldLoader;
import org.elasticsearch.index.mapper.CustomDocValuesField;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.SourceFieldMapper;
import org.elasticsearch.index.mapper.SourceValueFetcher;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class BinaryFieldMapper
extends FieldMapper {
    public static final String CONTENT_TYPE = "binary";
    public static final FieldMapper.TypeParser PARSER = new FieldMapper.TypeParser((n, c) -> new Builder((String)n, SourceFieldMapper.isSynthetic(c.getIndexSettings())));
    private final boolean stored;
    private final boolean hasDocValues;
    private final boolean isSyntheticSourceEnabled;

    private static BinaryFieldMapper toType(FieldMapper in) {
        return (BinaryFieldMapper)in;
    }

    protected BinaryFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.BuilderParams builderParams, Builder builder) {
        super(simpleName, mappedFieldType, builderParams);
        this.stored = builder.stored.getValue();
        this.hasDocValues = builder.hasDocValues.getValue();
        this.isSyntheticSourceEnabled = builder.isSyntheticSourceEnabled;
    }

    @Override
    protected void parseCreateField(DocumentParserContext context) throws IOException {
        if (!this.stored && !this.hasDocValues) {
            return;
        }
        if (context.parser().currentToken() == XContentParser.Token.VALUE_NULL) {
            return;
        }
        this.indexValue(context, context.parser().binaryValue());
    }

    public void indexValue(DocumentParserContext context, byte[] value) {
        if (value == null) {
            return;
        }
        if (this.stored) {
            context.doc().add((IndexableField)new StoredField(this.fieldType().name(), value));
        }
        if (this.hasDocValues) {
            CustomBinaryDocValuesField field = (CustomBinaryDocValuesField)context.doc().getByKey(this.fieldType().name());
            if (field == null) {
                field = new CustomBinaryDocValuesField(this.fieldType().name(), value);
                context.doc().addWithKey(this.fieldType().name(), field);
            } else {
                field.add(value);
            }
        } else {
            context.addToFieldNames(this.fieldType().name());
        }
    }

    @Override
    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.leafName(), this.isSyntheticSourceEnabled).init(this);
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    protected FieldMapper.SyntheticSourceSupport syntheticSourceSupport() {
        if (this.hasDocValues) {
            BinaryDocValuesSyntheticFieldLoader loader = new BinaryDocValuesSyntheticFieldLoader(this.fullPath()){

                @Override
                protected void writeValue(XContentBuilder b, BytesRef value) throws IOException {
                    ByteArrayStreamInput in = new ByteArrayStreamInput();
                    in.reset(value.bytes, value.offset, value.length);
                    int count = in.readVInt();
                    switch (count) {
                        case 0: {
                            return;
                        }
                        case 1: {
                            b.field(BinaryFieldMapper.this.leafName());
                            break;
                        }
                        default: {
                            b.startArray(BinaryFieldMapper.this.leafName());
                        }
                    }
                    for (int i = 0; i < count; ++i) {
                        byte[] bytes = in.readByteArray();
                        b.value(Base64.getEncoder().encodeToString(bytes));
                    }
                    if (count > 1) {
                        b.endArray();
                    }
                }
            };
            return new FieldMapper.SyntheticSourceSupport.Native(loader);
        }
        return super.syntheticSourceSupport();
    }

    public static class Builder
    extends FieldMapper.Builder {
        private final FieldMapper.Parameter<Boolean> stored = FieldMapper.Parameter.storeParam(m -> BinaryFieldMapper.toType((FieldMapper)m).stored, false);
        private final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();
        private final boolean isSyntheticSourceEnabled;
        private final FieldMapper.Parameter<Boolean> hasDocValues;

        public Builder(String name, boolean isSyntheticSourceEnabled) {
            super(name);
            this.isSyntheticSourceEnabled = isSyntheticSourceEnabled;
            this.hasDocValues = FieldMapper.Parameter.docValuesParam(m -> BinaryFieldMapper.toType((FieldMapper)m).hasDocValues, isSyntheticSourceEnabled);
        }

        @Override
        public FieldMapper.Parameter<?>[] getParameters() {
            return new FieldMapper.Parameter[]{this.meta, this.stored, this.hasDocValues};
        }

        public Builder docValues(boolean hasDocValues) {
            this.hasDocValues.setValue(hasDocValues);
            return this;
        }

        @Override
        public BinaryFieldMapper build(MapperBuilderContext context) {
            return new BinaryFieldMapper(this.leafName(), new BinaryFieldType(context.buildFullName(this.leafName()), this.stored.getValue(), this.hasDocValues.getValue(), this.meta.getValue()), this.builderParams(this, context), this);
        }
    }

    public static final class CustomBinaryDocValuesField
    extends CustomDocValuesField {
        private final List<byte[]> bytesList = new ArrayList<byte[]>();

        public CustomBinaryDocValuesField(String name, byte[] bytes) {
            super(name);
            this.add(bytes);
        }

        public void add(byte[] bytes) {
            this.bytesList.add(bytes);
        }

        public BytesRef binaryValue() {
            try {
                this.bytesList.sort(Arrays::compareUnsigned);
                CollectionUtils.uniquify(this.bytesList, Arrays::compareUnsigned);
                int bytesSize = this.bytesList.stream().map(a -> ((byte[])a).length).reduce(0, Integer::sum);
                int n = this.bytesList.size();
                BytesStreamOutput out = new BytesStreamOutput(bytesSize + (n + 1) * 5);
                out.writeVInt(n);
                for (byte[] value : this.bytesList) {
                    int valueLength = value.length;
                    out.writeVInt(valueLength);
                    out.writeBytes(value, 0, valueLength);
                }
                return out.bytes().toBytesRef();
            }
            catch (IOException e) {
                throw new ElasticsearchException("Failed to get binary value", (Throwable)e, new Object[0]);
            }
        }
    }

    public static final class BinaryFieldType
    extends MappedFieldType {
        private BinaryFieldType(String name, boolean isStored, boolean hasDocValues, Map<String, String> meta) {
            super(name, false, isStored, hasDocValues, TextSearchInfo.NONE, meta);
        }

        public BinaryFieldType(String name) {
            this(name, false, true, Collections.emptyMap());
        }

        @Override
        public String typeName() {
            return BinaryFieldMapper.CONTENT_TYPE;
        }

        @Override
        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            return SourceValueFetcher.identity(this.name(), context, format);
        }

        @Override
        public DocValueFormat docValueFormat(String format, ZoneId timeZone) {
            return DocValueFormat.BINARY;
        }

        @Override
        public BytesReference valueForDisplay(Object value) {
            if (value == null) {
                return null;
            }
            BytesReference bytes = value instanceof BytesRef ? new BytesArray((BytesRef)value) : (value instanceof BytesReference ? (BytesReference)value : (value instanceof byte[] ? new BytesArray((byte[])value) : new BytesArray(Base64.getDecoder().decode(value.toString()))));
            return bytes;
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(FieldDataContext fieldDataContext) {
            this.failIfNoDocValues();
            return new BytesBinaryIndexFieldData.Builder(this.name(), CoreValuesSourceType.KEYWORD);
        }

        @Override
        public Query termQuery(Object value, SearchExecutionContext context) {
            throw new IllegalArgumentException("Binary fields do not support searching");
        }
    }
}

