/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.health;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.RecoverySource;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public final class ClusterShardHealth
implements Writeable,
ToXContentFragment {
    static final String STATUS = "status";
    static final String ACTIVE_SHARDS = "active_shards";
    static final String RELOCATING_SHARDS = "relocating_shards";
    static final String INITIALIZING_SHARDS = "initializing_shards";
    static final String UNASSIGNED_SHARDS = "unassigned_shards";
    static final String UNASSIGNED_PRIMARY_SHARDS = "unassigned_primary_shards";
    static final String PRIMARY_ACTIVE = "primary_active";
    private final int shardId;
    private final ClusterHealthStatus status;
    private final int activeShards;
    private final int relocatingShards;
    private final int initializingShards;
    private final int unassignedPrimaryShards;
    private final int unassignedShards;
    private final boolean primaryActive;

    public ClusterShardHealth(int shardId, IndexShardRoutingTable shardRoutingTable) {
        this.shardId = shardId;
        int computeActiveShards = 0;
        int computeRelocatingShards = 0;
        int computeInitializingShards = 0;
        int computeUnassignedPrimaryShards = 0;
        int computeUnassignedShards = 0;
        for (int j = 0; j < shardRoutingTable.size(); ++j) {
            ShardRouting shardRouting = shardRoutingTable.shard(j);
            if (shardRouting.active()) {
                ++computeActiveShards;
                if (!shardRouting.relocating()) continue;
                ++computeRelocatingShards;
                continue;
            }
            if (shardRouting.initializing()) {
                ++computeInitializingShards;
                continue;
            }
            if (!shardRouting.unassigned()) continue;
            if (shardRouting.primary()) {
                ++computeUnassignedPrimaryShards;
            }
            ++computeUnassignedShards;
        }
        ShardRouting primaryRouting = shardRoutingTable.primaryShard();
        ClusterHealthStatus computeStatus = primaryRouting.active() ? (computeActiveShards == shardRoutingTable.size() ? ClusterHealthStatus.GREEN : ClusterHealthStatus.YELLOW) : ClusterShardHealth.getInactivePrimaryHealth(primaryRouting);
        this.status = computeStatus;
        this.activeShards = computeActiveShards;
        this.relocatingShards = computeRelocatingShards;
        this.initializingShards = computeInitializingShards;
        this.unassignedShards = computeUnassignedShards;
        this.unassignedPrimaryShards = computeUnassignedPrimaryShards;
        this.primaryActive = primaryRouting.active();
    }

    public ClusterShardHealth(StreamInput in) throws IOException {
        this.shardId = in.readVInt();
        this.status = ClusterHealthStatus.readFrom(in);
        this.activeShards = in.readVInt();
        this.relocatingShards = in.readVInt();
        this.initializingShards = in.readVInt();
        this.unassignedShards = in.readVInt();
        this.primaryActive = in.readBoolean();
        this.unassignedPrimaryShards = in.getTransportVersion().onOrAfter(TransportVersions.UNASSIGNED_PRIMARY_COUNT_ON_CLUSTER_HEALTH) ? in.readVInt() : 0;
    }

    ClusterShardHealth(int shardId, ClusterHealthStatus status, int activeShards, int relocatingShards, int initializingShards, int unassignedShards, int unassignedPrimaryShards, boolean primaryActive) {
        this.shardId = shardId;
        this.status = status;
        this.activeShards = activeShards;
        this.relocatingShards = relocatingShards;
        this.initializingShards = initializingShards;
        this.unassignedShards = unassignedShards;
        this.unassignedPrimaryShards = unassignedPrimaryShards;
        this.primaryActive = primaryActive;
    }

    public int getShardId() {
        return this.shardId;
    }

    public ClusterHealthStatus getStatus() {
        return this.status;
    }

    public int getRelocatingShards() {
        return this.relocatingShards;
    }

    public int getActiveShards() {
        return this.activeShards;
    }

    public boolean isPrimaryActive() {
        return this.primaryActive;
    }

    public int getInitializingShards() {
        return this.initializingShards;
    }

    public int getUnassignedShards() {
        return this.unassignedShards;
    }

    public int getUnassignedPrimaryShards() {
        return this.unassignedPrimaryShards;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.shardId);
        out.writeByte(this.status.value());
        out.writeVInt(this.activeShards);
        out.writeVInt(this.relocatingShards);
        out.writeVInt(this.initializingShards);
        out.writeVInt(this.unassignedShards);
        out.writeBoolean(this.primaryActive);
        if (out.getTransportVersion().onOrAfter(TransportVersions.UNASSIGNED_PRIMARY_COUNT_ON_CLUSTER_HEALTH)) {
            out.writeVInt(this.unassignedPrimaryShards);
        }
    }

    public static ClusterHealthStatus getInactivePrimaryHealth(ShardRouting shardRouting) {
        assert (shardRouting.primary()) : "cannot invoke on a replica shard: " + String.valueOf(shardRouting);
        assert (!shardRouting.active()) : "cannot invoke on an active shard: " + String.valueOf(shardRouting);
        assert (shardRouting.unassignedInfo() != null) : "cannot invoke on a shard with no UnassignedInfo: " + String.valueOf(shardRouting);
        assert (shardRouting.recoverySource() != null) : "cannot invoke on a shard that has no recovery source" + String.valueOf(shardRouting);
        UnassignedInfo unassignedInfo = shardRouting.unassignedInfo();
        RecoverySource.Type recoveryType = shardRouting.recoverySource().getType();
        if (unassignedInfo.lastAllocationStatus() != UnassignedInfo.AllocationStatus.DECIDERS_NO && unassignedInfo.failedAllocations() == 0 && (recoveryType == RecoverySource.Type.EMPTY_STORE || recoveryType == RecoverySource.Type.LOCAL_SHARDS || recoveryType == RecoverySource.Type.SNAPSHOT)) {
            return ClusterHealthStatus.YELLOW;
        }
        return ClusterHealthStatus.RED;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(Integer.toString(this.getShardId()));
        builder.field(STATUS, this.getStatus().name().toLowerCase(Locale.ROOT));
        builder.field(PRIMARY_ACTIVE, this.isPrimaryActive());
        builder.field(ACTIVE_SHARDS, this.getActiveShards());
        builder.field(RELOCATING_SHARDS, this.getRelocatingShards());
        builder.field(INITIALIZING_SHARDS, this.getInitializingShards());
        builder.field(UNASSIGNED_SHARDS, this.getUnassignedShards());
        builder.field(UNASSIGNED_PRIMARY_SHARDS, this.getUnassignedPrimaryShards());
        builder.endObject();
        return builder;
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClusterShardHealth)) {
            return false;
        }
        ClusterShardHealth that = (ClusterShardHealth)o;
        return this.shardId == that.shardId && this.activeShards == that.activeShards && this.relocatingShards == that.relocatingShards && this.initializingShards == that.initializingShards && this.unassignedShards == that.unassignedShards && this.unassignedPrimaryShards == that.unassignedPrimaryShards && this.primaryActive == that.primaryActive && this.status == that.status;
    }

    public int hashCode() {
        return Objects.hash(this.shardId, this.status, this.activeShards, this.relocatingShards, this.initializingShards, this.unassignedShards, this.unassignedPrimaryShards, this.primaryActive);
    }
}

