/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.cluster.metadata.ComponentTemplate;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;

public class SimulateBulkRequest
extends BulkRequest {
    private final Map<String, Map<String, Object>> pipelineSubstitutions;
    private final Map<String, Map<String, Object>> componentTemplateSubstitutions;
    private final Map<String, Map<String, Object>> indexTemplateSubstitutions;
    private final Map<String, Object> mappingAddition;

    public SimulateBulkRequest(Map<String, Map<String, Object>> pipelineSubstitutions, Map<String, Map<String, Object>> componentTemplateSubstitutions, Map<String, Map<String, Object>> indexTemplateSubstitutions, Map<String, Object> mappingAddition) {
        Objects.requireNonNull(pipelineSubstitutions);
        Objects.requireNonNull(componentTemplateSubstitutions);
        Objects.requireNonNull(indexTemplateSubstitutions);
        Objects.requireNonNull(mappingAddition);
        this.pipelineSubstitutions = pipelineSubstitutions;
        this.componentTemplateSubstitutions = componentTemplateSubstitutions;
        this.indexTemplateSubstitutions = indexTemplateSubstitutions;
        this.mappingAddition = mappingAddition;
    }

    public SimulateBulkRequest(StreamInput in) throws IOException {
        super(in);
        this.pipelineSubstitutions = (Map)in.readGenericValue();
        this.componentTemplateSubstitutions = in.getTransportVersion().onOrAfter(TransportVersions.SIMULATE_COMPONENT_TEMPLATES_SUBSTITUTIONS) ? (Map)in.readGenericValue() : Map.of();
        this.indexTemplateSubstitutions = in.getTransportVersion().onOrAfter(TransportVersions.SIMULATE_INDEX_TEMPLATES_SUBSTITUTIONS) ? (Map)in.readGenericValue() : Map.of();
        this.mappingAddition = in.getTransportVersion().onOrAfter(TransportVersions.SIMULATE_MAPPING_ADDITION) ? (Map)in.readGenericValue() : Map.of();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeGenericValue(this.pipelineSubstitutions);
        if (out.getTransportVersion().onOrAfter(TransportVersions.SIMULATE_COMPONENT_TEMPLATES_SUBSTITUTIONS)) {
            out.writeGenericValue(this.componentTemplateSubstitutions);
        }
        if (out.getTransportVersion().onOrAfter(TransportVersions.SIMULATE_INDEX_TEMPLATES_SUBSTITUTIONS)) {
            out.writeGenericValue(this.indexTemplateSubstitutions);
        }
        if (out.getTransportVersion().onOrAfter(TransportVersions.SIMULATE_MAPPING_ADDITION)) {
            out.writeGenericValue(this.mappingAddition);
        }
    }

    public Map<String, Map<String, Object>> getPipelineSubstitutions() {
        return this.pipelineSubstitutions;
    }

    @Override
    public boolean isSimulated() {
        return true;
    }

    @Override
    public Map<String, ComponentTemplate> getComponentTemplateSubstitutions() {
        return this.componentTemplateSubstitutions.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> SimulateBulkRequest.convertRawTemplateToComponentTemplate((Map)entry.getValue())));
    }

    @Override
    public Map<String, ComposableIndexTemplate> getIndexTemplateSubstitutions() {
        return this.indexTemplateSubstitutions.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> SimulateBulkRequest.convertRawTemplateToIndexTemplate((Map)entry.getValue())));
    }

    public Map<String, Object> getMappingAddition() {
        return this.mappingAddition;
    }

    private static ComponentTemplate convertRawTemplateToComponentTemplate(Map<String, Object> rawTemplate) {
        ComponentTemplate componentTemplate;
        try (XContentParser parser = XContentHelper.mapToXContentParser(XContentParserConfiguration.EMPTY, rawTemplate);){
            componentTemplate = ComponentTemplate.parse(parser);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return componentTemplate;
    }

    private static ComposableIndexTemplate convertRawTemplateToIndexTemplate(Map<String, Object> rawTemplate) {
        ComposableIndexTemplate indexTemplate;
        try (XContentParser parser = XContentHelper.mapToXContentParser(XContentParserConfiguration.EMPTY, rawTemplate);){
            indexTemplate = ComposableIndexTemplate.parse(parser);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return indexTemplate;
    }

    @Override
    public BulkRequest shallowClone() {
        SimulateBulkRequest bulkRequest = new SimulateBulkRequest(this.pipelineSubstitutions, this.componentTemplateSubstitutions, this.indexTemplateSubstitutions, this.mappingAddition);
        bulkRequest.setRefreshPolicy(this.getRefreshPolicy());
        bulkRequest.waitForActiveShards(this.waitForActiveShards());
        bulkRequest.timeout(this.timeout());
        bulkRequest.pipeline(this.pipeline());
        bulkRequest.routing(this.routing());
        bulkRequest.requireAlias(this.requireAlias());
        bulkRequest.requireDataStream(this.requireDataStream());
        return bulkRequest;
    }
}

