/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.stats;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public final class SearchUsageStats
implements Writeable,
ToXContentFragment {
    private long totalSearchCount;
    private final Map<String, Long> queries;
    private final Map<String, Long> rescorers;
    private final Map<String, Long> sections;
    private final Map<String, Long> retrievers;

    public SearchUsageStats() {
        this.totalSearchCount = 0L;
        this.queries = new HashMap<String, Long>();
        this.sections = new HashMap<String, Long>();
        this.rescorers = new HashMap<String, Long>();
        this.retrievers = new HashMap<String, Long>();
    }

    public SearchUsageStats(Map<String, Long> queries, Map<String, Long> rescorers, Map<String, Long> sections, Map<String, Long> retrievers, long totalSearchCount) {
        this.totalSearchCount = totalSearchCount;
        this.queries = queries;
        this.sections = sections;
        this.rescorers = rescorers;
        this.retrievers = retrievers;
    }

    public SearchUsageStats(StreamInput in) throws IOException {
        this.queries = in.readMap(StreamInput::readLong);
        this.sections = in.readMap(StreamInput::readLong);
        this.totalSearchCount = in.readVLong();
        this.rescorers = in.getTransportVersion().onOrAfter(TransportVersions.V_8_12_0) ? in.readMap(StreamInput::readLong) : Map.of();
        this.retrievers = in.getTransportVersion().onOrAfter(TransportVersions.RETRIEVERS_TELEMETRY_ADDED) ? in.readMap(StreamInput::readLong) : Map.of();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.queries, StreamOutput::writeLong);
        out.writeMap(this.sections, StreamOutput::writeLong);
        out.writeVLong(this.totalSearchCount);
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_12_0)) {
            out.writeMap(this.rescorers, StreamOutput::writeLong);
        }
        if (out.getTransportVersion().onOrAfter(TransportVersions.RETRIEVERS_TELEMETRY_ADDED)) {
            out.writeMap(this.retrievers, StreamOutput::writeLong);
        }
    }

    public void add(SearchUsageStats stats) {
        stats.queries.forEach((query, count) -> this.queries.merge((String)query, (Long)count, Long::sum));
        stats.rescorers.forEach((rescorer, count) -> this.rescorers.merge((String)rescorer, (Long)count, Long::sum));
        stats.sections.forEach((query, count) -> this.sections.merge((String)query, (Long)count, Long::sum));
        stats.retrievers.forEach((query, count) -> this.retrievers.merge((String)query, (Long)count, Long::sum));
        this.totalSearchCount += stats.totalSearchCount;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("search");
        builder.field("total", this.totalSearchCount);
        builder.field("queries");
        builder.map(this.queries);
        builder.field("rescorers");
        builder.map(this.rescorers);
        builder.field("sections");
        builder.map(this.sections);
        builder.field("retrievers");
        builder.map(this.retrievers);
        builder.endObject();
        return builder;
    }

    public Map<String, Long> getQueryUsage() {
        return Collections.unmodifiableMap(this.queries);
    }

    public Map<String, Long> getRescorerUsage() {
        return Collections.unmodifiableMap(this.rescorers);
    }

    public Map<String, Long> getSectionsUsage() {
        return Collections.unmodifiableMap(this.sections);
    }

    public Map<String, Long> getRetrieversUsage() {
        return Collections.unmodifiableMap(this.retrievers);
    }

    public long getTotalSearchCount() {
        return this.totalSearchCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchUsageStats that = (SearchUsageStats)o;
        return this.totalSearchCount == that.totalSearchCount && this.queries.equals(that.queries) && this.rescorers.equals(that.rescorers) && this.sections.equals(that.sections) && this.retrievers.equals(that.retrievers);
    }

    public int hashCode() {
        return Objects.hash(this.totalSearchCount, this.queries, this.rescorers, this.sections, this.retrievers);
    }

    public String toString() {
        return Strings.toString((ToXContent)this, true, true);
    }
}

