/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.stats;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.action.admin.cluster.stats.CCSUsageTelemetry;
import org.elasticsearch.action.search.SearchPhaseExecutionException;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.query.SearchTimeoutException;
import org.elasticsearch.tasks.TaskCancelledException;

public class CCSUsage {
    private final long took;
    private final CCSUsageTelemetry.Result status;
    private final Set<String> features;
    private final int remotesCount;
    private final String client;
    private final Set<String> skippedRemotes;
    private final Map<String, PerClusterUsage> perClusterUsage;

    private CCSUsage(long took, CCSUsageTelemetry.Result status, int remotesCount, Set<String> skippedRemotes, Set<String> features, String client, Map<String, PerClusterUsage> perClusterUsage) {
        this.status = status;
        this.remotesCount = remotesCount;
        this.features = features;
        this.client = client;
        this.took = took;
        this.skippedRemotes = skippedRemotes;
        this.perClusterUsage = perClusterUsage;
    }

    public Map<String, PerClusterUsage> getPerClusterUsage() {
        return this.perClusterUsage;
    }

    public CCSUsageTelemetry.Result getStatus() {
        return this.status;
    }

    public Set<String> getFeatures() {
        return this.features;
    }

    public long getRemotesCount() {
        return this.remotesCount;
    }

    public String getClient() {
        return this.client;
    }

    public long getTook() {
        return this.took;
    }

    public Set<String> getSkippedRemotes() {
        return this.skippedRemotes;
    }

    public static class PerClusterUsage {
        private long took;

        public PerClusterUsage(TimeValue took) {
            if (took != null) {
                this.took = took.millis();
            }
        }

        public long getTook() {
            return this.took;
        }
    }

    public static class Builder {
        private long took;
        private final Set<String> features;
        private CCSUsageTelemetry.Result status = CCSUsageTelemetry.Result.SUCCESS;
        private int remotesCount;
        private String client;
        private final Set<String> skippedRemotes;
        private final Map<String, PerClusterUsage> perClusterUsage;

        public Builder() {
            this.features = new HashSet<String>();
            this.skippedRemotes = new HashSet<String>();
            this.perClusterUsage = new HashMap<String, PerClusterUsage>();
        }

        public Builder took(long took) {
            this.took = took;
            return this;
        }

        public Builder setFailure(CCSUsageTelemetry.Result failureType) {
            this.status = failureType;
            return this;
        }

        public Builder setFailure(Exception e) {
            return this.setFailure(Builder.getFailureType(e));
        }

        public Builder setFeature(String feature) {
            this.features.add(feature);
            return this;
        }

        public Builder setClient(String client) {
            this.client = client;
            return this;
        }

        public Builder skippedRemote(String remote) {
            this.skippedRemotes.add(remote);
            return this;
        }

        public Builder perClusterUsage(String remote, TimeValue took) {
            this.perClusterUsage.put(remote, new PerClusterUsage(took));
            return this;
        }

        public CCSUsage build() {
            return new CCSUsage(this.took, this.status, this.remotesCount, this.skippedRemotes, this.features, this.client, this.perClusterUsage);
        }

        public Builder setRemotesCount(int remotesCount) {
            this.remotesCount = remotesCount;
            return this;
        }

        public int getRemotesCount() {
            return this.remotesCount;
        }

        public static CCSUsageTelemetry.Result getFailureType(Exception e) {
            SearchPhaseExecutionException spe;
            ShardOperationFailedException[] groupedFails;
            Throwable unwrapped = ExceptionsHelper.unwrapCause(e);
            if (unwrapped instanceof Exception) {
                e = (Exception)unwrapped;
            }
            if (ExceptionsHelper.isRemoteUnavailableException(e)) {
                return CCSUsageTelemetry.Result.REMOTES_UNAVAILABLE;
            }
            if (ExceptionsHelper.unwrap(e, ResourceNotFoundException.class) != null) {
                return CCSUsageTelemetry.Result.NOT_FOUND;
            }
            if (e instanceof TaskCancelledException || ExceptionsHelper.unwrap(e, TaskCancelledException.class) != null) {
                return CCSUsageTelemetry.Result.CANCELED;
            }
            if (ExceptionsHelper.unwrap(e, SearchTimeoutException.class) != null) {
                return CCSUsageTelemetry.Result.TIMEOUT;
            }
            if (ExceptionsHelper.unwrap(e, ElasticsearchSecurityException.class) != null) {
                return CCSUsageTelemetry.Result.SECURITY;
            }
            if (ExceptionsHelper.unwrapCorruption(e) != null) {
                return CCSUsageTelemetry.Result.CORRUPTION;
            }
            if (e instanceof SearchPhaseExecutionException && Arrays.stream(groupedFails = ExceptionsHelper.groupBy((spe = (SearchPhaseExecutionException)e).shardFailures())).allMatch(Builder::isRemoteFailure)) {
                return CCSUsageTelemetry.Result.REMOTES_UNAVAILABLE;
            }
            return CCSUsageTelemetry.Result.UNKNOWN;
        }

        static boolean isRemoteFailure(ShardOperationFailedException failure) {
            if (failure instanceof ShardSearchFailure) {
                ShardSearchFailure shardFailure = (ShardSearchFailure)failure;
                SearchShardTarget shard = shardFailure.shard();
                return shard != null && shard.getClusterAlias() != null && !"".equals(shard.getClusterAlias());
            }
            return false;
        }
    }
}

