/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action;

import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.bulk.IndexDocFailureStoreStatus;
import org.elasticsearch.action.support.WriteResponse;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public abstract class DocWriteResponse
extends ReplicationResponse
implements WriteResponse,
ToXContentObject {
    public static final String _SHARDS = "_shards";
    public static final String _INDEX = "_index";
    public static final String _ID = "_id";
    public static final String _VERSION = "_version";
    public static final String _SEQ_NO = "_seq_no";
    public static final String _PRIMARY_TERM = "_primary_term";
    public static final String RESULT = "result";
    public static final String FORCED_REFRESH = "forced_refresh";
    private final ShardId shardId;
    private final String id;
    private final long version;
    private final long seqNo;
    private final long primaryTerm;
    private boolean forcedRefresh;
    protected final Result result;

    public DocWriteResponse(ShardId shardId, String id, long seqNo, long primaryTerm, long version, Result result) {
        this.shardId = Objects.requireNonNull(shardId);
        this.id = Objects.requireNonNull(id);
        this.seqNo = seqNo;
        this.primaryTerm = primaryTerm;
        this.version = version;
        this.result = Objects.requireNonNull(result);
    }

    protected DocWriteResponse(ShardId shardId, StreamInput in) throws IOException {
        super(in);
        this.shardId = shardId;
        if (in.getTransportVersion().before(TransportVersions.V_8_0_0)) {
            String type = in.readString();
            assert ("_doc".equals(type)) : "Expected [_doc] but received [" + type + "]";
        }
        this.id = in.readString();
        this.version = in.readZLong();
        this.seqNo = in.readZLong();
        this.primaryTerm = in.readVLong();
        this.forcedRefresh = in.readBoolean();
        this.result = Result.readFrom(in);
    }

    protected DocWriteResponse(StreamInput in) throws IOException {
        super(in);
        this.shardId = new ShardId(in);
        if (in.getTransportVersion().before(TransportVersions.V_8_0_0)) {
            String type = in.readString();
            assert ("_doc".equals(type)) : "Expected [_doc] but received [" + type + "]";
        }
        this.id = in.readString();
        this.version = in.readZLong();
        this.seqNo = in.readZLong();
        this.primaryTerm = in.readVLong();
        this.forcedRefresh = in.readBoolean();
        this.result = Result.readFrom(in);
    }

    public Result getResult() {
        return this.result;
    }

    public String getIndex() {
        return this.shardId.getIndexName();
    }

    public ShardId getShardId() {
        return this.shardId;
    }

    public String getId() {
        return this.id;
    }

    public long getVersion() {
        return this.version;
    }

    public long getSeqNo() {
        return this.seqNo;
    }

    public long getPrimaryTerm() {
        return this.primaryTerm;
    }

    public boolean forcedRefresh() {
        return this.forcedRefresh;
    }

    @Override
    public void setForcedRefresh(boolean forcedRefresh) {
        this.forcedRefresh = forcedRefresh;
    }

    public RestStatus status() {
        return this.getShardInfo().status();
    }

    public String getLocation(@Nullable String routing) {
        String encodedIndex = URLEncoder.encode(this.getIndex(), StandardCharsets.UTF_8);
        String encodedType = URLEncoder.encode("_doc", StandardCharsets.UTF_8);
        String encodedId = URLEncoder.encode(this.getId(), StandardCharsets.UTF_8);
        String encodedRouting = routing == null ? null : URLEncoder.encode(routing, StandardCharsets.UTF_8);
        String routingStart = "?routing=";
        int bufferSizeExcludingRouting = 3 + encodedIndex.length() + encodedType.length() + encodedId.length();
        int bufferSize = encodedRouting == null ? bufferSizeExcludingRouting : bufferSizeExcludingRouting + "?routing=".length() + encodedRouting.length();
        StringBuilder location = new StringBuilder(bufferSize);
        location.append('/').append(encodedIndex);
        location.append('/').append(encodedType);
        location.append('/').append(encodedId);
        if (encodedRouting != null) {
            location.append("?routing=").append(encodedRouting);
        }
        return location.toString();
    }

    public IndexDocFailureStoreStatus getFailureStoreStatus() {
        return IndexDocFailureStoreStatus.NOT_APPLICABLE_OR_UNKNOWN;
    }

    public void writeThin(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.writeWithoutShardId(out);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.shardId.writeTo(out);
        this.writeWithoutShardId(out);
    }

    private void writeWithoutShardId(StreamOutput out) throws IOException {
        if (out.getTransportVersion().before(TransportVersions.V_8_0_0)) {
            out.writeString("_doc");
        }
        out.writeString(this.id);
        out.writeZLong(this.version);
        out.writeZLong(this.seqNo);
        out.writeVLong(this.primaryTerm);
        out.writeBoolean(this.forcedRefresh);
        this.result.writeTo(out);
    }

    public final XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.innerToXContent(builder, params);
        builder.endObject();
        return builder;
    }

    public XContentBuilder innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        ReplicationResponse.ShardInfo shardInfo = this.getShardInfo();
        builder.field(_INDEX, this.shardId.getIndexName());
        builder.field(_ID, this.id).field(_VERSION, this.version).field(RESULT, this.getResult().getLowercase());
        if (this.forcedRefresh) {
            builder.field(FORCED_REFRESH, true);
        }
        builder.field(_SHARDS, (ToXContent)shardInfo);
        if (this.getSeqNo() >= 0L) {
            builder.field(_SEQ_NO, this.getSeqNo());
            builder.field(_PRIMARY_TERM, this.getPrimaryTerm());
        }
        if (builder.getRestApiVersion() == RestApiVersion.V_7) {
            builder.field("_type", "_doc");
        }
        return builder;
    }

    public static enum Result implements Writeable
    {
        CREATED(0),
        UPDATED(1),
        DELETED(2),
        NOT_FOUND(3),
        NOOP(4);

        private final byte op;
        private final String lowercase;

        private Result(int op) {
            this.op = (byte)op;
            this.lowercase = this.name().toLowerCase(Locale.ROOT);
        }

        public byte getOp() {
            return this.op;
        }

        public String getLowercase() {
            return this.lowercase;
        }

        public static Result readFrom(StreamInput in) throws IOException {
            Byte opcode = in.readByte();
            return switch (opcode) {
                case 0 -> CREATED;
                case 1 -> UPDATED;
                case 2 -> DELETED;
                case 3 -> NOT_FOUND;
                case 4 -> NOOP;
                default -> throw new IllegalArgumentException("Unknown result code: " + opcode);
            };
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeByte(this.op);
        }
    }

    public static abstract class Builder {
        protected ShardId shardId = null;
        protected String id = null;
        protected Long version = null;
        protected Result result = null;
        protected boolean forcedRefresh;
        protected ReplicationResponse.ShardInfo shardInfo = null;
        protected long seqNo = -2L;
        protected long primaryTerm = 0L;

        public ShardId getShardId() {
            return this.shardId;
        }

        public void setShardId(ShardId shardId) {
            this.shardId = shardId;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setVersion(Long version) {
            this.version = version;
        }

        public void setResult(Result result) {
            this.result = result;
        }

        public void setForcedRefresh(boolean forcedRefresh) {
            this.forcedRefresh = forcedRefresh;
        }

        public void setShardInfo(ReplicationResponse.ShardInfo shardInfo) {
            this.shardInfo = shardInfo;
        }

        public void setSeqNo(long seqNo) {
            this.seqNo = seqNo;
        }

        public void setPrimaryTerm(long primaryTerm) {
            this.primaryTerm = primaryTerm;
        }

        public abstract DocWriteResponse build();
    }
}

