/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.analysis.common;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.compound.HyphenationCompoundWordTokenFilter;
import org.apache.lucene.analysis.compound.hyphenation.HyphenationTree;
import org.elasticsearch.analysis.common.AbstractCompoundWordTokenFilterFactory;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.xml.sax.InputSource;

public class HyphenationCompoundWordTokenFilterFactory
extends AbstractCompoundWordTokenFilterFactory {
    private final boolean noSubMatches;
    private final boolean noOverlappingMatches;
    private final HyphenationTree hyphenationTree;

    HyphenationCompoundWordTokenFilterFactory(IndexSettings indexSettings, Environment env, String name, Settings settings) {
        super(indexSettings, env, name, settings);
        String hyphenationPatternsPath = settings.get("hyphenation_patterns_path", null);
        if (hyphenationPatternsPath == null) {
            throw new IllegalArgumentException("hyphenation_patterns_path is a required setting.");
        }
        Path hyphenationPatternsFile = env.configFile().resolve(hyphenationPatternsPath);
        try {
            InputStream in = Files.newInputStream(hyphenationPatternsFile, new OpenOption[0]);
            this.hyphenationTree = HyphenationCompoundWordTokenFilter.getHyphenationTree((InputSource)new InputSource(in));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Exception while reading hyphenation_patterns_path.", e);
        }
        this.noSubMatches = settings.getAsBoolean("no_sub_matches", Boolean.valueOf(false));
        this.noOverlappingMatches = settings.getAsBoolean("no_overlapping_matches", Boolean.valueOf(false));
    }

    public TokenStream create(TokenStream tokenStream) {
        return new HyphenationCompoundWordTokenFilter(tokenStream, this.hyphenationTree, this.wordList, this.minWordSize, this.minSubwordSize, this.maxSubwordSize, this.onlyLongestMatch, this.noSubMatches, this.noOverlappingMatches);
    }
}

