/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.premain.common.util;

import co.elastic.apm.agent.premain.common.JvmRuntimeInfo;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.nio.file.attribute.UserPrincipal;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.EnumSet;

public class ResourceExtractionUtil {
    public static synchronized Path extractResourceToTempDirectory(String resource, String prefix, String suffix) {
        return ResourceExtractionUtil.extractResourceToDirectory(resource, prefix, suffix, Paths.get(System.getProperty("java.io.tmpdir"), new String[0]));
    }

    public static synchronized Path extractResourceToDirectory(String resource, String prefix, String suffix, Path directory) {
        Path path;
        block38: {
            InputStream resourceStream = ResourceExtractionUtil.class.getResourceAsStream("/" + resource);
            try {
                if (resourceStream == null) {
                    throw new IllegalStateException(resource + " not found");
                }
                UserPrincipal currentUserPrincipal = ResourceExtractionUtil.getCurrentUserPrincipal();
                String userHash = ResourceExtractionUtil.hash(currentUserPrincipal.getName());
                String resourceHash = ResourceExtractionUtil.hash(ResourceExtractionUtil.class.getResourceAsStream("/" + resource));
                Path tempFile = directory.resolve(prefix + "-" + userHash.substring(0, 32) + "-" + resourceHash.substring(0, 32) + suffix);
                try {
                    FileAttribute[] attr = tempFile.getFileSystem().supportedFileAttributeViews().contains("posix") ? new FileAttribute[]{PosixFilePermissions.asFileAttribute(EnumSet.of(PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_READ))} : new FileAttribute[]{};
                    try (FileChannel channel = FileChannel.open(tempFile, EnumSet.of(StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE), attr);
                         FileLock writeLock = channel.lock();){
                        channel.transferFrom(Channels.newChannel(resourceStream), 0L, Long.MAX_VALUE);
                    }
                }
                catch (FileAlreadyExistsException e) {
                    try (FileChannel channel = JvmRuntimeInfo.ofCurrentVM().isZos() ? FileChannel.open(tempFile, StandardOpenOption.READ) : FileChannel.open(tempFile, StandardOpenOption.READ, LinkOption.NOFOLLOW_LINKS);
                         FileLock readLock = channel.lock(0L, Long.MAX_VALUE, true);){
                        if (!ResourceExtractionUtil.hash(Files.newInputStream(tempFile, new OpenOption[0])).equals(resourceHash)) {
                            throw new IllegalStateException("Invalid checksum of " + tempFile + ". Please delete this file.");
                        }
                        if (!Files.getOwner(tempFile, new LinkOption[0]).equals(currentUserPrincipal)) {
                            throw new IllegalStateException("File " + tempFile + " is not owned by '" + currentUserPrincipal.getName() + "'. Please delete this file.");
                        }
                    }
                }
                path = tempFile.toAbsolutePath();
                if (resourceStream == null) break block38;
            }
            catch (Throwable throwable) {
                try {
                    if (resourceStream != null) {
                        try {
                            resourceStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | NoSuchAlgorithmException e) {
                    throw new IllegalStateException(e);
                }
            }
            resourceStream.close();
        }
        return path;
    }

    private static UserPrincipal getCurrentUserPrincipal() throws IOException {
        Path whoami = Files.createTempFile("whoami", ".tmp", new FileAttribute[0]);
        try {
            UserPrincipal userPrincipal = Files.getOwner(whoami, new LinkOption[0]);
            return userPrincipal;
        }
        finally {
            Files.delete(whoami);
        }
    }

    private static String hash(InputStream resourceAsStream) throws IOException, NoSuchAlgorithmException {
        try (InputStream is = resourceAsStream;){
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] buffer = new byte[1024];
            DigestInputStream dis = new DigestInputStream(is, md);
            while (dis.read(buffer) != -1) {
            }
            String string = new BigInteger(1, md.digest()).toString(16);
            return string;
        }
    }

    private static String hash(String s) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        md.update(s.getBytes());
        return new BigInteger(1, md.digest()).toString(16);
    }
}

