/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.expression.function.scalar.string;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.eql.EqlIllegalArgumentException;
import org.elasticsearch.xpack.ql.expression.gen.processor.Processor;

public class LengthFunctionProcessor
implements Processor {
    public static final String NAME = "slen";
    private final Processor input;

    public LengthFunctionProcessor(Processor input) {
        this.input = input;
    }

    public LengthFunctionProcessor(StreamInput in) throws IOException {
        this.input = (Processor)in.readNamedWriteable(Processor.class);
    }

    public final void writeTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable((NamedWriteable)this.input);
    }

    public Object process(Object o) {
        return LengthFunctionProcessor.doProcess(this.input.process(o));
    }

    public static Object doProcess(Object input) {
        if (input == null) {
            return null;
        }
        if (!(input instanceof String) && !(input instanceof Character)) {
            throw new EqlIllegalArgumentException("A string/char is required; received [{}]", input);
        }
        return input.toString().length();
    }

    protected Processor input() {
        return this.input;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return Objects.equals(this.input(), ((LengthFunctionProcessor)obj).input());
    }

    public int hashCode() {
        return Objects.hash(this.input());
    }

    public String getWriteableName() {
        return NAME;
    }
}

