/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.planner.mapper;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.compute.aggregation.AggregatorMode;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BlockUtils;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.plan.logical.Aggregate;
import org.elasticsearch.xpack.esql.plan.logical.Dissect;
import org.elasticsearch.xpack.esql.plan.logical.Enrich;
import org.elasticsearch.xpack.esql.plan.logical.Eval;
import org.elasticsearch.xpack.esql.plan.logical.Filter;
import org.elasticsearch.xpack.esql.plan.logical.Grok;
import org.elasticsearch.xpack.esql.plan.logical.LeafPlan;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.MvExpand;
import org.elasticsearch.xpack.esql.plan.logical.Project;
import org.elasticsearch.xpack.esql.plan.logical.Row;
import org.elasticsearch.xpack.esql.plan.logical.UnaryPlan;
import org.elasticsearch.xpack.esql.plan.logical.local.LocalRelation;
import org.elasticsearch.xpack.esql.plan.logical.local.LocalSupplier;
import org.elasticsearch.xpack.esql.plan.logical.show.ShowInfo;
import org.elasticsearch.xpack.esql.plan.physical.AggregateExec;
import org.elasticsearch.xpack.esql.plan.physical.DissectExec;
import org.elasticsearch.xpack.esql.plan.physical.EnrichExec;
import org.elasticsearch.xpack.esql.plan.physical.EvalExec;
import org.elasticsearch.xpack.esql.plan.physical.FilterExec;
import org.elasticsearch.xpack.esql.plan.physical.GrokExec;
import org.elasticsearch.xpack.esql.plan.physical.LimitExec;
import org.elasticsearch.xpack.esql.plan.physical.LocalSourceExec;
import org.elasticsearch.xpack.esql.plan.physical.MvExpandExec;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.plan.physical.ProjectExec;
import org.elasticsearch.xpack.esql.plan.physical.ShowExec;
import org.elasticsearch.xpack.esql.planner.AbstractPhysicalOperationProviders;
import org.elasticsearch.xpack.esql.planner.PlannerUtils;

class MapperUtils {
    private MapperUtils() {
    }

    static PhysicalPlan mapLeaf(LeafPlan p) {
        if (p instanceof Row) {
            Row row = (Row)p;
            List<Alias> fields = row.fields();
            ArrayList<Object> values = new ArrayList<Object>(fields.size());
            for (Alias field : fields) {
                values.add(field.child().fold());
            }
            Block[] blocks = BlockUtils.fromListRow((BlockFactory)PlannerUtils.NON_BREAKING_BLOCK_FACTORY, values);
            p = new LocalRelation(row.source(), row.output(), LocalSupplier.of(blocks));
        }
        if (p instanceof LocalRelation) {
            LocalRelation local = (LocalRelation)p;
            return new LocalSourceExec(local.source(), local.output(), local.supplier());
        }
        if (p instanceof ShowInfo) {
            ShowInfo showInfo = (ShowInfo)p;
            return new ShowExec(showInfo.source(), showInfo.output(), showInfo.values());
        }
        return MapperUtils.unsupported(p);
    }

    static PhysicalPlan mapUnary(UnaryPlan p, PhysicalPlan child) {
        if (p instanceof Filter) {
            Filter f = (Filter)p;
            return new FilterExec(f.source(), child, f.condition());
        }
        if (p instanceof Project) {
            Project pj = (Project)p;
            return new ProjectExec(pj.source(), child, pj.projections());
        }
        if (p instanceof Eval) {
            Eval eval = (Eval)p;
            return new EvalExec(eval.source(), child, eval.fields());
        }
        if (p instanceof Dissect) {
            Dissect dissect = (Dissect)p;
            return new DissectExec(dissect.source(), child, dissect.input(), dissect.parser(), dissect.extractedFields());
        }
        if (p instanceof Grok) {
            Grok grok = (Grok)p;
            return new GrokExec(grok.source(), child, grok.input(), grok.parser(), grok.extractedFields());
        }
        if (p instanceof Enrich) {
            Enrich enrich = (Enrich)p;
            return new EnrichExec(enrich.source(), child, enrich.mode(), enrich.policy().getType(), enrich.matchField(), BytesRefs.toString((Object)enrich.policyName().fold()), enrich.policy().getMatchField(), enrich.concreteIndices(), enrich.enrichFields());
        }
        if (p instanceof MvExpand) {
            MvExpand mvExpand = (MvExpand)p;
            MvExpandExec result = new MvExpandExec(mvExpand.source(), child, mvExpand.target(), mvExpand.expanded());
            if (mvExpand.limit() != null) {
                return new LimitExec(result.source(), result, (Expression)new Literal(Source.EMPTY, (Object)mvExpand.limit(), DataType.INTEGER));
            }
            return result;
        }
        return MapperUtils.unsupported(p);
    }

    static List<Attribute> intermediateAttributes(Aggregate aggregate) {
        List<Attribute> intermediateAttributes = AbstractPhysicalOperationProviders.intermediateAttributes(aggregate.aggregates(), aggregate.groupings());
        return intermediateAttributes;
    }

    static AggregateExec aggExec(Aggregate aggregate, PhysicalPlan child, AggregatorMode aggMode, List<Attribute> intermediateAttributes) {
        return new AggregateExec(aggregate.source(), child, aggregate.groupings(), aggregate.aggregates(), aggMode, intermediateAttributes, null);
    }

    static PhysicalPlan unsupported(LogicalPlan p) {
        throw new EsqlIllegalArgumentException("unsupported logical plan node [" + p.nodeName() + "]");
    }
}

