/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.planner;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.xpack.esql.core.QlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;
import org.elasticsearch.xpack.esql.core.expression.Foldables;
import org.elasticsearch.xpack.esql.core.expression.TypedAttribute;
import org.elasticsearch.xpack.esql.core.expression.function.scalar.ScalarFunction;
import org.elasticsearch.xpack.esql.core.expression.predicate.Range;
import org.elasticsearch.xpack.esql.core.expression.predicate.operator.comparison.BinaryComparison;
import org.elasticsearch.xpack.esql.core.planner.ExpressionTranslator;
import org.elasticsearch.xpack.esql.core.planner.ExpressionTranslators;
import org.elasticsearch.xpack.esql.core.planner.TranslatorHandler;
import org.elasticsearch.xpack.esql.core.querydsl.query.MatchAll;
import org.elasticsearch.xpack.esql.core.querydsl.query.MatchQuery;
import org.elasticsearch.xpack.esql.core.querydsl.query.NotQuery;
import org.elasticsearch.xpack.esql.core.querydsl.query.Query;
import org.elasticsearch.xpack.esql.core.querydsl.query.QueryStringQuery;
import org.elasticsearch.xpack.esql.core.querydsl.query.RangeQuery;
import org.elasticsearch.xpack.esql.core.querydsl.query.TermQuery;
import org.elasticsearch.xpack.esql.core.querydsl.query.TermsQuery;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.Check;
import org.elasticsearch.xpack.esql.core.util.NumericUtils;
import org.elasticsearch.xpack.esql.expression.function.fulltext.Match;
import org.elasticsearch.xpack.esql.expression.function.fulltext.QueryString;
import org.elasticsearch.xpack.esql.expression.function.scalar.ip.CIDRMatch;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialRelatesFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialRelatesUtils;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.Equals;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.GreaterThan;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.GreaterThanOrEqual;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.In;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.InsensitiveEquals;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.LessThan;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.LessThanOrEqual;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.NotEquals;
import org.elasticsearch.xpack.esql.querydsl.query.SpatialRelatesQuery;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeConverter;
import org.elasticsearch.xpack.versionfield.Version;

public final class EsqlExpressionTranslators {
    public static final List<ExpressionTranslator<?>> QUERY_TRANSLATORS = List.of(new ExpressionTranslator[]{new EqualsIgnoreCaseTranslator(), new BinaryComparisons(), new SpatialRelatesTranslator(), new InComparisons(), new Ranges(), new ExpressionTranslators.BinaryLogic(), new ExpressionTranslators.IsNulls(), new ExpressionTranslators.IsNotNulls(), new ExpressionTranslators.Nots(), new ExpressionTranslators.Likes(), new ExpressionTranslators.StringQueries(), new ExpressionTranslators.MultiMatches(), new MatchFunctionTranslator(), new QueryStringFunctionTranslator(), new Scalars()});

    public static Query toQuery(Expression e, TranslatorHandler handler) {
        Query translation = null;
        for (ExpressionTranslator<?> translator : QUERY_TRANSLATORS) {
            translation = translator.translate(e, handler);
            if (translation == null) continue;
            return translation;
        }
        throw new QlIllegalArgumentException("Don't know how to translate {} {}", new Object[]{e.nodeName(), e});
    }

    public static class EqualsIgnoreCaseTranslator
    extends ExpressionTranslator<InsensitiveEquals> {
        protected Query asQuery(InsensitiveEquals bc, TranslatorHandler handler) {
            return EqualsIgnoreCaseTranslator.doTranslate(bc, handler);
        }

        public static Query doTranslate(InsensitiveEquals bc, TranslatorHandler handler) {
            EqualsIgnoreCaseTranslator.checkInsensitiveComparison(bc);
            return handler.wrapFunctionQuery((ScalarFunction)bc, bc.left(), () -> EqualsIgnoreCaseTranslator.translate(bc));
        }

        public static void checkInsensitiveComparison(InsensitiveEquals bc) {
            Check.isTrue((boolean)bc.right().foldable(), (String)"Line {}:{}: Comparisons against fields are not (currently) supported; offender [{}] in [{}]", (Object[])new Object[]{bc.right().sourceLocation().getLineNumber(), bc.right().sourceLocation().getColumnNumber(), Expressions.name((Expression)bc.right()), bc.symbol()});
        }

        static Query translate(InsensitiveEquals bc) {
            TypedAttribute attribute = EqualsIgnoreCaseTranslator.checkIsPushableAttribute((Expression)bc.left());
            Source source = bc.source();
            BytesRef value = BytesRefs.toBytesRef((Object)Foldables.valueOf((Expression)bc.right()));
            String name = EqualsIgnoreCaseTranslator.pushableAttributeName((TypedAttribute)attribute);
            return new TermQuery(source, name, (Object)value.utf8ToString(), true);
        }
    }

    public static class BinaryComparisons
    extends ExpressionTranslator<BinaryComparison> {
        private static final BigDecimal HALF_FLOAT_MAX = BigDecimal.valueOf(65504L);
        private static final BigDecimal UNSIGNED_LONG_MAX = BigDecimal.valueOf(2L).pow(64).subtract(BigDecimal.ONE);

        protected Query asQuery(BinaryComparison bc, TranslatorHandler handler) {
            Check.isTrue((boolean)bc.right().foldable(), (String)"Line {}:{}: Comparisons against fields are not (currently) supported; offender [{}] in [{}]", (Object[])new Object[]{bc.right().sourceLocation().getLineNumber(), bc.right().sourceLocation().getColumnNumber(), Expressions.name((Expression)bc.right()), bc.symbol()});
            Query translated = BinaryComparisons.translateOutOfRangeComparisons(bc);
            if (translated != null) {
                return handler.wrapFunctionQuery((ScalarFunction)bc, bc.left(), () -> translated);
            }
            return handler.wrapFunctionQuery((ScalarFunction)bc, bc.left(), () -> BinaryComparisons.translate(bc, handler));
        }

        static Query translate(BinaryComparison bc, TranslatorHandler handler) {
            Object result;
            TypedAttribute attribute = BinaryComparisons.checkIsPushableAttribute((Expression)bc.left());
            Source source = bc.source();
            String name = handler.nameOf((Expression)attribute);
            Object value = result = bc.right().fold();
            String format = null;
            boolean isDateLiteralComparison = false;
            if (value instanceof ZonedDateTime || value instanceof OffsetTime) {
                DateFormatter formatter;
                if (value instanceof ZonedDateTime) {
                    formatter = EsqlDataTypeConverter.DEFAULT_DATE_TIME_FORMATTER;
                    value = formatter.format((TemporalAccessor)((ZonedDateTime)value));
                } else {
                    formatter = EsqlDataTypeConverter.HOUR_MINUTE_SECOND;
                    value = formatter.format((TemporalAccessor)((OffsetTime)value));
                }
                format = formatter.pattern();
                isDateLiteralComparison = true;
            } else if (attribute.dataType() == DataType.IP && value instanceof BytesRef) {
                BytesRef bytesRef = (BytesRef)value;
                value = EsqlDataTypeConverter.ipToString(bytesRef);
            } else if (attribute.dataType() == DataType.VERSION) {
                if (value instanceof BytesRef) {
                    BytesRef bytesRef = (BytesRef)value;
                    value = EsqlDataTypeConverter.versionToString(bytesRef);
                } else if (value instanceof Version) {
                    Version version = (Version)value;
                    value = EsqlDataTypeConverter.versionToString(version);
                }
            } else if (attribute.dataType() == DataType.UNSIGNED_LONG && value instanceof Long) {
                Long ul = (Long)value;
                value = NumericUtils.unsignedLongAsNumber((long)ul);
            }
            ZoneId zoneId = null;
            if (DataType.isDateTime((DataType)attribute.dataType())) {
                zoneId = bc.zoneId();
                value = EsqlDataTypeConverter.dateTimeToString((Long)value);
                format = EsqlDataTypeConverter.DEFAULT_DATE_TIME_FORMATTER.pattern();
            }
            if (bc instanceof GreaterThan) {
                return new RangeQuery(source, name, value, false, null, false, format, zoneId);
            }
            if (bc instanceof GreaterThanOrEqual) {
                return new RangeQuery(source, name, value, true, null, false, format, zoneId);
            }
            if (bc instanceof LessThan) {
                return new RangeQuery(source, name, null, false, value, false, format, zoneId);
            }
            if (bc instanceof LessThanOrEqual) {
                return new RangeQuery(source, name, null, false, value, true, format, zoneId);
            }
            if (bc instanceof Equals || bc instanceof NotEquals) {
                name = BinaryComparisons.pushableAttributeName((TypedAttribute)attribute);
                Object query = isDateLiteralComparison ? new RangeQuery(source, name, value, true, value, true, format, zoneId) : new TermQuery(source, name, value);
                if (bc instanceof NotEquals) {
                    query = new NotQuery(source, (Query)query);
                }
                return query;
            }
            throw new QlIllegalArgumentException("Don't know how to translate binary comparison [{}] in [{}]", new Object[]{bc.right().nodeString(), bc});
        }

        private static Query translateOutOfRangeComparisons(BinaryComparison bc) {
            boolean matchAllOrNone;
            Number num;
            if (!(bc.left() instanceof FieldAttribute && bc.left().dataType().isNumeric() && bc.right().foldable())) {
                return null;
            }
            Source source = bc.source();
            Object value = Foldables.valueOf((Expression)bc.right());
            if (value instanceof List) {
                return new MatchAll(source).negate(source);
            }
            DataType valueType = bc.right().dataType();
            DataType attributeDataType = bc.left().dataType();
            if (valueType == DataType.UNSIGNED_LONG && value instanceof Long) {
                Long ul = (Long)value;
                value = NumericUtils.unsignedLongAsNumber((long)ul);
            }
            if (BinaryComparisons.isInRange(attributeDataType, valueType, num = (Number)value)) {
                return null;
            }
            if (Double.isNaN(((Number)value).doubleValue())) {
                return new MatchAll(source).negate(source);
            }
            if (bc instanceof GreaterThan || bc instanceof GreaterThanOrEqual) {
                matchAllOrNone = !(num.doubleValue() > 0.0);
            } else if (bc instanceof LessThan || bc instanceof LessThanOrEqual) {
                matchAllOrNone = num.doubleValue() > 0.0;
            } else if (bc instanceof Equals) {
                matchAllOrNone = false;
            } else if (bc instanceof NotEquals) {
                matchAllOrNone = true;
            } else {
                throw new QlIllegalArgumentException("Unknown binary comparison [{}]", new Object[]{bc});
            }
            return matchAllOrNone ? new MatchAll(source) : new MatchAll(source).negate(source);
        }

        private static boolean isInRange(DataType numericFieldDataType, DataType valueDataType, Number value) {
            BigDecimal maxValue;
            BigDecimal minValue;
            BigDecimal decimalValue;
            double doubleValue = value.doubleValue();
            if (Double.isNaN(doubleValue) || Double.isInfinite(doubleValue)) {
                return false;
            }
            if (value instanceof BigInteger) {
                BigInteger bigIntValue = (BigInteger)value;
                decimalValue = new BigDecimal(bigIntValue);
            } else {
                BigDecimal bigDecimal = decimalValue = valueDataType.isRationalNumber() ? BigDecimal.valueOf(doubleValue) : BigDecimal.valueOf(value.longValue());
            }
            if (numericFieldDataType == DataType.BYTE) {
                minValue = BigDecimal.valueOf(-128L);
                maxValue = BigDecimal.valueOf(127L);
            } else if (numericFieldDataType == DataType.SHORT) {
                minValue = BigDecimal.valueOf(-32768L);
                maxValue = BigDecimal.valueOf(32767L);
            } else if (numericFieldDataType == DataType.INTEGER) {
                minValue = BigDecimal.valueOf(Integer.MIN_VALUE);
                maxValue = BigDecimal.valueOf(Integer.MAX_VALUE);
            } else if (numericFieldDataType == DataType.LONG) {
                minValue = BigDecimal.valueOf(Long.MIN_VALUE);
                maxValue = BigDecimal.valueOf(Long.MAX_VALUE);
            } else if (numericFieldDataType == DataType.UNSIGNED_LONG) {
                minValue = BigDecimal.ZERO;
                maxValue = UNSIGNED_LONG_MAX;
            } else if (numericFieldDataType == DataType.HALF_FLOAT) {
                minValue = HALF_FLOAT_MAX.negate();
                maxValue = HALF_FLOAT_MAX;
            } else if (numericFieldDataType == DataType.FLOAT) {
                minValue = BigDecimal.valueOf(-3.4028234663852886E38);
                maxValue = BigDecimal.valueOf(3.4028234663852886E38);
            } else if (numericFieldDataType == DataType.DOUBLE || numericFieldDataType == DataType.SCALED_FLOAT) {
                minValue = BigDecimal.valueOf(-1.7976931348623157E308);
                maxValue = BigDecimal.valueOf(Double.MAX_VALUE);
            } else {
                throw new QlIllegalArgumentException("Data type [{}] unsupported for numeric range check", new Object[]{numericFieldDataType});
            }
            return minValue.compareTo(decimalValue) <= 0 && maxValue.compareTo(decimalValue) >= 0;
        }
    }

    public static class SpatialRelatesTranslator
    extends ExpressionTranslator<SpatialRelatesFunction> {
        protected Query asQuery(SpatialRelatesFunction bc, TranslatorHandler handler) {
            return SpatialRelatesTranslator.doTranslate(bc, handler);
        }

        public static void checkSpatialRelatesFunction(Expression constantExpression, ShapeRelation queryRelation) {
            Check.isTrue((boolean)constantExpression.foldable(), (String)"Line {}:{}: Comparisons against fields are not (currently) supported; offender [{}] in [ST_{}]", (Object[])new Object[]{constantExpression.sourceLocation().getLineNumber(), constantExpression.sourceLocation().getColumnNumber(), Expressions.name((Expression)constantExpression), queryRelation});
        }

        public static Query doTranslate(SpatialRelatesFunction bc, TranslatorHandler handler) {
            if (bc.left().foldable()) {
                SpatialRelatesTranslator.checkSpatialRelatesFunction(bc.left(), bc.queryRelation());
                return SpatialRelatesTranslator.translate(bc, handler, bc.right(), bc.left());
            }
            SpatialRelatesTranslator.checkSpatialRelatesFunction(bc.right(), bc.queryRelation());
            return SpatialRelatesTranslator.translate(bc, handler, bc.left(), bc.right());
        }

        static Query translate(SpatialRelatesFunction bc, TranslatorHandler handler, Expression spatialExpression, Expression constantExpression) {
            TypedAttribute attribute = SpatialRelatesTranslator.checkIsPushableAttribute((Expression)spatialExpression);
            String name = handler.nameOf((Expression)attribute);
            try {
                Geometry shape = SpatialRelatesUtils.makeGeometryFromLiteral(constantExpression);
                return new SpatialRelatesQuery(bc.source(), name, bc.queryRelation(), shape, attribute.dataType());
            }
            catch (IllegalArgumentException e) {
                throw new QlIllegalArgumentException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static class InComparisons
    extends ExpressionTranslator<In> {
        protected Query asQuery(In in, TranslatorHandler handler) {
            return InComparisons.doTranslate(in, handler);
        }

        public static Query doTranslate(In in, TranslatorHandler handler) {
            return handler.wrapFunctionQuery((ScalarFunction)in, in.value(), () -> InComparisons.translate(in, handler));
        }

        private static boolean needsTypeSpecificValueHandling(DataType fieldType) {
            return DataType.isDateTime((DataType)fieldType) || fieldType == DataType.IP || fieldType == DataType.VERSION || fieldType == DataType.UNSIGNED_LONG;
        }

        private static Query translate(In in, TranslatorHandler handler) {
            TypedAttribute attribute = InComparisons.checkIsPushableAttribute((Expression)in.value());
            LinkedHashSet<Object> terms = new LinkedHashSet<Object>();
            ArrayList<Object> queries = new ArrayList<Object>();
            for (Expression rhs : in.list()) {
                if (DataType.isNull((DataType)rhs.dataType())) continue;
                if (InComparisons.needsTypeSpecificValueHandling(attribute.dataType())) {
                    Query query = BinaryComparisons.translate(new Equals(in.source(), in.value(), rhs), handler);
                    if (query instanceof TermQuery) {
                        terms.add(((TermQuery)query).value());
                        continue;
                    }
                    queries.add(query);
                    continue;
                }
                terms.add(Foldables.valueOf((Expression)rhs));
            }
            if (!terms.isEmpty()) {
                String fieldName = InComparisons.pushableAttributeName((TypedAttribute)attribute);
                queries.add(new TermsQuery(in.source(), fieldName, terms));
            }
            return (Query)queries.stream().reduce((q1, q2) -> ExpressionTranslators.or((Source)in.source(), (Query)q1, (Query)q2)).get();
        }
    }

    public static class Ranges
    extends ExpressionTranslator<Range> {
        protected Query asQuery(Range r, TranslatorHandler handler) {
            return Ranges.doTranslate(r, handler);
        }

        public static Query doTranslate(Range r, TranslatorHandler handler) {
            return handler.wrapFunctionQuery((ScalarFunction)r, r.value(), () -> Ranges.translate(r, handler));
        }

        private static RangeQuery translate(Range r, TranslatorHandler handler) {
            Object lower = Foldables.valueOf((Expression)r.lower());
            Object upper = Foldables.valueOf((Expression)r.upper());
            String format = null;
            DataType dataType = r.value().dataType();
            if (DataType.isDateTime((DataType)dataType) && DataType.isDateTime((DataType)r.lower().dataType()) && DataType.isDateTime((DataType)r.upper().dataType())) {
                lower = EsqlDataTypeConverter.dateTimeToString((Long)lower);
                upper = EsqlDataTypeConverter.dateTimeToString((Long)upper);
                format = EsqlDataTypeConverter.DEFAULT_DATE_TIME_FORMATTER.pattern();
            }
            if (dataType == DataType.IP) {
                BytesRef bytesRef;
                if (lower instanceof BytesRef) {
                    bytesRef = (BytesRef)lower;
                    lower = EsqlDataTypeConverter.ipToString(bytesRef);
                }
                if (upper instanceof BytesRef) {
                    bytesRef = (BytesRef)upper;
                    upper = EsqlDataTypeConverter.ipToString(bytesRef);
                }
            } else if (dataType == DataType.VERSION) {
                Version version;
                BytesRef bytesRef;
                if (lower instanceof BytesRef) {
                    bytesRef = (BytesRef)lower;
                    lower = EsqlDataTypeConverter.versionToString(bytesRef);
                } else if (lower instanceof Version) {
                    version = (Version)lower;
                    lower = EsqlDataTypeConverter.versionToString(version);
                }
                if (upper instanceof BytesRef) {
                    bytesRef = (BytesRef)upper;
                    upper = EsqlDataTypeConverter.versionToString(bytesRef);
                } else if (upper instanceof Version) {
                    version = (Version)upper;
                    upper = EsqlDataTypeConverter.versionToString(version);
                }
            } else if (dataType == DataType.UNSIGNED_LONG) {
                Long ul;
                if (lower instanceof Long) {
                    ul = (Long)lower;
                    lower = NumericUtils.unsignedLongAsNumber((long)ul);
                }
                if (upper instanceof Long) {
                    ul = (Long)upper;
                    upper = NumericUtils.unsignedLongAsNumber((long)ul);
                }
            }
            return new RangeQuery(r.source(), handler.nameOf(r.value()), lower, r.includeLower(), upper, r.includeUpper(), format, r.zoneId());
        }
    }

    public static class MatchFunctionTranslator
    extends ExpressionTranslator<Match> {
        protected Query asQuery(Match match, TranslatorHandler handler) {
            return new MatchQuery(match.source(), ((FieldAttribute)match.field()).name(), (Object)match.queryAsText());
        }
    }

    public static class QueryStringFunctionTranslator
    extends ExpressionTranslator<QueryString> {
        protected Query asQuery(QueryString queryString, TranslatorHandler handler) {
            return new QueryStringQuery(queryString.source(), queryString.queryAsText(), Map.of(), null);
        }
    }

    public static class Scalars
    extends ExpressionTranslator<ScalarFunction> {
        protected Query asQuery(ScalarFunction f, TranslatorHandler handler) {
            return Scalars.doTranslate(f, handler);
        }

        public static Query doTranslate(ScalarFunction f, TranslatorHandler handler) {
            CIDRMatch cm;
            Expression expression;
            if (f instanceof CIDRMatch && (expression = (cm = (CIDRMatch)f).ipField()) instanceof FieldAttribute) {
                FieldAttribute fa = (FieldAttribute)expression;
                if (Expressions.foldable(cm.matches())) {
                    String targetFieldName = handler.nameOf((Expression)fa.exactAttribute());
                    LinkedHashSet set = new LinkedHashSet(Expressions.fold(cm.matches()));
                    TermsQuery query = new TermsQuery(f.source(), targetFieldName, set);
                    return handler.wrapFunctionQuery(f, cm.ipField(), () -> Scalars.lambda$doTranslate$0((Query)query));
                }
            }
            throw new QlIllegalArgumentException("Cannot translate expression:[" + f.sourceText() + "]");
        }

        private static /* synthetic */ Query lambda$doTranslate$0(Query query) {
            return query;
        }
    }
}

