/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.physical;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.AttributeSet;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.plan.physical.BinaryExec;
import org.elasticsearch.xpack.esql.plan.physical.EstimatesRowSize;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;

public class HashJoinExec
extends BinaryExec
implements EstimatesRowSize {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(PhysicalPlan.class, "HashJoinExec", HashJoinExec::new);
    private final List<Attribute> matchFields;
    private final List<Attribute> leftFields;
    private final List<Attribute> rightFields;
    private final List<Attribute> output;
    private AttributeSet lazyAddedFields;

    public HashJoinExec(Source source, PhysicalPlan left, PhysicalPlan hashData, List<Attribute> matchFields, List<Attribute> leftFields, List<Attribute> rightFields, List<Attribute> output) {
        super(source, left, hashData);
        this.matchFields = matchFields;
        this.leftFields = leftFields;
        this.rightFields = rightFields;
        this.output = output;
    }

    private HashJoinExec(StreamInput in) throws IOException {
        super(Source.readFrom((StreamInput)((PlanStreamInput)in)), (PhysicalPlan)in.readNamedWriteable(PhysicalPlan.class), (PhysicalPlan)in.readNamedWriteable(PhysicalPlan.class));
        this.matchFields = in.readNamedWriteableCollectionAsList(Attribute.class);
        this.leftFields = in.readNamedWriteableCollectionAsList(Attribute.class);
        this.rightFields = in.readNamedWriteableCollectionAsList(Attribute.class);
        this.output = in.readNamedWriteableCollectionAsList(Attribute.class);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeNamedWriteableCollection(this.matchFields);
        out.writeNamedWriteableCollection(this.leftFields);
        out.writeNamedWriteableCollection(this.rightFields);
        out.writeNamedWriteableCollection(this.output);
    }

    public String getWriteableName() {
        return HashJoinExec.ENTRY.name;
    }

    public PhysicalPlan joinData() {
        return this.right();
    }

    public List<Attribute> matchFields() {
        return this.matchFields;
    }

    public List<Attribute> leftFields() {
        return this.leftFields;
    }

    public List<Attribute> rightFields() {
        return this.rightFields;
    }

    public Set<Attribute> addedFields() {
        if (this.lazyAddedFields == null) {
            this.lazyAddedFields = this.outputSet();
            this.lazyAddedFields.removeAll(this.left().output());
        }
        return this.lazyAddedFields;
    }

    @Override
    public PhysicalPlan estimateRowSize(EstimatesRowSize.State state) {
        state.add(false, this.output);
        return this;
    }

    @Override
    public List<Attribute> output() {
        return this.output;
    }

    @Override
    public AttributeSet inputSet() {
        return this.left().outputSet();
    }

    @Override
    protected AttributeSet computeReferences() {
        return Expressions.references(this.leftFields);
    }

    @Override
    public HashJoinExec replaceChildren(PhysicalPlan left, PhysicalPlan right) {
        return new HashJoinExec(this.source(), left, right, this.matchFields, this.leftFields, this.rightFields, this.output);
    }

    protected NodeInfo<? extends PhysicalPlan> info() {
        return NodeInfo.create((Node)this, HashJoinExec::new, (Object)((Object)this.left()), (Object)((Object)this.right()), this.matchFields, this.leftFields, this.rightFields, this.output);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HashJoinExec hash = (HashJoinExec)o;
        return this.matchFields.equals(hash.matchFields) && this.leftFields.equals(hash.leftFields) && this.rightFields.equals(hash.rightFields) && this.output.equals(hash.output);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.matchFields, this.leftFields, this.rightFields, this.output);
    }
}

