/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.physical;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.GeoDistanceSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.NodeUtils;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.type.EsField;
import org.elasticsearch.xpack.esql.expression.Order;
import org.elasticsearch.xpack.esql.index.EsIndex;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.plan.logical.EsRelation;
import org.elasticsearch.xpack.esql.plan.physical.EstimatesRowSize;
import org.elasticsearch.xpack.esql.plan.physical.LeafExec;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;

public class EsQueryExec
extends LeafExec
implements EstimatesRowSize {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(PhysicalPlan.class, "EsQueryExec", EsQueryExec::deserialize);
    public static final EsField DOC_ID_FIELD = new EsField("_doc", DataType.DOC_DATA_TYPE, Map.of(), false);
    public static final List<Sort> NO_SORTS = List.of();
    private final EsIndex index;
    private final IndexMode indexMode;
    private final QueryBuilder query;
    private final Expression limit;
    private final List<Sort> sorts;
    private final List<Attribute> attrs;
    private final Integer estimatedRowSize;

    public EsQueryExec(Source source, EsIndex index, IndexMode indexMode, List<Attribute> attributes, QueryBuilder query) {
        this(source, index, indexMode, attributes, query, null, null, null);
    }

    public EsQueryExec(Source source, EsIndex index, IndexMode indexMode, List<Attribute> attrs, QueryBuilder query, Expression limit, List<Sort> sorts, Integer estimatedRowSize) {
        super(source);
        this.index = index;
        this.indexMode = indexMode;
        this.query = query;
        this.attrs = attrs;
        this.limit = limit;
        this.sorts = sorts;
        this.estimatedRowSize = estimatedRowSize;
    }

    public static EsQueryExec deserialize(StreamInput in) throws IOException {
        Source source = Source.readFrom((StreamInput)((PlanStreamInput)in));
        EsIndex index = new EsIndex(in);
        IndexMode indexMode = EsRelation.readIndexMode(in);
        List attrs = in.readNamedWriteableCollectionAsList(Attribute.class);
        QueryBuilder query = (QueryBuilder)in.readOptionalNamedWriteable(QueryBuilder.class);
        Expression limit = (Expression)in.readOptionalNamedWriteable(Expression.class);
        in.readOptionalCollectionAsList(EsQueryExec::readSort);
        Integer rowSize = in.readOptionalVInt();
        return new EsQueryExec(source, index, indexMode, attrs, query, limit, NO_SORTS, rowSize);
    }

    private static Sort readSort(StreamInput in) throws IOException {
        return FieldSort.readFrom(in);
    }

    private static void writeSort(StreamOutput out, Sort sort) {
        throw new IllegalStateException("sorts are no longer serialized");
    }

    public void writeTo(StreamOutput out) throws IOException {
        Source.EMPTY.writeTo(out);
        this.index().writeTo(out);
        EsRelation.writeIndexMode(out, this.indexMode());
        out.writeNamedWriteableCollection(this.output());
        out.writeOptionalNamedWriteable((NamedWriteable)this.query());
        out.writeOptionalNamedWriteable((NamedWriteable)this.limit());
        out.writeOptionalCollection(NO_SORTS, EsQueryExec::writeSort);
        out.writeOptionalVInt(this.estimatedRowSize());
    }

    public String getWriteableName() {
        return EsQueryExec.ENTRY.name;
    }

    public static boolean isSourceAttribute(Attribute attr) {
        return DOC_ID_FIELD.getName().equals(attr.name());
    }

    protected NodeInfo<EsQueryExec> info() {
        return NodeInfo.create((Node)this, EsQueryExec::new, (Object)this.index, (Object)this.indexMode, this.attrs, (Object)this.query, (Object)this.limit, this.sorts, (Object)this.estimatedRowSize);
    }

    public EsIndex index() {
        return this.index;
    }

    public IndexMode indexMode() {
        return this.indexMode;
    }

    public QueryBuilder query() {
        return this.query;
    }

    @Override
    public List<Attribute> output() {
        return this.attrs;
    }

    public Expression limit() {
        return this.limit;
    }

    public List<Sort> sorts() {
        return this.sorts;
    }

    public List<Attribute> attrs() {
        return this.attrs;
    }

    public Integer estimatedRowSize() {
        return this.estimatedRowSize;
    }

    @Override
    public PhysicalPlan estimateRowSize(EstimatesRowSize.State state) {
        int size;
        if (this.sorts == null || this.sorts.isEmpty()) {
            state.add(false, 4);
            size = state.consumeAllFields(false);
        } else {
            state.add(false, 8);
            size = state.consumeAllFields(true);
        }
        return Objects.equals(this.estimatedRowSize, size) ? this : new EsQueryExec(this.source(), this.index, this.indexMode, this.attrs, this.query, this.limit, this.sorts, size);
    }

    public EsQueryExec withLimit(Expression limit) {
        return Objects.equals(this.limit, limit) ? this : new EsQueryExec(this.source(), this.index, this.indexMode, this.attrs, this.query, limit, this.sorts, this.estimatedRowSize);
    }

    public boolean canPushSorts() {
        return this.indexMode != IndexMode.TIME_SERIES;
    }

    public EsQueryExec withSorts(List<Sort> sorts) {
        if (this.indexMode == IndexMode.TIME_SERIES) {
            assert (false) : "time-series index mode doesn't support sorts";
            throw new UnsupportedOperationException("time-series index mode doesn't support sorts");
        }
        return Objects.equals(this.sorts, sorts) ? this : new EsQueryExec(this.source(), this.index, this.indexMode, this.attrs, this.query, this.limit, sorts, this.estimatedRowSize);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.index, this.indexMode, this.attrs, this.query, this.limit, this.sorts);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EsQueryExec other = (EsQueryExec)obj;
        return Objects.equals(this.index, other.index) && Objects.equals(this.indexMode, other.indexMode) && Objects.equals(this.attrs, other.attrs) && Objects.equals(this.query, other.query) && Objects.equals(this.limit, other.limit) && Objects.equals(this.sorts, other.sorts) && Objects.equals(this.estimatedRowSize, other.estimatedRowSize);
    }

    public String nodeString() {
        return this.nodeName() + "[" + String.valueOf(this.index) + "], indexMode[" + String.valueOf(this.indexMode) + "], query[" + (this.query != null ? Strings.toString((ToXContent)this.query, (boolean)false, (boolean)true) : "") + "]" + NodeUtils.limitedToString(this.attrs) + ", limit[" + (this.limit != null ? this.limit.toString() : "") + "], sort[" + (this.sorts != null ? this.sorts.toString() : "") + "] estimatedRowSize[" + this.estimatedRowSize + "]";
    }

    public record FieldSort(FieldAttribute field, Order.OrderDirection direction, Order.NullsPosition nulls) implements Sort
    {
        @Override
        public SortBuilder<?> sortBuilder() {
            FieldSortBuilder builder = new FieldSortBuilder(this.field.name());
            builder.order(Direction.from(this.direction).asOrder());
            builder.missing((Object)Missing.from(this.nulls).searchOrder());
            builder.unmappedType(this.field.dataType().esType());
            return builder;
        }

        private static FieldSort readFrom(StreamInput in) throws IOException {
            return new FieldSort(FieldAttribute.readFrom((StreamInput)in), (Order.OrderDirection)in.readEnum(Order.OrderDirection.class), (Order.NullsPosition)in.readEnum(Order.NullsPosition.class));
        }
    }

    public static enum Missing {
        FIRST("_first"),
        LAST("_last"),
        ANY(null);

        private final String searchOrder;

        private Missing(String searchOrder) {
            this.searchOrder = searchOrder;
        }

        public static Missing from(Order.NullsPosition pos) {
            return switch (pos) {
                case Order.NullsPosition.FIRST -> FIRST;
                case Order.NullsPosition.LAST -> LAST;
                default -> ANY;
            };
        }

        public String searchOrder() {
            return this.searchOrder;
        }
    }

    public static enum Direction {
        ASC,
        DESC;


        public static Direction from(Order.OrderDirection dir) {
            return dir == null || dir == Order.OrderDirection.ASC ? ASC : DESC;
        }

        public SortOrder asOrder() {
            return this == ASC ? SortOrder.ASC : SortOrder.DESC;
        }
    }

    public record GeoDistanceSort(FieldAttribute field, Order.OrderDirection direction, double lat, double lon) implements Sort
    {
        @Override
        public SortBuilder<?> sortBuilder() {
            GeoDistanceSortBuilder builder = new GeoDistanceSortBuilder(this.field.name(), this.lat, this.lon);
            builder.order(Direction.from(this.direction).asOrder());
            return builder;
        }
    }

    public static interface Sort {
        public SortBuilder<?> sortBuilder();

        public Order.OrderDirection direction();

        public FieldAttribute field();
    }
}

