/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.physical;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.iterable.Iterables;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.AttributeSet;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.NamedExpressions;
import org.elasticsearch.xpack.esql.index.EsIndex;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.plan.logical.Enrich;
import org.elasticsearch.xpack.esql.plan.physical.EstimatesRowSize;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.plan.physical.UnaryExec;

public class EnrichExec
extends UnaryExec
implements EstimatesRowSize {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(PhysicalPlan.class, "EnrichExec", EnrichExec::readFrom);
    private final Enrich.Mode mode;
    private final String matchType;
    private final NamedExpression matchField;
    private final String policyName;
    private final String policyMatchField;
    private final Map<String, String> concreteIndices;
    private final List<NamedExpression> enrichFields;

    public EnrichExec(Source source, PhysicalPlan child, Enrich.Mode mode, String matchType, NamedExpression matchField, String policyName, String policyMatchField, Map<String, String> concreteIndices, List<NamedExpression> enrichFields) {
        super(source, child);
        this.mode = mode;
        this.matchType = matchType;
        this.matchField = matchField;
        this.policyName = policyName;
        this.policyMatchField = policyMatchField;
        this.concreteIndices = concreteIndices;
        this.enrichFields = enrichFields;
    }

    private static EnrichExec readFrom(StreamInput in) throws IOException {
        Map<String, String> concreteIndices;
        Enrich.Mode mode;
        Source source = Source.readFrom((StreamInput)((PlanStreamInput)in));
        PhysicalPlan child = (PhysicalPlan)in.readNamedWriteable(PhysicalPlan.class);
        NamedExpression matchField = (NamedExpression)in.readNamedWriteable(NamedExpression.class);
        String policyName = in.readString();
        String matchType = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_14_0) ? in.readString() : "match";
        String policyMatchField = in.readString();
        if (in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_13_0)) {
            mode = (Enrich.Mode)in.readEnum(Enrich.Mode.class);
            concreteIndices = in.readMap(StreamInput::readString, StreamInput::readString);
        } else {
            mode = Enrich.Mode.ANY;
            EsIndex esIndex = new EsIndex(in);
            if (esIndex.concreteIndices().size() != 1) {
                throw new IllegalStateException("expected a single concrete enrich index; got " + String.valueOf(esIndex.concreteIndices()));
            }
            concreteIndices = Map.of("", (String)Iterables.get(esIndex.concreteIndices(), (int)0));
        }
        return new EnrichExec(source, child, mode, matchType, matchField, policyName, policyMatchField, concreteIndices, in.readNamedWriteableCollectionAsList(NamedExpression.class));
    }

    public void writeTo(StreamOutput out) throws IOException {
        Source.EMPTY.writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.child());
        out.writeNamedWriteable((NamedWriteable)this.matchField());
        out.writeString(this.policyName());
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_14_0)) {
            out.writeString(this.matchType());
        }
        out.writeString(this.policyMatchField());
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_13_0)) {
            out.writeEnum((Enum)this.mode());
            out.writeMap(this.concreteIndices(), StreamOutput::writeString, StreamOutput::writeString);
        } else if (this.concreteIndices().keySet().equals(Set.of(""))) {
            String concreteIndex = this.concreteIndices().get("");
            new EsIndex(concreteIndex, Map.of(), Map.of(concreteIndex, IndexMode.STANDARD)).writeTo(out);
        } else {
            throw new IllegalStateException("expected a single concrete enrich index; got " + String.valueOf(this.concreteIndices()));
        }
        out.writeNamedWriteableCollection(this.enrichFields());
    }

    public String getWriteableName() {
        return EnrichExec.ENTRY.name;
    }

    @Override
    protected AttributeSet computeReferences() {
        return this.matchField.references();
    }

    protected NodeInfo<EnrichExec> info() {
        return NodeInfo.create((Node)this, EnrichExec::new, (Object)((Object)this.child()), (Object)((Object)this.mode), (Object)this.matchType, (Object)this.matchField, (Object)this.policyName, (Object)this.policyMatchField, this.concreteIndices, this.enrichFields);
    }

    @Override
    public EnrichExec replaceChild(PhysicalPlan newChild) {
        return new EnrichExec(this.source(), newChild, this.mode, this.matchType, this.matchField, this.policyName, this.policyMatchField, this.concreteIndices, this.enrichFields);
    }

    public Enrich.Mode mode() {
        return this.mode;
    }

    public String matchType() {
        return this.matchType;
    }

    public NamedExpression matchField() {
        return this.matchField;
    }

    public Map<String, String> concreteIndices() {
        return this.concreteIndices;
    }

    public List<NamedExpression> enrichFields() {
        return this.enrichFields;
    }

    public String policyName() {
        return this.policyName;
    }

    public String policyMatchField() {
        return this.policyMatchField;
    }

    @Override
    public List<Attribute> output() {
        return NamedExpressions.mergeOutputAttributes(this.enrichFields, this.child().output());
    }

    @Override
    public PhysicalPlan estimateRowSize(EstimatesRowSize.State state) {
        state.add(false, this.enrichFields);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EnrichExec that = (EnrichExec)o;
        return this.mode.equals((Object)that.mode) && Objects.equals(this.matchType, that.matchType) && Objects.equals(this.matchField, that.matchField) && Objects.equals(this.policyName, that.policyName) && Objects.equals(this.policyMatchField, that.policyMatchField) && Objects.equals(this.concreteIndices, that.concreteIndices) && Objects.equals(this.enrichFields, that.enrichFields);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.mode, this.matchType, this.matchField, this.policyName, this.policyMatchField, this.concreteIndices, this.enrichFields});
    }
}

