/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.NodeUtils;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.EsField;
import org.elasticsearch.xpack.esql.index.EsIndex;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.plan.logical.LeafPlan;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;

public class EsRelation
extends LeafPlan {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(LogicalPlan.class, "EsRelation", EsRelation::readFrom);
    private final EsIndex index;
    private final List<Attribute> attrs;
    private final boolean frozen;
    private final IndexMode indexMode;

    public EsRelation(Source source, EsIndex index, IndexMode indexMode, boolean frozen) {
        this(source, index, EsRelation.flatten(source, index.mapping()), indexMode, frozen);
    }

    public EsRelation(Source source, EsIndex index, List<Attribute> attributes, IndexMode indexMode) {
        this(source, index, attributes, indexMode, false);
    }

    public EsRelation(Source source, EsIndex index, List<Attribute> attributes, IndexMode indexMode, boolean frozen) {
        super(source);
        this.index = index;
        this.attrs = attributes;
        this.indexMode = indexMode;
        this.frozen = frozen;
    }

    private static EsRelation readFrom(StreamInput in) throws IOException {
        Source source = Source.readFrom((StreamInput)((PlanStreamInput)in));
        EsIndex esIndex = new EsIndex(in);
        List attributes = in.readNamedWriteableCollectionAsList(Attribute.class);
        if (EsRelation.supportingEsSourceOptions(in.getTransportVersion())) {
            in.readOptionalString();
            in.readOptionalString();
            in.readOptionalString();
        }
        IndexMode indexMode = EsRelation.readIndexMode(in);
        boolean frozen = in.readBoolean();
        return new EsRelation(source, esIndex, attributes, indexMode, frozen);
    }

    public void writeTo(StreamOutput out) throws IOException {
        Source.EMPTY.writeTo(out);
        this.index().writeTo(out);
        out.writeNamedWriteableCollection(this.output());
        if (EsRelation.supportingEsSourceOptions(out.getTransportVersion())) {
            out.writeOptionalString(null);
            out.writeOptionalString(null);
            out.writeOptionalString(null);
        }
        EsRelation.writeIndexMode(out, this.indexMode());
        out.writeBoolean(this.frozen());
    }

    private static boolean supportingEsSourceOptions(TransportVersion version) {
        return version.between((VersionId)TransportVersions.V_8_14_0, (VersionId)TransportVersions.V_8_15_0);
    }

    public String getWriteableName() {
        return EsRelation.ENTRY.name;
    }

    protected NodeInfo<EsRelation> info() {
        return NodeInfo.create((Node)this, EsRelation::new, (Object)this.index, this.attrs, (Object)this.indexMode, (Object)this.frozen);
    }

    private static List<Attribute> flatten(Source source, Map<String, EsField> mapping) {
        return EsRelation.flatten(source, mapping, null);
    }

    private static List<Attribute> flatten(Source source, Map<String, EsField> mapping, FieldAttribute parent) {
        ArrayList<Attribute> list = new ArrayList<Attribute>();
        for (Map.Entry<String, EsField> entry : mapping.entrySet()) {
            String name = entry.getKey();
            EsField t = entry.getValue();
            if (t == null) continue;
            FieldAttribute f = new FieldAttribute(source, parent != null ? parent.name() : null, (String)(parent != null ? parent.name() + "." + name : name), t);
            list.add((Attribute)f);
            if (t.getProperties().isEmpty()) continue;
            list.addAll(EsRelation.flatten(source, t.getProperties(), f));
        }
        return list;
    }

    public EsIndex index() {
        return this.index;
    }

    public boolean frozen() {
        return this.frozen;
    }

    public IndexMode indexMode() {
        return this.indexMode;
    }

    @Override
    public List<Attribute> output() {
        return this.attrs;
    }

    @Override
    public String commandName() {
        return "FROM";
    }

    @Override
    public boolean expressionsResolved() {
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.index, this.indexMode, this.frozen, this.attrs);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        EsRelation other = (EsRelation)((Object)obj);
        return Objects.equals(this.index, other.index) && this.indexMode == other.indexMode() && this.frozen == other.frozen && Objects.equals(this.attrs, other.attrs);
    }

    public String nodeString() {
        return this.nodeName() + "[" + String.valueOf(this.index) + "]" + (String)(this.indexMode != IndexMode.STANDARD ? "[" + this.indexMode.name() + "]" : "") + NodeUtils.limitedToString(this.attrs);
    }

    public static IndexMode readIndexMode(StreamInput in) throws IOException {
        if (in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_15_0)) {
            return IndexMode.fromString((String)in.readString());
        }
        return IndexMode.STANDARD;
    }

    public static void writeIndexMode(StreamOutput out, IndexMode indexMode) throws IOException {
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_15_0)) {
            out.writeString(indexMode.getName());
        } else if (indexMode != IndexMode.STANDARD) {
            throw new IllegalStateException("not ready to support index mode [" + String.valueOf(indexMode) + "]");
        }
    }
}

