/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules.physical.local;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.query.ExistsQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.AttributeMap;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.querydsl.query.Query;
import org.elasticsearch.xpack.esql.core.util.Queries;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Count;
import org.elasticsearch.xpack.esql.optimizer.LocalPhysicalOptimizerContext;
import org.elasticsearch.xpack.esql.optimizer.PhysicalOptimizerRules;
import org.elasticsearch.xpack.esql.optimizer.rules.physical.local.PushFiltersToSource;
import org.elasticsearch.xpack.esql.plan.physical.AggregateExec;
import org.elasticsearch.xpack.esql.plan.physical.EsQueryExec;
import org.elasticsearch.xpack.esql.plan.physical.EsStatsQueryExec;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.planner.AbstractPhysicalOperationProviders;
import org.elasticsearch.xpack.esql.planner.PlannerUtils;

public class PushStatsToSource
extends PhysicalOptimizerRules.ParameterizedOptimizerRule<AggregateExec, LocalPhysicalOptimizerContext> {
    @Override
    protected PhysicalPlan rule(AggregateExec aggregateExec, LocalPhysicalOptimizerContext context) {
        PhysicalPlan plan = aggregateExec;
        PhysicalPlan physicalPlan = aggregateExec.child();
        if (physicalPlan instanceof EsQueryExec) {
            EsQueryExec queryExec = (EsQueryExec)physicalPlan;
            Tuple<List<Attribute>, List<EsStatsQueryExec.Stat>> tuple = this.pushableStats(aggregateExec, context);
            List stats = (List)tuple.v2();
            if (stats.size() > 1) {
                return aggregateExec;
            }
            if (((List)tuple.v2()).size() == aggregateExec.aggregates().size()) {
                plan = new EsStatsQueryExec(aggregateExec.source(), queryExec.index(), queryExec.query(), queryExec.limit(), (List)tuple.v1(), (List)tuple.v2());
            }
        }
        return plan;
    }

    private Tuple<List<Attribute>, List<EsStatsQueryExec.Stat>> pushableStats(AggregateExec aggregate, LocalPhysicalOptimizerContext context) {
        AttributeMap stats = new AttributeMap();
        Tuple tuple = new Tuple(new ArrayList(), new ArrayList());
        if (aggregate.groupings().isEmpty()) {
            for (NamedExpression namedExpression : aggregate.aggregates()) {
                Attribute attribute = namedExpression.toAttribute();
                EsStatsQueryExec.Stat stat = (EsStatsQueryExec.Stat)stats.computeIfAbsent((Object)attribute, a -> {
                    Alias as;
                    Expression child;
                    if (agg instanceof Alias && (child = (as = (Alias)agg).child()) instanceof Count) {
                        Count count = (Count)child;
                        Expression target = count.field();
                        String fieldName = null;
                        ExistsQueryBuilder query = null;
                        if (target.foldable()) {
                            fieldName = "*";
                        } else if (target instanceof FieldAttribute) {
                            FieldAttribute fa = (FieldAttribute)target;
                            String fName = fa.fieldName();
                            if (context.searchStats().isSingleValue(fName)) {
                                fieldName = fName;
                                query = QueryBuilders.existsQuery((String)fieldName);
                            }
                        }
                        if (fieldName != null) {
                            if (count.hasFilter()) {
                                if (!PushFiltersToSource.canPushToSource(count.filter())) {
                                    return null;
                                }
                                Query countFilter = PlannerUtils.TRANSLATOR_HANDLER.asQuery(count.filter());
                                query = Queries.combine((Queries.Clause)Queries.Clause.MUST, Arrays.asList(countFilter.asBuilder(), query));
                            }
                            return new EsStatsQueryExec.Stat(fieldName, EsStatsQueryExec.StatsType.COUNT, (QueryBuilder)query);
                        }
                    }
                    return null;
                });
                if (stat == null) continue;
                List<Attribute> intermediateAttributes = AbstractPhysicalOperationProviders.intermediateAttributes(Collections.singletonList(namedExpression), Collections.emptyList());
                ((List)tuple.v1()).addAll(intermediateAttributes);
                ((List)tuple.v2()).add(stat);
            }
        }
        return tuple;
    }
}

