/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules.logical;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.OptimizerRules;

public final class ConvertStringToByteRef
extends OptimizerRules.OptimizerExpressionRule<Literal> {
    public ConvertStringToByteRef() {
        super(OptimizerRules.TransformDirection.UP);
    }

    @Override
    protected Expression rule(Literal lit) {
        Object value = lit.value();
        if (value == null) {
            return lit;
        }
        if (value instanceof String) {
            String s = (String)value;
            return Literal.of((Expression)lit, (Object)new BytesRef((CharSequence)s));
        }
        if (value instanceof List) {
            List l = (List)value;
            if (l.isEmpty() || !(l.get(0) instanceof String)) {
                return lit;
            }
            ArrayList<BytesRef> byteRefs = new ArrayList<BytesRef>(l.size());
            for (Object v : l) {
                byteRefs.add(new BytesRef((CharSequence)v.toString()));
            }
            return Literal.of((Expression)lit, byteRefs);
        }
        return lit;
    }
}

