/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.string;

import java.util.Locale;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.ToUpper;

public final class ToUpperEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final Source source;
    private final EvalOperator.ExpressionEvaluator val;
    private final Locale locale;
    private final DriverContext driverContext;
    private Warnings warnings;

    public ToUpperEvaluator(Source source, EvalOperator.ExpressionEvaluator val, Locale locale, DriverContext driverContext) {
        this.source = source;
        this.val = val;
        this.locale = locale;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (BytesRefBlock valBlock = (BytesRefBlock)this.val.eval(page);){
            BytesRefVector valVector = valBlock.asVector();
            if (valVector == null) {
                BytesRefBlock bytesRefBlock = this.eval(page.getPositionCount(), valBlock);
                return bytesRefBlock;
            }
            BytesRefBlock bytesRefBlock = this.eval(page.getPositionCount(), valVector).asBlock();
            return bytesRefBlock;
        }
    }

    public BytesRefBlock eval(int positionCount, BytesRefBlock valBlock) {
        try (BytesRefBlock.Builder result = this.driverContext.blockFactory().newBytesRefBlockBuilder(positionCount);){
            BytesRef valScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                if (valBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (valBlock.getValueCount(p) != 1) {
                    if (valBlock.getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                result.appendBytesRef(ToUpper.process(valBlock.getBytesRef(valBlock.getFirstValueIndex(p), valScratch), this.locale));
            }
            BytesRefBlock bytesRefBlock = result.build();
            return bytesRefBlock;
        }
    }

    public BytesRefVector eval(int positionCount, BytesRefVector valVector) {
        try (BytesRefVector.Builder result = this.driverContext.blockFactory().newBytesRefVectorBuilder(positionCount);){
            BytesRef valScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                result.appendBytesRef(ToUpper.process(valVector.getBytesRef(p, valScratch), this.locale));
            }
            BytesRefVector bytesRefVector = result.build();
            return bytesRefVector;
        }
    }

    public String toString() {
        return "ToUpperEvaluator[val=" + String.valueOf(this.val) + ", locale=" + String.valueOf(this.locale) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.val);
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory val;
        private final Locale locale;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory val, Locale locale) {
            this.source = source;
            this.val = val;
            this.locale = locale;
        }

        public ToUpperEvaluator get(DriverContext context) {
            return new ToUpperEvaluator(this.source, this.val.get(context), this.locale, context);
        }

        public String toString() {
            return "ToUpperEvaluator[val=" + String.valueOf(this.val) + ", locale=" + String.valueOf(this.locale) + "]";
        }
    }
}

