/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.date;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.InvalidArgumentException;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DateDiff;

public final class DateDiffEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final Source source;
    private final EvalOperator.ExpressionEvaluator unit;
    private final EvalOperator.ExpressionEvaluator startTimestamp;
    private final EvalOperator.ExpressionEvaluator endTimestamp;
    private final DriverContext driverContext;
    private Warnings warnings;

    public DateDiffEvaluator(Source source, EvalOperator.ExpressionEvaluator unit, EvalOperator.ExpressionEvaluator startTimestamp, EvalOperator.ExpressionEvaluator endTimestamp, DriverContext driverContext) {
        this.source = source;
        this.unit = unit;
        this.startTimestamp = startTimestamp;
        this.endTimestamp = endTimestamp;
        this.driverContext = driverContext;
    }

    /*
     * Exception decompiling
     */
    public Block eval(Page page) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public IntBlock eval(int positionCount, BytesRefBlock unitBlock, LongBlock startTimestampBlock, LongBlock endTimestampBlock) {
        try (IntBlock.Builder result = this.driverContext.blockFactory().newIntBlockBuilder(positionCount);){
            BytesRef unitScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                if (unitBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (unitBlock.getValueCount(p) != 1) {
                    if (unitBlock.getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                if (startTimestampBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (startTimestampBlock.getValueCount(p) != 1) {
                    if (startTimestampBlock.getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                if (endTimestampBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (endTimestampBlock.getValueCount(p) != 1) {
                    if (endTimestampBlock.getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                try {
                    result.appendInt(DateDiff.process(unitBlock.getBytesRef(unitBlock.getFirstValueIndex(p), unitScratch), startTimestampBlock.getLong(startTimestampBlock.getFirstValueIndex(p)), endTimestampBlock.getLong(endTimestampBlock.getFirstValueIndex(p))));
                    continue;
                }
                catch (IllegalArgumentException | InvalidArgumentException e) {
                    this.warnings().registerException((Exception)e);
                    result.appendNull();
                }
            }
            IntBlock intBlock = result.build();
            return intBlock;
        }
    }

    public IntBlock eval(int positionCount, BytesRefVector unitVector, LongVector startTimestampVector, LongVector endTimestampVector) {
        try (IntBlock.Builder result = this.driverContext.blockFactory().newIntBlockBuilder(positionCount);){
            BytesRef unitScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                try {
                    result.appendInt(DateDiff.process(unitVector.getBytesRef(p, unitScratch), startTimestampVector.getLong(p), endTimestampVector.getLong(p)));
                    continue;
                }
                catch (IllegalArgumentException | InvalidArgumentException e) {
                    this.warnings().registerException((Exception)e);
                    result.appendNull();
                }
            }
            IntBlock intBlock = result.build();
            return intBlock;
        }
    }

    public String toString() {
        return "DateDiffEvaluator[unit=" + String.valueOf(this.unit) + ", startTimestamp=" + String.valueOf(this.startTimestamp) + ", endTimestamp=" + String.valueOf(this.endTimestamp) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.unit, this.startTimestamp, this.endTimestamp});
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory unit;
        private final EvalOperator.ExpressionEvaluator.Factory startTimestamp;
        private final EvalOperator.ExpressionEvaluator.Factory endTimestamp;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory unit, EvalOperator.ExpressionEvaluator.Factory startTimestamp, EvalOperator.ExpressionEvaluator.Factory endTimestamp) {
            this.source = source;
            this.unit = unit;
            this.startTimestamp = startTimestamp;
            this.endTimestamp = endTimestamp;
        }

        public DateDiffEvaluator get(DriverContext context) {
            return new DateDiffEvaluator(this.source, this.unit.get(context), this.startTimestamp.get(context), this.endTimestamp.get(context), context);
        }

        public String toString() {
            return "DateDiffEvaluator[unit=" + String.valueOf(this.unit) + ", startTimestamp=" + String.valueOf(this.startTimestamp) + ", endTimestamp=" + String.valueOf(this.endTimestamp) + "]";
        }
    }
}

