/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.enrich;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.AsyncOperator;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.Operator;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.enrich.LookupFromIndexService;

public final class LookupFromIndexOperator
extends AsyncOperator {
    private final LookupFromIndexService lookupService;
    private final String sessionId;
    private final CancellableTask parentTask;
    private final int inputChannel;
    private final DataType inputDataType;
    private final String lookupIndex;
    private final String matchField;
    private final List<NamedExpression> loadFields;
    private final Source source;
    private long totalTerms = 0L;

    public LookupFromIndexOperator(String sessionId, DriverContext driverContext, CancellableTask parentTask, int maxOutstandingRequests, int inputChannel, LookupFromIndexService lookupService, DataType inputDataType, String lookupIndex, String matchField, List<NamedExpression> loadFields, Source source) {
        super(driverContext, maxOutstandingRequests);
        this.sessionId = sessionId;
        this.parentTask = parentTask;
        this.inputChannel = inputChannel;
        this.lookupService = lookupService;
        this.inputDataType = inputDataType;
        this.lookupIndex = lookupIndex;
        this.matchField = matchField;
        this.loadFields = loadFields;
        this.source = source;
    }

    protected void performAsync(Page inputPage, ActionListener<Page> listener) {
        Block inputBlock = inputPage.getBlock(this.inputChannel);
        this.totalTerms += (long)inputBlock.getTotalValueCount();
        LookupFromIndexService.Request request = new LookupFromIndexService.Request(this.sessionId, this.lookupIndex, this.inputDataType, this.matchField, new Page(new Block[]{inputBlock}), this.loadFields, this.source);
        this.lookupService.lookupAsync(request, this.parentTask, (ActionListener<Page>)listener.map(arg_0 -> ((Page)inputPage).appendPage(arg_0)));
    }

    public String toString() {
        return "LookupOperator[index=" + this.lookupIndex + " input_type=" + String.valueOf(this.inputDataType) + " match_field=" + this.matchField + " load_fields=" + String.valueOf(this.loadFields) + " inputChannel=" + this.inputChannel + "]";
    }

    protected void doClose() {
    }

    protected Operator.Status status(long receivedPages, long completedPages, long totalTimeInMillis) {
        return new Status(receivedPages, completedPages, totalTimeInMillis, this.totalTerms);
    }

    public static class Status
    extends AsyncOperator.Status {
        public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Operator.Status.class, "lookup", Status::new);
        final long totalTerms;

        Status(long receivedPages, long completedPages, long totalTimeInMillis, long totalTerms) {
            super(receivedPages, completedPages, totalTimeInMillis);
            this.totalTerms = totalTerms;
        }

        Status(StreamInput in) throws IOException {
            super(in);
            this.totalTerms = in.readVLong();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeVLong(this.totalTerms);
        }

        public String getWriteableName() {
            return Status.ENTRY.name;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            this.innerToXContent(builder);
            builder.field("total_terms", this.totalTerms);
            return builder.endObject();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass() || !super.equals(o)) {
                return false;
            }
            Status status = (Status)((Object)o);
            return this.totalTerms == status.totalTerms;
        }

        public int hashCode() {
            return Objects.hash(super.hashCode(), this.totalTerms);
        }
    }

    public record Factory(String sessionId, CancellableTask parentTask, int maxOutstandingRequests, int inputChannel, LookupFromIndexService lookupService, DataType inputDataType, String lookupIndex, String matchField, List<NamedExpression> loadFields, Source source) implements Operator.OperatorFactory
    {
        public String describe() {
            return "LookupOperator[index=" + this.lookupIndex + " match_field=" + this.matchField + " load_fields=" + String.valueOf(this.loadFields) + " inputChannel=" + this.inputChannel + "]";
        }

        public Operator get(DriverContext driverContext) {
            return new LookupFromIndexOperator(this.sessionId, driverContext, this.parentTask, this.maxOutstandingRequests, this.inputChannel, this.lookupService, this.inputDataType, this.lookupIndex, this.matchField, this.loadFields, this.source);
        }
    }
}

