/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.series;

import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;
import org.ojalgo.ProgrammingError;
import org.ojalgo.series.BasicSeries;
import org.ojalgo.series.TreeSeries;
import org.ojalgo.series.primitive.ExplicitTimeSeries;
import org.ojalgo.structure.Structure1D;
import org.ojalgo.type.CalendarDate;
import org.ojalgo.type.CalendarDateUnit;
import org.ojalgo.type.NumberDefinition;

public final class CalendarDateSeries<N extends Comparable<N>>
extends TreeSeries<CalendarDate, N, CalendarDateSeries<N>>
implements BasicSeries.NaturallySequenced<CalendarDate, N> {
    private static final long serialVersionUID = 1L;
    private final Structure1D.IndexMapper<CalendarDate> myMapper;
    private final CalendarDateUnit myResolution;

    public CalendarDateSeries() {
        this(CalendarDateUnit.MILLIS);
    }

    public CalendarDateSeries(CalendarDateUnit resolution) {
        this.myResolution = resolution;
        this.myMapper = new Structure1D.IndexMapper<CalendarDate>(){

            @Override
            public long toIndex(CalendarDate key) {
                return CalendarDateSeries.this.myResolution.adjustInto(key.millis);
            }

            @Override
            public CalendarDate toKey(long index) {
                return new CalendarDate(index);
            }
        };
    }

    private CalendarDateSeries(Map<? extends CalendarDate, ? extends N> map) {
        super(map);
        this.myResolution = null;
        this.myMapper = null;
    }

    private CalendarDateSeries(SortedMap<CalendarDate, ? extends N> sortedMap) {
        super(sortedMap);
        this.myResolution = null;
        this.myMapper = null;
    }

    CalendarDateSeries(SortedMap<CalendarDate, ? extends N> sortedMap, CalendarDateUnit resolution, Structure1D.IndexMapper<CalendarDate> mapper) {
        super(sortedMap);
        this.myResolution = resolution;
        this.myMapper = mapper;
    }

    @Override
    public long count() {
        return this.size();
    }

    @Override
    public double doubleValue(long index) {
        return this.doubleValue((Comparable)this.myMapper.toKey(index));
    }

    @Override
    public N get(CalendarDate key) {
        return (N)((Comparable)this.get((Object)key.filter(this.myResolution)));
    }

    @Override
    public N get(long index) {
        return this.get(this.myMapper.toKey(index));
    }

    public long getAverageStepSize() {
        return (((CalendarDate)this.lastKey()).millis - ((CalendarDate)this.firstKey()).millis) / (long)(this.size() - 1);
    }

    public long[] getPrimitiveKeys() {
        long[] retVal = new long[this.size()];
        int i = 0;
        for (CalendarDate tmpKey : this.keySet()) {
            retVal[i] = tmpKey.millis;
            ++i;
        }
        return retVal;
    }

    public ExplicitTimeSeries getPrimitiveTimeSeries() {
        return new ExplicitTimeSeries(this.getPrimitiveKeys(), this.asPrimitive());
    }

    public CalendarDateUnit getResolution() {
        return this.myResolution;
    }

    public CalendarDateSeries<N> headMap(CalendarDate newToKey) {
        SortedMap tmpMap = super.headMap(newToKey);
        CalendarDateSeries retVal = new CalendarDateSeries(tmpMap, this.getResolution(), this.myMapper);
        retVal.setColour(this.getColour());
        retVal.setName(this.getName());
        return retVal;
    }

    public CalendarDateSeries<N> headMap(CalendarDate newToKey, boolean newInclusive) {
        NavigableMap tmpMap = super.headMap(newToKey, newInclusive);
        CalendarDateSeries retVal = new CalendarDateSeries(tmpMap, this.getResolution(), this.myMapper);
        retVal.setColour(this.getColour());
        retVal.setName(this.getName());
        return retVal;
    }

    @Override
    public Structure1D.IndexMapper<CalendarDate> mapper() {
        return this.myMapper;
    }

    @Override
    public CalendarDate nextKey() {
        return ((CalendarDate)this.lastKey()).step(1, this.myResolution);
    }

    @Override
    public N put(Calendar key, N value) {
        return (N)((Comparable)super.put(CalendarDate.make(key, (CalendarDate.Resolution)this.myResolution), value));
    }

    @Override
    public double put(CalendarDate key, double value) {
        Double tmpValue = value;
        Comparable tmpOldValue = super.put(key.filter(this.myResolution), tmpValue);
        if (tmpOldValue != null) {
            return NumberDefinition.doubleValue(tmpOldValue);
        }
        return Double.NaN;
    }

    @Override
    public N put(CalendarDate key, N value) {
        return (N)((Comparable)super.put(key.filter(this.myResolution), value));
    }

    @Override
    public N put(Date key, N value) {
        return (N)((Comparable)super.put(CalendarDate.make(key, (CalendarDate.Resolution)this.myResolution), value));
    }

    @Override
    public double put(long index, double value) {
        return this.put(this.myMapper.toKey(index), value);
    }

    @Override
    public N put(long index, N value) {
        return (N)((Comparable)super.put(this.myMapper.toKey(index), value));
    }

    @Override
    public void putAll(Map<? extends CalendarDate, ? extends N> data) {
        for (Map.Entry<CalendarDate, N> tmpEntry : data.entrySet()) {
            this.put(tmpEntry.getKey(), (N)((Comparable)tmpEntry.getValue()));
        }
    }

    public CalendarDateSeries<N> resample(CalendarDate firstKey, CalendarDate lastKey, CalendarDate.Resolution resolution) {
        if (resolution instanceof CalendarDateUnit) {
            CalendarDateSeries<N> retVal = new CalendarDateSeries<N>((CalendarDateUnit)resolution);
            retVal.setColour(this.getColour());
            retVal.setName(this.getName());
            CalendarDateSeries<N> tmpSubMap = this.subMap(firstKey, true, lastKey, true);
            retVal.putAll(tmpSubMap);
            return retVal;
        }
        ProgrammingError.throwWithMessage("Only {} supported!", CalendarDateUnit.class.getSimpleName());
        return null;
    }

    public CalendarDateSeries<N> resample(CalendarDate.Resolution resolution) {
        if (resolution instanceof CalendarDateUnit) {
            CalendarDateSeries<N> retVal = new CalendarDateSeries<N>((CalendarDateUnit)resolution);
            retVal.setColour(this.getColour());
            retVal.setName(this.getName());
            retVal.putAll(this);
            return retVal;
        }
        ProgrammingError.throwWithMessage("Only {} supported!", CalendarDateUnit.class.getSimpleName());
        return null;
    }

    @Override
    public CalendarDate step(CalendarDate key) {
        return key.step(1, this.myResolution);
    }

    public CalendarDateSeries<N> subMap(CalendarDate fromKey, boolean inclusiveFromKey, CalendarDate toKey, boolean inclusiveToKey) {
        NavigableMap tmpMap = super.subMap(fromKey, inclusiveFromKey, toKey, inclusiveToKey);
        CalendarDateSeries retVal = new CalendarDateSeries(tmpMap, this.getResolution(), this.myMapper);
        retVal.setColour(this.getColour());
        retVal.setName(this.getName());
        return retVal;
    }

    public CalendarDateSeries<N> subMap(CalendarDate fromKey, CalendarDate keyLimit) {
        SortedMap tmpMap = super.subMap(fromKey, keyLimit);
        CalendarDateSeries retVal = new CalendarDateSeries(tmpMap, this.getResolution(), this.myMapper);
        retVal.setColour(this.getColour());
        retVal.setName(this.getName());
        return retVal;
    }

    public CalendarDateSeries<N> tailMap(CalendarDate fromKey) {
        SortedMap tmpMap = super.tailMap(fromKey);
        CalendarDateSeries retVal = new CalendarDateSeries(tmpMap, this.getResolution(), this.myMapper);
        retVal.setColour(this.getColour());
        retVal.setName(this.getName());
        return retVal;
    }

    public CalendarDateSeries<N> tailMap(CalendarDate fromKey, boolean inclusive) {
        NavigableMap tmpMap = super.tailMap(fromKey, inclusive);
        CalendarDateSeries retVal = new CalendarDateSeries(tmpMap, this.getResolution(), this.myMapper);
        retVal.setColour(this.getColour());
        retVal.setName(this.getName());
        return retVal;
    }

    @Override
    public String toString() {
        StringBuilder retVal = this.toStringFirstPart();
        retVal.append(this.myResolution);
        retVal.append('\u00a0');
        this.appendLastPartToString(retVal);
        return retVal.toString();
    }
}

