/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.data.domain.finance.portfolio;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.ojalgo.ProgrammingError;
import org.ojalgo.data.domain.finance.portfolio.FinancePortfolio;
import org.ojalgo.function.constant.BigMath;
import org.ojalgo.type.context.NumberContext;

final class NormalisedPortfolio
extends FinancePortfolio {
    private final FinancePortfolio myBasePortfolio;
    private transient BigDecimal myTotalWeight;
    private final NumberContext myWeightsContext;

    private NormalisedPortfolio() {
        this(null, null);
        ProgrammingError.throwForIllegalInvocation();
    }

    NormalisedPortfolio(FinancePortfolio basePortfolio, NumberContext weightsContext) {
        this.myBasePortfolio = basePortfolio;
        this.myWeightsContext = weightsContext;
    }

    @Override
    public double getMeanReturn() {
        return this.myBasePortfolio.getMeanReturn() / this.getTotalWeight().doubleValue();
    }

    @Override
    public double getVolatility() {
        return this.myBasePortfolio.getVolatility() / this.getTotalWeight().doubleValue();
    }

    @Override
    public List<BigDecimal> getWeights() {
        ArrayList<BigDecimal> retVal = new ArrayList<BigDecimal>();
        BigDecimal totalWeight = this.getTotalWeight();
        BigDecimal tmpSum = BigMath.ZERO;
        BigDecimal tmpLargest = BigMath.ZERO;
        int tmpIndexOfLargest = -1;
        List<BigDecimal> weights = this.myBasePortfolio.getWeights();
        for (int i = 0; i < weights.size(); ++i) {
            BigDecimal weight = weights.get(i);
            weight = BigMath.DIVIDE.invoke(weight, totalWeight);
            weight = this.myWeightsContext.enforce(weight);
            retVal.add(weight);
            tmpSum = tmpSum.add(weight);
            if (weight.abs().compareTo(tmpLargest) <= 0) continue;
            tmpLargest = weight.abs();
            tmpIndexOfLargest = i;
        }
        if (tmpSum.compareTo(BigMath.ONE) != 0 && tmpIndexOfLargest != -1) {
            retVal.set(tmpIndexOfLargest, ((BigDecimal)retVal.get(tmpIndexOfLargest)).subtract(tmpSum.subtract(BigMath.ONE)));
        }
        return retVal;
    }

    private BigDecimal getTotalWeight() {
        if (this.myTotalWeight == null) {
            this.myTotalWeight = BigMath.ZERO;
            for (BigDecimal tmpWeight : this.myBasePortfolio.getWeights()) {
                this.myTotalWeight = this.myTotalWeight.add(tmpWeight);
            }
            if (this.myTotalWeight.signum() == 0) {
                this.myTotalWeight = BigMath.ONE;
            }
        }
        return this.myTotalWeight;
    }

    @Override
    protected void reset() {
        this.myBasePortfolio.reset();
        this.myTotalWeight = null;
    }
}

