/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.connector.syncjob.action;

import java.io.IOException;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.application.connector.Connector;
import org.elasticsearch.xpack.application.connector.ConnectorUtils;
import org.elasticsearch.xpack.application.connector.action.ConnectorUpdateActionResponse;
import org.elasticsearch.xpack.application.connector.syncjob.ConnectorSyncJob;
import org.elasticsearch.xpack.application.connector.syncjob.action.ConnectorSyncJobActionRequest;

public class UpdateConnectorSyncJobIngestionStatsAction {
    public static final String NAME = "indices:data/write/xpack/connector/sync_job/update_stats";
    public static final ActionType<ConnectorUpdateActionResponse> INSTANCE = new ActionType("indices:data/write/xpack/connector/sync_job/update_stats");

    private UpdateConnectorSyncJobIngestionStatsAction() {
    }

    public static class Request
    extends ConnectorSyncJobActionRequest
    implements ToXContentObject {
        public static final ParseField CONNECTOR_SYNC_JOB_ID_FIELD = new ParseField("connector_sync_job_id", new String[0]);
        public static final String DELETED_DOCUMENT_COUNT_NEGATIVE_ERROR_MESSAGE = "[deleted_document_count] cannot be negative.";
        public static final String INDEXED_DOCUMENT_COUNT_NEGATIVE_ERROR_MESSAGE = "[indexed_document_count] cannot be negative.";
        public static final String INDEXED_DOCUMENT_VOLUME_NEGATIVE_ERROR_MESSAGE = "[indexed_document_volume] cannot be negative.";
        public static final String TOTAL_DOCUMENT_COUNT_NEGATIVE_ERROR_MESSAGE = "[total_document_count] cannot be negative.";
        private final String connectorSyncJobId;
        private final Long deletedDocumentCount;
        private final Long indexedDocumentCount;
        private final Long indexedDocumentVolume;
        private final Long totalDocumentCount;
        private final Instant lastSeen;
        private final Map<String, Object> metadata;
        private static final ConstructingObjectParser<Request, String> PARSER = new ConstructingObjectParser("connector_sync_job_update_ingestion_stats", false, (args, connectorSyncJobId) -> {
            Long deletedDocumentCount = (Long)args[0];
            Long indexedDocumentCount = (Long)args[1];
            Long indexedDocumentVolume = (Long)args[2];
            Long totalDocumentVolume = args[3] != null ? (Long)args[3] : null;
            Instant lastSeen = args[4] != null ? (Instant)args[4] : null;
            Map metadata = (Map)args[5];
            return new Request((String)connectorSyncJobId, deletedDocumentCount, indexedDocumentCount, indexedDocumentVolume, totalDocumentVolume, lastSeen, metadata);
        });

        public Request(StreamInput in) throws IOException {
            super(in);
            this.connectorSyncJobId = in.readString();
            this.deletedDocumentCount = in.readLong();
            this.indexedDocumentCount = in.readLong();
            this.indexedDocumentVolume = in.readLong();
            this.totalDocumentCount = in.readOptionalLong();
            this.lastSeen = in.readOptionalInstant();
            this.metadata = in.readGenericMap();
        }

        public Request(String connectorSyncJobId, Long deletedDocumentCount, Long indexedDocumentCount, Long indexedDocumentVolume, Long totalDocumentCount, Instant lastSeen, Map<String, Object> metadata) {
            this.connectorSyncJobId = connectorSyncJobId;
            this.deletedDocumentCount = deletedDocumentCount;
            this.indexedDocumentCount = indexedDocumentCount;
            this.indexedDocumentVolume = indexedDocumentVolume;
            this.totalDocumentCount = totalDocumentCount;
            this.lastSeen = lastSeen;
            this.metadata = metadata;
        }

        public String getConnectorSyncJobId() {
            return this.connectorSyncJobId;
        }

        public Long getDeletedDocumentCount() {
            return this.deletedDocumentCount;
        }

        public Long getIndexedDocumentCount() {
            return this.indexedDocumentCount;
        }

        public Long getIndexedDocumentVolume() {
            return this.indexedDocumentVolume;
        }

        public Long getTotalDocumentCount() {
            return this.totalDocumentCount;
        }

        public Instant getLastSeen() {
            return this.lastSeen;
        }

        public Map<String, Object> getMetadata() {
            return this.metadata;
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (Strings.isNullOrEmpty((String)this.connectorSyncJobId)) {
                validationException = ValidateActions.addValidationError((String)"[connector_sync_job_id] of the connector sync job cannot be null or empty.", validationException);
            }
            if (this.deletedDocumentCount < 0L) {
                validationException = ValidateActions.addValidationError((String)DELETED_DOCUMENT_COUNT_NEGATIVE_ERROR_MESSAGE, (ActionRequestValidationException)validationException);
            }
            if (this.indexedDocumentCount < 0L) {
                validationException = ValidateActions.addValidationError((String)INDEXED_DOCUMENT_COUNT_NEGATIVE_ERROR_MESSAGE, (ActionRequestValidationException)validationException);
            }
            if (this.indexedDocumentVolume < 0L) {
                validationException = ValidateActions.addValidationError((String)INDEXED_DOCUMENT_VOLUME_NEGATIVE_ERROR_MESSAGE, (ActionRequestValidationException)validationException);
            }
            if (Objects.nonNull(this.totalDocumentCount) && this.totalDocumentCount < 0L) {
                validationException = ValidateActions.addValidationError((String)TOTAL_DOCUMENT_COUNT_NEGATIVE_ERROR_MESSAGE, (ActionRequestValidationException)validationException);
            }
            return validationException;
        }

        public static Request fromXContent(XContentParser parser, String connectorSyncJobId) throws IOException {
            return (Request)((Object)PARSER.parse(parser, (Object)connectorSyncJobId));
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(ConnectorSyncJob.DELETED_DOCUMENT_COUNT_FIELD.getPreferredName(), this.deletedDocumentCount);
            builder.field(ConnectorSyncJob.INDEXED_DOCUMENT_COUNT_FIELD.getPreferredName(), this.indexedDocumentCount);
            builder.field(ConnectorSyncJob.INDEXED_DOCUMENT_VOLUME_FIELD.getPreferredName(), this.indexedDocumentVolume);
            builder.field(ConnectorSyncJob.TOTAL_DOCUMENT_COUNT_FIELD.getPreferredName(), this.totalDocumentCount);
            builder.field(ConnectorSyncJob.LAST_SEEN_FIELD.getPreferredName(), (Object)this.lastSeen);
            builder.field(ConnectorSyncJob.METADATA_FIELD.getPreferredName(), this.metadata);
            builder.endObject();
            return builder;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.connectorSyncJobId);
            out.writeLong(this.deletedDocumentCount.longValue());
            out.writeLong(this.indexedDocumentCount.longValue());
            out.writeLong(this.indexedDocumentVolume.longValue());
            out.writeOptionalLong(this.totalDocumentCount);
            out.writeOptionalInstant(this.lastSeen);
            out.writeGenericMap(this.metadata);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Objects.equals(this.connectorSyncJobId, request.connectorSyncJobId) && Objects.equals(this.deletedDocumentCount, request.deletedDocumentCount) && Objects.equals(this.indexedDocumentCount, request.indexedDocumentCount) && Objects.equals(this.indexedDocumentVolume, request.indexedDocumentVolume) && Objects.equals(this.totalDocumentCount, request.totalDocumentCount) && Objects.equals(this.lastSeen, request.lastSeen) && Objects.equals(this.metadata, request.metadata);
        }

        public int hashCode() {
            return Objects.hash(this.connectorSyncJobId, this.deletedDocumentCount, this.indexedDocumentCount, this.indexedDocumentVolume, this.totalDocumentCount, this.lastSeen, this.metadata);
        }

        static {
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), ConnectorSyncJob.DELETED_DOCUMENT_COUNT_FIELD);
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), ConnectorSyncJob.INDEXED_DOCUMENT_COUNT_FIELD);
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), ConnectorSyncJob.INDEXED_DOCUMENT_VOLUME_FIELD);
            PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), ConnectorSyncJob.TOTAL_DOCUMENT_COUNT_FIELD);
            PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ConnectorUtils.parseInstant(p, Connector.LAST_SEEN_FIELD.getPreferredName()), ConnectorSyncJob.LAST_SEEN_FIELD, ObjectParser.ValueType.OBJECT_OR_STRING);
            PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.map(), ConnectorSyncJob.METADATA_FIELD);
        }
    }
}

