/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.connector.secrets.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class PostConnectorSecretRequest
extends ActionRequest {
    private static final ParseField VALUE_FIELD = new ParseField("value", new String[0]);
    public static final ConstructingObjectParser<PostConnectorSecretRequest, Void> PARSER = new ConstructingObjectParser("post_secret_request", args -> new PostConnectorSecretRequest((String)args[0]));
    private final String value;

    public static PostConnectorSecretRequest fromXContent(XContentParser parser) throws IOException {
        return (PostConnectorSecretRequest)((Object)PARSER.parse(parser, null));
    }

    public PostConnectorSecretRequest(String value) {
        this.value = value;
    }

    public PostConnectorSecretRequest(StreamInput in) throws IOException {
        super(in);
        this.value = in.readString();
    }

    public String value() {
        return this.value;
    }

    public XContentBuilder toXContent(XContentBuilder builder) throws IOException {
        builder.startObject();
        builder.field(VALUE_FIELD.getPreferredName(), this.value);
        builder.endObject();
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.value);
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (Strings.isNullOrEmpty((String)this.value)) {
            validationException = ValidateActions.addValidationError((String)"[value] of the connector secret cannot be [null] or [\"\"]", validationException);
        }
        return validationException;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        PostConnectorSecretRequest that = (PostConnectorSecretRequest)((Object)o);
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    static {
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.text(), VALUE_FIELD, ObjectParser.ValueType.STRING);
    }
}

