/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.connector;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.scheduler.Cron;

public class ConnectorScheduling
implements Writeable,
ToXContentObject {
    private static final String EVERYDAY_AT_MIDNIGHT = "0 0 0 * * ?";
    private static final ParseField ACCESS_CONTROL_FIELD = new ParseField("access_control", new String[0]);
    private static final ParseField FULL_FIELD = new ParseField("full", new String[0]);
    private static final ParseField INCREMENTAL_FIELD = new ParseField("incremental", new String[0]);
    private final ScheduleConfig accessControl;
    private final ScheduleConfig full;
    private final ScheduleConfig incremental;
    private static final ConstructingObjectParser<ConnectorScheduling, Void> PARSER = new ConstructingObjectParser("connector_scheduling", true, args -> new Builder().setAccessControl((ScheduleConfig)args[0]).setFull((ScheduleConfig)args[1]).setIncremental((ScheduleConfig)args[2]).build());

    private ConnectorScheduling(ScheduleConfig accessControl, ScheduleConfig full, ScheduleConfig incremental) {
        this.accessControl = accessControl;
        this.full = full;
        this.incremental = incremental;
    }

    public ConnectorScheduling(StreamInput in) throws IOException {
        this.accessControl = new ScheduleConfig(in);
        this.full = new ScheduleConfig(in);
        this.incremental = new ScheduleConfig(in);
    }

    public ScheduleConfig getAccessControl() {
        return this.accessControl;
    }

    public ScheduleConfig getFull() {
        return this.full;
    }

    public ScheduleConfig getIncremental() {
        return this.incremental;
    }

    public static ConnectorScheduling fromXContentBytes(BytesReference source, XContentType xContentType) {
        ConnectorScheduling connectorScheduling;
        block8: {
            XContentParser parser = XContentHelper.createParser((XContentParserConfiguration)XContentParserConfiguration.EMPTY, (BytesReference)source, (XContentType)xContentType);
            try {
                connectorScheduling = ConnectorScheduling.fromXContent(parser);
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ElasticsearchParseException("Failed to parse: " + source.utf8ToString(), (Throwable)e, new Object[0]);
                }
            }
            parser.close();
        }
        return connectorScheduling;
    }

    public static ConnectorScheduling fromXContent(XContentParser parser) throws IOException {
        return (ConnectorScheduling)PARSER.parse(parser, null);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.accessControl != null) {
            builder.field(ACCESS_CONTROL_FIELD.getPreferredName(), (ToXContent)this.accessControl);
        }
        if (this.full != null) {
            builder.field(FULL_FIELD.getPreferredName(), (ToXContent)this.full);
        }
        if (this.incremental != null) {
            builder.field(INCREMENTAL_FIELD.getPreferredName(), (ToXContent)this.incremental);
        }
        builder.endObject();
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.accessControl.writeTo(out);
        this.full.writeTo(out);
        this.incremental.writeTo(out);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectorScheduling that = (ConnectorScheduling)o;
        return Objects.equals(this.accessControl, that.accessControl) && Objects.equals(this.full, that.full) && Objects.equals(this.incremental, that.incremental);
    }

    public int hashCode() {
        return Objects.hash(this.accessControl, this.full, this.incremental);
    }

    public static ConnectorScheduling getDefaultConnectorScheduling() {
        return new Builder().setAccessControl(new ScheduleConfig.Builder().setEnabled(false).setInterval(new Cron(EVERYDAY_AT_MIDNIGHT)).build()).setFull(new ScheduleConfig.Builder().setEnabled(false).setInterval(new Cron(EVERYDAY_AT_MIDNIGHT)).build()).setIncremental(new ScheduleConfig.Builder().setEnabled(false).setInterval(new Cron(EVERYDAY_AT_MIDNIGHT)).build()).build();
    }

    static {
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ScheduleConfig.fromXContent(p), ACCESS_CONTROL_FIELD, ObjectParser.ValueType.OBJECT);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ScheduleConfig.fromXContent(p), FULL_FIELD, ObjectParser.ValueType.OBJECT);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ScheduleConfig.fromXContent(p), INCREMENTAL_FIELD, ObjectParser.ValueType.OBJECT);
    }

    public static class ScheduleConfig
    implements Writeable,
    ToXContentObject {
        private final boolean enabled;
        private final Cron interval;
        private static final ParseField ENABLED_FIELD = new ParseField("enabled", new String[0]);
        private static final ParseField INTERVAL_FIELD = new ParseField("interval", new String[0]);
        private static final ConstructingObjectParser<ScheduleConfig, Void> PARSER = new ConstructingObjectParser("schedule_config", true, args -> new Builder().setEnabled((Boolean)args[0]).setInterval(new Cron((String)args[1])).build());

        private ScheduleConfig(boolean enabled, Cron interval) {
            this.enabled = enabled;
            this.interval = Objects.requireNonNull(interval, INTERVAL_FIELD.getPreferredName());
        }

        public ScheduleConfig(StreamInput in) throws IOException {
            this.enabled = in.readBoolean();
            this.interval = new Cron(in.readString());
        }

        public static ScheduleConfig fromXContent(XContentParser parser) throws IOException {
            return (ScheduleConfig)PARSER.parse(parser, null);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(ENABLED_FIELD.getPreferredName(), this.enabled);
            builder.field(INTERVAL_FIELD.getPreferredName(), (ToXContent)this.interval);
            builder.endObject();
            return builder;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeBoolean(this.enabled);
            out.writeString(this.interval.toString());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ScheduleConfig that = (ScheduleConfig)o;
            return this.enabled == that.enabled && Objects.equals(this.interval, that.interval);
        }

        public int hashCode() {
            return Objects.hash(this.enabled, this.interval);
        }

        static {
            PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), ENABLED_FIELD);
            PARSER.declareString(ConstructingObjectParser.constructorArg(), INTERVAL_FIELD);
        }

        public static class Builder {
            private boolean enabled;
            private Cron interval;

            public Builder setEnabled(boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder setInterval(Cron interval) {
                this.interval = interval;
                return this;
            }

            public ScheduleConfig build() {
                return new ScheduleConfig(this.enabled, this.interval);
            }
        }
    }

    public static class Builder {
        private ScheduleConfig accessControl;
        private ScheduleConfig full;
        private ScheduleConfig incremental;

        public Builder setAccessControl(ScheduleConfig accessControl) {
            this.accessControl = accessControl;
            return this;
        }

        public Builder setFull(ScheduleConfig full) {
            this.full = full;
            return this;
        }

        public Builder setIncremental(ScheduleConfig incremental) {
            this.incremental = incremental;
            return this;
        }

        public ConnectorScheduling build() {
            return new ConnectorScheduling(this.accessControl, this.full, this.incremental);
        }
    }
}

