/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.analytics;

import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.datastreams.CreateDataStreamAction;
import org.elasticsearch.action.datastreams.DeleteDataStreamAction;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.xpack.application.analytics.AnalyticsCollection;
import org.elasticsearch.xpack.application.analytics.AnalyticsCollectionResolver;
import org.elasticsearch.xpack.application.analytics.action.DeleteAnalyticsCollectionAction;
import org.elasticsearch.xpack.application.analytics.action.GetAnalyticsCollectionAction;
import org.elasticsearch.xpack.application.analytics.action.PutAnalyticsCollectionAction;

public class AnalyticsCollectionService {
    private static final Logger logger = LogManager.getLogger(AnalyticsCollectionService.class);
    private final Client clientWithOrigin;
    private final AnalyticsCollectionResolver analyticsCollectionResolver;

    @Inject
    public AnalyticsCollectionService(Client client, AnalyticsCollectionResolver analyticsCollectionResolver) {
        this.clientWithOrigin = new OriginSettingClient(client, "enterprise_search");
        this.analyticsCollectionResolver = analyticsCollectionResolver;
    }

    public void getAnalyticsCollection(ClusterState state, GetAnalyticsCollectionAction.Request request, ActionListener<GetAnalyticsCollectionAction.Response> listener) {
        assert (state.nodes().isLocalNodeElectedMaster());
        listener.onResponse((Object)new GetAnalyticsCollectionAction.Response(this.analyticsCollectionResolver.collections(state, request.getNames())));
    }

    public void putAnalyticsCollection(ClusterState state, PutAnalyticsCollectionAction.Request request, ActionListener<PutAnalyticsCollectionAction.Response> listener) {
        assert (state.nodes().isLocalNodeElectedMaster());
        AnalyticsCollection collection = new AnalyticsCollection(request.getName());
        CreateDataStreamAction.Request createDataStreamRequest = new CreateDataStreamAction.Request(TimeValue.THIRTY_SECONDS, TimeValue.THIRTY_SECONDS, collection.getEventDataStream());
        ActionListener createDataStreamListener = ActionListener.wrap(r -> listener.onResponse((Object)new PutAnalyticsCollectionAction.Response(r.isAcknowledged(), request.getName())), e -> {
            if (e instanceof ResourceAlreadyExistsException) {
                listener.onFailure((Exception)new ResourceAlreadyExistsException("analytics collection [{}] already exists", new Object[]{request.getName(), e}));
                return;
            }
            e = new ElasticsearchStatusException("error while creating analytics collection [{}]", ExceptionsHelper.status((Throwable)e), (Throwable)e, new Object[]{request.getName()});
            logger.error(e.getMessage(), (Throwable)e);
            listener.onFailure(e);
        });
        this.clientWithOrigin.execute((ActionType)CreateDataStreamAction.INSTANCE, (ActionRequest)createDataStreamRequest, createDataStreamListener);
    }

    public void deleteAnalyticsCollection(ClusterState state, DeleteAnalyticsCollectionAction.Request request, ActionListener<AcknowledgedResponse> listener) {
        assert (state.nodes().isLocalNodeElectedMaster());
        AnalyticsCollection collection = new AnalyticsCollection(request.getCollectionName());
        DeleteDataStreamAction.Request deleteDataStreamRequest = new DeleteDataStreamAction.Request(TimeValue.THIRTY_SECONDS, new String[]{collection.getEventDataStream()});
        ActionListener deleteDataStreamListener = ActionListener.wrap(arg_0 -> listener.onResponse(arg_0), e -> {
            if (e instanceof ResourceNotFoundException) {
                listener.onFailure((Exception)new ResourceNotFoundException("analytics collection [{}] does not exists", new Object[]{request.getCollectionName()}));
                return;
            }
            e = new ElasticsearchStatusException("error while deleting analytics collection [{}]", ExceptionsHelper.status((Throwable)e), (Throwable)e, new Object[]{request.getCollectionName()});
            logger.error(e.getMessage(), (Throwable)e);
            listener.onFailure(e);
        });
        this.clientWithOrigin.execute((ActionType)DeleteDataStreamAction.INSTANCE, (ActionRequest)deleteDataStreamRequest, deleteDataStreamListener);
    }
}

