/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.server.cli;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;

final class SystemJvmOptions {
    SystemJvmOptions() {
    }

    static List<String> systemJvmOptions(Settings nodeSettings, Map<String, String> sysprops) {
        String distroType = sysprops.get("es.distribution.type");
        boolean isHotspot = sysprops.getOrDefault("sun.management.compiler", "").contains("HotSpot");
        boolean useEntitlements = Boolean.parseBoolean(sysprops.getOrDefault("es.entitlements.enabled", "false"));
        return Stream.of(Stream.of("-Des.networkaddress.cache.ttl=60", "-Des.networkaddress.cache.negative.ttl=10", "-XX:+AlwaysPreTouch", "-Xss1m", "-Djava.awt.headless=true", "-Dfile.encoding=UTF-8", "-Djna.nosys=true", "-XX:-OmitStackTraceInFastThrow", "-Dio.netty.noUnsafe=true", "-Dio.netty.noKeySetOptimization=true", "-Dio.netty.recycler.maxCapacityPerThread=0", "-Dlog4j.shutdownHookEnabled=false", "-Dlog4j2.disable.jmx=true", "-Dlog4j2.formatMsgNoLookups=true", "-Djava.locale.providers=" + SystemJvmOptions.getLocaleProviders(), "-Des.distribution.type=" + distroType), SystemJvmOptions.maybeEnableNativeAccess(), SystemJvmOptions.maybeOverrideDockerCgroup(distroType), SystemJvmOptions.maybeSetActiveProcessorCount(nodeSettings), SystemJvmOptions.maybeSetReplayFile(distroType, isHotspot), SystemJvmOptions.maybeWorkaroundG1Bug(), SystemJvmOptions.maybeAllowSecurityManager(), SystemJvmOptions.maybeAttachEntitlementAgent(useEntitlements)).flatMap(s -> s).toList();
    }

    private static String getLocaleProviders() {
        return Runtime.version().feature() >= 23 ? "CLDR" : "SPI,COMPAT";
    }

    private static Stream<String> maybeOverrideDockerCgroup(String distroType) {
        if ("docker".equals(distroType)) {
            return Stream.of("-Des.cgroups.hierarchy.override=/");
        }
        return Stream.empty();
    }

    private static Stream<String> maybeSetReplayFile(String distroType, boolean isHotspot) {
        if (!isHotspot) {
            return Stream.empty();
        }
        String replayDir = "logs";
        if ("rpm".equals(distroType) || "deb".equals(distroType)) {
            replayDir = "/var/log/elasticsearch";
        }
        return Stream.of("-XX:ReplayDataFile=" + replayDir + "/replay_pid%p.log");
    }

    private static Stream<String> maybeSetActiveProcessorCount(Settings nodeSettings) {
        if (EsExecutors.NODE_PROCESSORS_SETTING.exists(nodeSettings)) {
            int allocated = EsExecutors.allocatedProcessors((Settings)nodeSettings);
            return Stream.of("-XX:ActiveProcessorCount=" + allocated);
        }
        return Stream.empty();
    }

    private static Stream<String> maybeEnableNativeAccess() {
        if (Runtime.version().feature() >= 21) {
            return Stream.of("--enable-native-access=org.elasticsearch.nativeaccess,org.apache.lucene.core");
        }
        return Stream.empty();
    }

    private static Stream<String> maybeWorkaroundG1Bug() {
        Runtime.Version v = Runtime.version();
        if (v.feature() == 22 && v.update() <= 1) {
            return Stream.of("-XX:+UnlockDiagnosticVMOptions", "-XX:G1NumCollectionsKeepPinned=10000000");
        }
        return Stream.of(new String[0]);
    }

    private static Stream<String> maybeAllowSecurityManager() {
        return Stream.of("-Djava.security.manager=allow");
    }

    private static Stream<String> maybeAttachEntitlementAgent(boolean useEntitlements) {
        String bridgeJar;
        if (!useEntitlements) {
            return Stream.empty();
        }
        Path dir = Path.of("lib", "entitlement-bridge");
        if (!Files.exists(dir, new LinkOption[0])) {
            throw new IllegalStateException("Directory for entitlement bridge jar does not exist: " + String.valueOf(dir));
        }
        try (Stream<Path> s = Files.list(dir);){
            List<Path> candidates = s.limit(2L).toList();
            if (candidates.size() != 1) {
                throw new IllegalStateException("Expected one jar in " + String.valueOf(dir) + "; found " + candidates.size());
            }
            bridgeJar = candidates.get(0).toString();
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to list entitlement jars in: " + String.valueOf(dir), e);
        }
        return Stream.of("-Des.entitlements.enabled=true", "-XX:+EnableDynamicAgentLoading", "-Djdk.attach.allowAttachSelf=true", "--patch-module=java.base=" + bridgeJar, "--add-exports=java.base/org.elasticsearch.entitlement.bridge=org.elasticsearch.entitlement");
    }
}

