/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.entitlement.initialization;

import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.core.internal.provider.ProviderLocator;
import org.elasticsearch.entitlement.bridge.EntitlementChecker;
import org.elasticsearch.entitlement.instrumentation.InstrumentationService;
import org.elasticsearch.entitlement.instrumentation.MethodKey;
import org.elasticsearch.entitlement.instrumentation.Transformer;
import org.elasticsearch.entitlement.runtime.api.ElasticsearchEntitlementChecker;

public class EntitlementInitialization {
    private static ElasticsearchEntitlementChecker manager;
    private static final InstrumentationService INSTRUMENTER_FACTORY;

    public static EntitlementChecker checker() {
        return manager;
    }

    public static void initialize(Instrumentation inst) throws Exception {
        manager = new ElasticsearchEntitlementChecker();
        Method targetMethod = System.class.getMethod("exit", Integer.TYPE);
        Method instrumentationMethod = Class.forName("org.elasticsearch.entitlement.bridge.EntitlementChecker").getMethod("checkSystemExit", Class.class, Integer.TYPE);
        Map<MethodKey, Method> methodMap = Map.of(INSTRUMENTER_FACTORY.methodKeyForTarget(targetMethod), instrumentationMethod);
        inst.addTransformer(new Transformer(INSTRUMENTER_FACTORY.newInstrumenter("", methodMap), Set.of(EntitlementInitialization.internalName(System.class))), true);
        inst.retransformClasses(System.class);
    }

    private static String internalName(Class<?> c) {
        return c.getName().replace('.', '/');
    }

    static {
        INSTRUMENTER_FACTORY = (InstrumentationService)new ProviderLocator("entitlement", InstrumentationService.class, "org.elasticsearch.entitlement.instrumentation", Set.of()).get();
    }
}

