/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ssl;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509ExtendedTrustManager;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.ssl.KeyStoreUtil;
import org.elasticsearch.common.ssl.PemUtils;
import org.elasticsearch.common.ssl.SslKeyConfig;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.env.Environment;
import org.elasticsearch.xpack.core.ssl.SslSettingsLoader;

public class CertParsingUtils {
    private CertParsingUtils() {
        throw new IllegalStateException("Utility class should not be instantiated");
    }

    public static X509Certificate readX509Certificate(Path path) throws CertificateException, IOException {
        List certificates = PemUtils.readCertificates(List.of(path));
        if (certificates.size() != 1) {
            throw new IllegalArgumentException("expected a single certificate in file [" + String.valueOf(path.toAbsolutePath()) + "] but found [" + certificates.size() + "]");
        }
        Certificate cert = (Certificate)certificates.get(0);
        if (cert instanceof X509Certificate) {
            return (X509Certificate)cert;
        }
        throw new IllegalArgumentException("the certificate in " + String.valueOf(path.toAbsolutePath()) + " is not an X.509 certificate (" + cert.getType() + " : " + String.valueOf(cert.getClass()) + ")");
    }

    public static X509Certificate[] readX509Certificates(List<Path> certPaths) throws CertificateException, IOException {
        return (X509Certificate[])PemUtils.readCertificates(certPaths).stream().map(X509Certificate.class::cast).toArray(X509Certificate[]::new);
    }

    public static List<Certificate> readCertificates(InputStream input) throws CertificateException, IOException {
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        Collection<? extends Certificate> certificates = certFactory.generateCertificates(input);
        return new ArrayList<Certificate>(certificates);
    }

    public static Map<Certificate, Key> readPkcs12KeyPairs(Path path, char[] password, Function<String, char[]> keyPassword) throws GeneralSecurityException, IOException {
        return CertParsingUtils.readKeyPairsFromKeystore(path, "PKCS12", password, keyPassword);
    }

    public static Map<Certificate, Key> readKeyPairsFromKeystore(Path path, String storeType, char[] password, Function<String, char[]> keyPassword) throws IOException, GeneralSecurityException {
        KeyStore store = KeyStoreUtil.readKeyStore((Path)path, (String)storeType, (char[])password);
        return CertParsingUtils.readKeyPairsFromKeystore(store, keyPassword);
    }

    private static Map<Certificate, Key> readKeyPairsFromKeystore(KeyStore store, Function<String, char[]> keyPassword) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        Enumeration<String> enumeration = store.aliases();
        Map map = Maps.newMapWithExpectedSize((int)store.size());
        while (enumeration.hasMoreElements()) {
            String alias = enumeration.nextElement();
            if (!store.isKeyEntry(alias)) continue;
            char[] pass = keyPassword.apply(alias);
            map.put(store.getCertificate(alias), store.getKey(alias, pass));
        }
        return map;
    }

    public static KeyStore getKeyStoreFromPEM(Path certificatePath, Path keyPath, char[] keyPassword) throws IOException, GeneralSecurityException {
        PrivateKey privateKey = PemUtils.readPrivateKey((Path)keyPath, () -> keyPassword);
        List certificates = PemUtils.readCertificates(List.of(certificatePath));
        return KeyStoreUtil.buildKeyStore((Collection)certificates, (PrivateKey)privateKey, (char[])keyPassword);
    }

    public static X509ExtendedKeyManager getKeyManagerFromPEM(Path certificatePath, Path keyPath, char[] keyPassword) throws IOException, GeneralSecurityException {
        KeyStore keyStore = CertParsingUtils.getKeyStoreFromPEM(certificatePath, keyPath, keyPassword);
        return KeyStoreUtil.createKeyManager((KeyStore)keyStore, (char[])keyPassword, (String)KeyManagerFactory.getDefaultAlgorithm());
    }

    public static SslKeyConfig createKeyConfig(Settings settings, String prefix, Environment environment, boolean acceptNonSecurePasswords) {
        SslSettingsLoader settingsLoader = new SslSettingsLoader(settings, prefix, acceptNonSecurePasswords);
        return settingsLoader.buildKeyConfig(environment.configFile());
    }

    public static X509ExtendedTrustManager getTrustManagerFromPEM(List<Path> caPaths) throws GeneralSecurityException, IOException {
        List certificates = PemUtils.readCertificates(caPaths);
        return KeyStoreUtil.createTrustManager((Collection)certificates);
    }

    public static boolean isOrderedCertificateChain(List<X509Certificate> chain) {
        for (int i = 1; i < chain.size(); ++i) {
            X509Certificate cert = chain.get(i - 1);
            X509Certificate issuer = chain.get(i);
            if (cert.getIssuerX500Principal().equals(issuer.getSubjectX500Principal())) continue;
            return false;
        }
        return true;
    }
}

