/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authc.ldap.support;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.core.security.authc.RealmSettings;
import org.elasticsearch.xpack.core.security.authc.ldap.support.LdapLoadBalancingSettings;
import org.elasticsearch.xpack.core.ssl.SSLConfigurationSettings;

public final class SessionFactorySettings {
    public static final Function<String, Setting.AffixSetting<List<String>>> URLS_SETTING = RealmSettings.affixSetting("url", key -> Setting.stringListSetting((String)key, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
    public static final TimeValue TIMEOUT_DEFAULT = TimeValue.timeValueSeconds((long)5L);
    public static final Function<String, Setting.AffixSetting<TimeValue>> TIMEOUT_TCP_CONNECTION_SETTING = RealmSettings.affixSetting("timeout.tcp_connect", key -> Setting.timeSetting((String)key, (TimeValue)TIMEOUT_DEFAULT, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
    public static final Function<String, Setting.AffixSetting<TimeValue>> TIMEOUT_LDAP_SETTING = RealmSettings.affixSetting("timeout.ldap_search", key -> Setting.timeSetting((String)key, (TimeValue)TIMEOUT_DEFAULT, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
    public static final Function<String, Setting.AffixSetting<TimeValue>> TIMEOUT_TCP_READ_SETTING = RealmSettings.affixSetting("timeout.tcp_read", key -> Setting.timeSetting((String)key, (TimeValue)TimeValue.MINUS_ONE, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.DeprecatedWarning}));
    public static final Function<String, Setting.AffixSetting<TimeValue>> TIMEOUT_RESPONSE_SETTING = RealmSettings.affixSetting("timeout.response", key -> Setting.timeSetting((String)key, (TimeValue)TimeValue.MINUS_ONE, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
    public static final Function<String, Setting.AffixSetting<Boolean>> HOSTNAME_VERIFICATION_SETTING = RealmSettings.affixSetting("hostname_verification", key -> Setting.boolSetting((String)key, (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
    public static final Function<String, Setting.AffixSetting<Boolean>> FOLLOW_REFERRALS_SETTING = RealmSettings.affixSetting("follow_referrals", key -> Setting.boolSetting((String)key, (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
    public static final Function<String, Setting.AffixSetting<Boolean>> IGNORE_REFERRAL_ERRORS_SETTING = RealmSettings.affixSetting("ignore_referral_errors", key -> Setting.boolSetting((String)key, (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));

    private SessionFactorySettings() {
    }

    public static Set<Setting.AffixSetting<?>> getSettings(String realmType) {
        HashSet settings = new HashSet();
        settings.addAll(LdapLoadBalancingSettings.getSettings(realmType));
        settings.add(URLS_SETTING.apply(realmType));
        settings.add(TIMEOUT_TCP_CONNECTION_SETTING.apply(realmType));
        settings.add(TIMEOUT_TCP_READ_SETTING.apply(realmType));
        settings.add(TIMEOUT_RESPONSE_SETTING.apply(realmType));
        settings.add(TIMEOUT_LDAP_SETTING.apply(realmType));
        settings.add(HOSTNAME_VERIFICATION_SETTING.apply(realmType));
        settings.add(FOLLOW_REFERRALS_SETTING.apply(realmType));
        settings.add(IGNORE_REFERRAL_ERRORS_SETTING.apply(realmType));
        settings.addAll(SSLConfigurationSettings.getRealmSettings(realmType));
        return settings;
    }
}

