/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.user;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.security.xcontent.XContentUtils;

public class ProfileHasPrivilegesResponse
extends ActionResponse
implements ToXContentObject {
    private final Set<String> hasPrivilegeUids;
    private final Map<String, Exception> errors;

    public ProfileHasPrivilegesResponse(StreamInput in) throws IOException {
        super(in);
        this.hasPrivilegeUids = in.readCollectionAsSet(StreamInput::readString);
        this.errors = in.readMap(StreamInput::readException);
    }

    public ProfileHasPrivilegesResponse(Set<String> hasPrivilegeUids, Map<String, Exception> errors) {
        this.hasPrivilegeUids = Objects.requireNonNull(hasPrivilegeUids);
        this.errors = Objects.requireNonNull(errors);
    }

    public Set<String> hasPrivilegeUids() {
        return this.hasPrivilegeUids;
    }

    public Map<String, Exception> errors() {
        return this.errors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ProfileHasPrivilegesResponse that = (ProfileHasPrivilegesResponse)((Object)o);
        return this.hasPrivilegeUids.equals(that.hasPrivilegeUids) && this.errors.keySet().equals(that.errors.keySet());
    }

    public int hashCode() {
        return Objects.hash(this.hasPrivilegeUids, this.errors.keySet());
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        XContentBuilder xContentBuilder = builder.startObject().stringListField("has_privilege_uids", this.hasPrivilegeUids);
        XContentUtils.maybeAddErrorDetails(builder, this.errors);
        return xContentBuilder.endObject();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeStringCollection(this.hasPrivilegeUids);
        out.writeMap(this.errors, StreamOutput::writeException);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "{has_privilege_uids=" + String.valueOf(this.hasPrivilegeUids) + ", errors=" + String.valueOf(this.errors) + "}";
    }
}

