/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.inference.results;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.inference.ChunkedInferenceServiceResults;
import org.elasticsearch.inference.InferenceResults;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.inference.results.InferenceTextEmbeddingFloatResults;
import org.elasticsearch.xpack.core.inference.results.TextEmbeddingUtils;
import org.elasticsearch.xpack.core.ml.inference.results.ChunkedNlpInferenceResults;
import org.elasticsearch.xpack.core.ml.inference.results.MlChunkedTextEmbeddingFloatResults;
import org.elasticsearch.xpack.core.utils.FloatConversionUtils;

public record InferenceChunkedTextEmbeddingFloatResults(List<InferenceFloatEmbeddingChunk> chunks) implements ChunkedInferenceServiceResults
{
    public static final String NAME = "chunked_text_embedding_service_float_results";
    public static final String FIELD_NAME = "text_embedding_float_chunk";

    public InferenceChunkedTextEmbeddingFloatResults(StreamInput in) throws IOException {
        this(in.readCollectionAsList(InferenceFloatEmbeddingChunk::new));
    }

    public static List<ChunkedInferenceServiceResults> listOf(List<String> inputs, InferenceTextEmbeddingFloatResults textEmbeddings) {
        TextEmbeddingUtils.validateInputSizeAgainstEmbeddings(inputs, textEmbeddings.embeddings().size());
        ArrayList<ChunkedInferenceServiceResults> results = new ArrayList<ChunkedInferenceServiceResults>(inputs.size());
        for (int i = 0; i < inputs.size(); ++i) {
            results.add(new InferenceChunkedTextEmbeddingFloatResults(List.of(new InferenceFloatEmbeddingChunk(inputs.get(i), textEmbeddings.embeddings().get(i).values()))));
        }
        return results;
    }

    public static InferenceChunkedTextEmbeddingFloatResults ofMlResults(MlChunkedTextEmbeddingFloatResults mlInferenceResult) {
        return new InferenceChunkedTextEmbeddingFloatResults(mlInferenceResult.getChunks().stream().map(chunk -> new InferenceFloatEmbeddingChunk(chunk.matchedText(), FloatConversionUtils.floatArrayOf(chunk.embedding()))).toList());
    }

    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
        return ChunkedToXContent.builder((ToXContent.Params)params).array(FIELD_NAME, this.chunks.iterator());
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeCollection(this.chunks);
    }

    public List<? extends InferenceResults> transformToCoordinationFormat() {
        throw new UnsupportedOperationException("Chunked results are not returned in the coordinated action");
    }

    public List<? extends InferenceResults> transformToLegacyFormat() {
        throw new UnsupportedOperationException("Chunked results are not returned in the legacy format");
    }

    public Map<String, Object> asMap() {
        return Map.of(FIELD_NAME, this.chunks);
    }

    public String getWriteableName() {
        return NAME;
    }

    public List<InferenceFloatEmbeddingChunk> getChunks() {
        return this.chunks;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InferenceChunkedTextEmbeddingFloatResults that = (InferenceChunkedTextEmbeddingFloatResults)o;
        return Objects.equals(this.chunks, that.chunks);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.chunks);
    }

    public Iterator<ChunkedInferenceServiceResults.Chunk> chunksAsMatchedTextAndByteReference(XContent xcontent) {
        return this.chunks.stream().map(chunk -> new ChunkedInferenceServiceResults.Chunk(chunk.matchedText(), InferenceChunkedTextEmbeddingFloatResults.toBytesReference(xcontent, chunk.embedding()))).iterator();
    }

    private static BytesReference toBytesReference(XContent xContent, float[] value) {
        try {
            XContentBuilder b = XContentBuilder.builder((XContent)xContent);
            b.startArray();
            for (float v : value) {
                b.value(v);
            }
            b.endArray();
            return BytesReference.bytes((XContentBuilder)b);
        }
        catch (IOException exc) {
            throw new RuntimeException(exc);
        }
    }

    public record InferenceFloatEmbeddingChunk(String matchedText, float[] embedding) implements Writeable,
    ToXContentObject
    {
        public InferenceFloatEmbeddingChunk(StreamInput in) throws IOException {
            this(in.readString(), in.readFloatArray());
        }

        public static InferenceFloatEmbeddingChunk of(String matchedText, double[] doubleEmbedding) {
            return new InferenceFloatEmbeddingChunk(matchedText, FloatConversionUtils.floatArrayOf(doubleEmbedding));
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.matchedText);
            out.writeFloatArray(this.embedding);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(ChunkedNlpInferenceResults.TEXT, this.matchedText);
            builder.startArray(ChunkedNlpInferenceResults.INFERENCE);
            for (float value : this.embedding) {
                builder.value(value);
            }
            builder.endArray();
            builder.endObject();
            return builder;
        }

        @Override
        public String toString() {
            return Strings.toString((ToXContent)this);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InferenceFloatEmbeddingChunk that = (InferenceFloatEmbeddingChunk)o;
            return Objects.equals(this.matchedText, that.matchedText) && Arrays.equals(this.embedding, that.embedding);
        }

        @Override
        public int hashCode() {
            int result = Objects.hash(this.matchedText);
            result = 31 * result + Arrays.hashCode(this.embedding);
            return result;
        }
    }
}

