/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.inference.action;

import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class DeleteInferenceEndpointAction
extends ActionType<Response> {
    public static final DeleteInferenceEndpointAction INSTANCE = new DeleteInferenceEndpointAction();
    public static final String NAME = "cluster:admin/xpack/inference/delete";

    public DeleteInferenceEndpointAction() {
        super(NAME);
    }

    public static class Response
    extends AcknowledgedResponse {
        private final String PIPELINE_IDS = "pipelines";
        Set<String> pipelineIds;
        private final String REFERENCED_INDEXES = "indexes";
        Set<String> indexes;
        private final String DRY_RUN_MESSAGE = "error_message";
        String dryRunMessage;

        public Response(boolean acknowledged, Set<String> pipelineIds, Set<String> semanticTextIndexes, @Nullable String dryRunMessage) {
            super(acknowledged);
            this.pipelineIds = pipelineIds;
            this.indexes = semanticTextIndexes;
            this.dryRunMessage = dryRunMessage;
        }

        public Response(StreamInput in) throws IOException {
            super(in);
            this.pipelineIds = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_15_0) ? in.readCollectionAsSet(StreamInput::readString) : Set.of();
            if (in.getTransportVersion().onOrAfter((VersionId)TransportVersions.ML_INFERENCE_DONT_DELETE_WHEN_SEMANTIC_TEXT_EXISTS)) {
                this.indexes = in.readCollectionAsSet(StreamInput::readString);
                this.dryRunMessage = in.readOptionalString();
            } else {
                this.indexes = Set.of();
                this.dryRunMessage = null;
            }
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_15_0)) {
                out.writeCollection(this.pipelineIds, StreamOutput::writeString);
            }
            if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.ML_INFERENCE_DONT_DELETE_WHEN_SEMANTIC_TEXT_EXISTS)) {
                out.writeCollection(this.indexes, StreamOutput::writeString);
                out.writeOptionalString(this.dryRunMessage);
            }
        }

        protected void addCustomFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
            super.addCustomFields(builder, params);
            builder.field("pipelines", this.pipelineIds);
            builder.field("indexes", this.indexes);
            if (this.dryRunMessage != null) {
                builder.field("error_message", this.dryRunMessage);
            }
        }

        public String toString() {
            return Strings.toString((ToXContent)this);
        }
    }

    public static class Request
    extends AcknowledgedRequest<Request> {
        private final String inferenceEndpointId;
        private final TaskType taskType;
        private final boolean forceDelete;
        private final boolean dryRun;

        public Request(String inferenceEndpointId, TaskType taskType, boolean forceDelete, boolean dryRun) {
            super(TRAPPY_IMPLICIT_DEFAULT_MASTER_NODE_TIMEOUT, DEFAULT_ACK_TIMEOUT);
            this.inferenceEndpointId = inferenceEndpointId;
            this.taskType = taskType;
            this.forceDelete = forceDelete;
            this.dryRun = dryRun;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.inferenceEndpointId = in.readString();
            this.taskType = TaskType.fromStream((StreamInput)in);
            if (in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_15_0)) {
                this.forceDelete = Boolean.TRUE.equals(in.readOptionalBoolean());
                this.dryRun = Boolean.TRUE.equals(in.readOptionalBoolean());
            } else {
                this.forceDelete = false;
                this.dryRun = false;
            }
        }

        public String getInferenceEndpointId() {
            return this.inferenceEndpointId;
        }

        public TaskType getTaskType() {
            return this.taskType;
        }

        public boolean isForceDelete() {
            return this.forceDelete;
        }

        public boolean isDryRun() {
            return this.dryRun;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.inferenceEndpointId);
            this.taskType.writeTo(out);
            if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_15_0)) {
                out.writeOptionalBoolean(Boolean.valueOf(this.forceDelete));
                out.writeOptionalBoolean(Boolean.valueOf(this.dryRun));
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Objects.equals(this.inferenceEndpointId, request.inferenceEndpointId) && this.taskType == request.taskType && this.forceDelete == request.forceDelete && this.dryRun == request.dryRun;
        }

        public int hashCode() {
            return Objects.hash(this.inferenceEndpointId, this.taskType, this.forceDelete, this.dryRun);
        }
    }
}

