/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.enrich;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import java.util.function.ToLongBiFunction;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.xpack.core.enrich.action.EnrichStatsAction;

public final class EnrichCache {
    private static final CacheValue EMPTY_CACHE_VALUE = new CacheValue(List.of(), 256L);
    private final Cache<CacheKey, CacheValue> cache;
    private final LongSupplier relativeNanoTimeProvider;
    private final AtomicLong hitsTimeInNanos = new AtomicLong(0L);
    private final AtomicLong missesTimeInNanos = new AtomicLong(0L);
    private final AtomicLong sizeInBytes = new AtomicLong(0L);

    EnrichCache(long maxSize) {
        this(maxSize, System::nanoTime);
    }

    EnrichCache(ByteSizeValue maxByteSize) {
        this(maxByteSize, System::nanoTime);
    }

    EnrichCache(long maxSize, LongSupplier relativeNanoTimeProvider) {
        this.relativeNanoTimeProvider = relativeNanoTimeProvider;
        this.cache = this.createCache(maxSize, null);
    }

    EnrichCache(ByteSizeValue maxByteSize, LongSupplier relativeNanoTimeProvider) {
        this.relativeNanoTimeProvider = relativeNanoTimeProvider;
        this.cache = this.createCache(maxByteSize.getBytes(), (key, value) -> value.sizeInBytes);
    }

    private Cache<CacheKey, CacheValue> createCache(long maxWeight, ToLongBiFunction<CacheKey, CacheValue> weigher) {
        CacheBuilder builder = CacheBuilder.builder().setMaximumWeight(maxWeight).removalListener(notification -> this.sizeInBytes.getAndAdd(-1L * ((CacheValue)notification.getValue()).sizeInBytes));
        if (weigher != null) {
            builder.weigher(weigher);
        }
        return builder.build();
    }

    public void computeIfAbsent(String enrichIndex, Object lookupValue, int maxMatches, Consumer<ActionListener<SearchResponse>> searchResponseFetcher, ActionListener<List<Map<?, ?>>> listener) {
        long cacheStart = this.relativeNanoTimeProvider.getAsLong();
        CacheKey cacheKey = new CacheKey(enrichIndex, lookupValue, maxMatches);
        List<Map<?, ?>> response = this.get(cacheKey);
        long cacheRequestTime = this.relativeNanoTimeProvider.getAsLong() - cacheStart;
        if (response != null) {
            this.hitsTimeInNanos.addAndGet(cacheRequestTime);
            listener.onResponse(response);
        } else {
            long retrieveStart = this.relativeNanoTimeProvider.getAsLong();
            searchResponseFetcher.accept((ActionListener<SearchResponse>)ActionListener.wrap(resp -> {
                CacheValue cacheValue = EnrichCache.toCacheValue(resp);
                this.put(cacheKey, cacheValue);
                List<Map<?, ?>> copy = EnrichCache.deepCopy(cacheValue.hits, false);
                long databaseQueryAndCachePutTime = this.relativeNanoTimeProvider.getAsLong() - retrieveStart;
                this.missesTimeInNanos.addAndGet(cacheRequestTime + databaseQueryAndCachePutTime);
                listener.onResponse(copy);
            }, arg_0 -> listener.onFailure(arg_0)));
        }
    }

    List<Map<?, ?>> get(CacheKey cacheKey) {
        CacheValue response = (CacheValue)this.cache.get((Object)cacheKey);
        if (response != null) {
            return EnrichCache.deepCopy(response.hits, false);
        }
        return null;
    }

    void put(CacheKey cacheKey, CacheValue cacheValue) {
        this.cache.put((Object)cacheKey, (Object)cacheValue);
        this.sizeInBytes.addAndGet(cacheValue.sizeInBytes);
    }

    public EnrichStatsAction.Response.CacheStats getStats(String localNodeId) {
        Cache.CacheStats cacheStats = this.cache.stats();
        return new EnrichStatsAction.Response.CacheStats(localNodeId, (long)this.cache.count(), cacheStats.getHits(), cacheStats.getMisses(), cacheStats.getEvictions(), TimeValue.nsecToMSec((long)this.hitsTimeInNanos.get()), TimeValue.nsecToMSec((long)this.missesTimeInNanos.get()), this.sizeInBytes.get());
    }

    static CacheValue toCacheValue(SearchResponse response) {
        if (response.getHits().getHits().length == 0) {
            return EMPTY_CACHE_VALUE;
        }
        ArrayList<Map> result = new ArrayList<Map>(response.getHits().getHits().length);
        long size = 256L;
        for (SearchHit hit : response.getHits()) {
            result.add(EnrichCache.deepCopy(hit.getSourceAsMap(), true));
            size += hit.getSourceRef() != null ? hit.getSourceRef().ramBytesUsed() : 0L;
        }
        return new CacheValue(Collections.unmodifiableList(result), size);
    }

    static <T> T deepCopy(T value, boolean unmodifiable) {
        return (T)EnrichCache.innerDeepCopy(value, unmodifiable);
    }

    private static Object innerDeepCopy(Object value, boolean unmodifiable) {
        if (value instanceof Map) {
            Map mapValue = (Map)value;
            Map copy = Maps.newMapWithExpectedSize((int)mapValue.size());
            for (Map.Entry entry : mapValue.entrySet()) {
                copy.put(entry.getKey(), EnrichCache.innerDeepCopy(entry.getValue(), unmodifiable));
            }
            return unmodifiable ? Collections.unmodifiableMap(copy) : copy;
        }
        if (value instanceof List) {
            List listValue = (List)value;
            ArrayList<Object> copy = new ArrayList<Object>(listValue.size());
            for (Object itemValue : listValue) {
                copy.add(EnrichCache.innerDeepCopy(itemValue, unmodifiable));
            }
            return unmodifiable ? Collections.unmodifiableList(copy) : copy;
        }
        if (value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            return Arrays.copyOf(bytes, bytes.length);
        }
        if (value == null || value instanceof String || value instanceof Number || value instanceof Boolean) {
            return value;
        }
        throw new IllegalArgumentException("unexpected value type [" + value.getClass() + "]");
    }

    record CacheKey(String enrichIndex, Object lookupValue, int maxMatches) {
        private static final long CACHE_KEY_SIZE = 256L;
    }

    record CacheValue(List<Map<?, ?>> hits, Long sizeInBytes) {
    }
}

