/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.searchbusinessrules;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.searchbusinessrules.CappedScoreQuery;
import org.elasticsearch.xpack.searchbusinessrules.SpecifiedDocument;

public class PinnedQueryBuilder
extends AbstractQueryBuilder<PinnedQueryBuilder> {
    public static final String NAME = "pinned";
    public static final int MAX_NUM_PINNED_HITS = 100;
    public static final ParseField IDS_FIELD = new ParseField("ids", new String[0]);
    public static final ParseField DOCS_FIELD = new ParseField("docs", new String[0]);
    public static final ParseField ORGANIC_QUERY_FIELD = new ParseField("organic", new String[0]);
    private final List<String> ids;
    private final List<SpecifiedDocument> docs;
    private QueryBuilder organicQuery;
    private static final float MAX_ORGANIC_SCORE = Float.intBitsToFloat(0x7F000000) - 1.0f;
    private static final ConstructingObjectParser<PinnedQueryBuilder, Void> PARSER = new ConstructingObjectParser("pinned", a -> {
        QueryBuilder organicQuery = (QueryBuilder)a[0];
        List ids = (List)a[1];
        List docs = (List)a[2];
        return new PinnedQueryBuilder(organicQuery, ids, docs);
    });

    public PinnedQueryBuilder(QueryBuilder organicQuery, String ... ids) {
        this(organicQuery, Arrays.asList(ids), null);
    }

    public PinnedQueryBuilder(QueryBuilder organicQuery, SpecifiedDocument ... docs) {
        this(organicQuery, null, Arrays.asList(docs));
    }

    private PinnedQueryBuilder(QueryBuilder organicQuery, List<String> ids, List<SpecifiedDocument> docs) {
        LinkedHashSet<Object> deduped;
        if (organicQuery == null) {
            throw new IllegalArgumentException("[pinned] organicQuery cannot be null");
        }
        this.organicQuery = organicQuery;
        if (ids == null && docs == null) {
            throw new IllegalArgumentException("[pinned] ids and docs cannot both be null");
        }
        if (ids != null && docs != null) {
            throw new IllegalArgumentException("[pinned] ids and docs cannot both be used");
        }
        if (ids != null) {
            if (ids.size() > 100) {
                throw new IllegalArgumentException("[pinned] Max of 100 ids exceeded: " + ids.size() + " provided.");
            }
            deduped = new LinkedHashSet<Object>();
            for (String id : ids) {
                if (id == null) {
                    throw new IllegalArgumentException("[pinned] id cannot be null");
                }
                if (deduped.add(id)) continue;
                throw new IllegalArgumentException("[pinned] duplicate id found in list: " + id);
            }
        }
        if (docs != null) {
            if (docs.size() > 100) {
                throw new IllegalArgumentException("[pinned] Max of 100 docs exceeded: " + docs.size() + " provided.");
            }
            deduped = new LinkedHashSet();
            for (SpecifiedDocument doc : docs) {
                if (doc == null) {
                    throw new IllegalArgumentException("[pinned] doc cannot be null");
                }
                if (deduped.add(doc)) continue;
                throw new IllegalArgumentException("[pinned] duplicate doc found in list: " + doc);
            }
        }
        this.ids = ids;
        this.docs = docs;
    }

    public PinnedQueryBuilder(StreamInput in) throws IOException {
        super(in);
        if (in.getTransportVersion().before((VersionId)TransportVersions.V_7_15_0)) {
            this.ids = in.readStringCollectionAsList();
            this.docs = null;
        } else {
            this.ids = in.readOptionalStringCollectionAsList();
            this.docs = in.readBoolean() ? in.readCollectionAsList(SpecifiedDocument::new) : null;
        }
        this.organicQuery = (QueryBuilder)in.readNamedWriteable(QueryBuilder.class);
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        if (out.getTransportVersion().before((VersionId)TransportVersions.V_7_15_0)) {
            out.writeStringCollection(this.ids);
        } else {
            out.writeOptionalStringCollection(this.ids);
            if (this.docs == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeCollection(this.docs);
            }
        }
        out.writeNamedWriteable((NamedWriteable)this.organicQuery);
    }

    public QueryBuilder organicQuery() {
        return this.organicQuery;
    }

    public List<String> ids() {
        if (this.ids == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.ids);
    }

    public List<SpecifiedDocument> docs() {
        if (this.docs == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.docs);
    }

    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        if (this.organicQuery != null) {
            builder.field(ORGANIC_QUERY_FIELD.getPreferredName());
            this.organicQuery.toXContent(builder, params);
        }
        if (this.ids != null) {
            builder.startArray(IDS_FIELD.getPreferredName());
            for (String value : this.ids) {
                builder.value(value);
            }
            builder.endArray();
        }
        if (this.docs != null) {
            builder.startArray(DOCS_FIELD.getPreferredName());
            for (SpecifiedDocument specifiedDocument : this.docs) {
                builder.value((ToXContent)specifiedDocument);
            }
            builder.endArray();
        }
        this.boostAndQueryNameToXContent(builder);
        builder.endObject();
    }

    public static PinnedQueryBuilder fromXContent(XContentParser parser) {
        try {
            return (PinnedQueryBuilder)((Object)PARSER.apply(parser, null));
        }
        catch (IllegalArgumentException e) {
            throw new ParsingException(parser.getTokenLocation(), e.getMessage(), (Throwable)e, new Object[0]);
        }
    }

    public String getWriteableName() {
        return NAME;
    }

    protected QueryBuilder doRewrite(QueryRewriteContext queryRewriteContext) throws IOException {
        QueryBuilder newOrganicQuery = this.organicQuery.rewrite(queryRewriteContext);
        if (newOrganicQuery != this.organicQuery) {
            PinnedQueryBuilder result = new PinnedQueryBuilder(newOrganicQuery, this.ids, this.docs);
            result.boost(this.boost);
            return result;
        }
        return this;
    }

    protected Query doToQuery(SearchExecutionContext context) throws IOException {
        List<SpecifiedDocument> specifiedDocuments;
        MappedFieldType idField = context.getFieldType("_id");
        if (idField == null) {
            return new MatchNoDocsQuery("No mappings");
        }
        List<SpecifiedDocument> list = specifiedDocuments = this.docs != null ? this.docs : this.ids.stream().map(id -> new SpecifiedDocument(null, (String)id)).toList();
        if (specifiedDocuments.isEmpty()) {
            return new CappedScoreQuery(this.organicQuery.toQuery(context), MAX_ORGANIC_SCORE);
        }
        ArrayList<BoostQuery> pinnedQueries = new ArrayList<BoostQuery>();
        int minPin = NumericUtils.floatToSortableInt((float)MAX_ORGANIC_SCORE) + 1;
        int boostNum = minPin + specifiedDocuments.size();
        float lastScore = Float.MAX_VALUE;
        for (SpecifiedDocument specifiedDocument : specifiedDocuments) {
            float pinScore = NumericUtils.sortableIntToFloat((int)boostNum);
            assert (pinScore < lastScore);
            lastScore = pinScore;
            --boostNum;
            if (specifiedDocument.index() != null && !context.indexMatches(specifiedDocument.index())) continue;
            BoostQuery idQuery = new BoostQuery((Query)new ConstantScoreQuery(idField.termQuery((Object)specifiedDocument.id(), context)), pinScore);
            pinnedQueries.add(idQuery);
        }
        ArrayList<Object> organicAndPinned = new ArrayList<Object>();
        organicAndPinned.add(new DisjunctionMaxQuery(pinnedQueries, 0.0f));
        organicAndPinned.add((Object)new CappedScoreQuery(this.organicQuery.toQuery(context), MAX_ORGANIC_SCORE));
        return new DisjunctionMaxQuery(organicAndPinned, 0.0f);
    }

    protected int doHashCode() {
        return Objects.hash(this.ids, this.docs, this.organicQuery);
    }

    protected boolean doEquals(PinnedQueryBuilder other) {
        return Objects.equals(this.ids, other.ids) && Objects.equals(this.docs, other.docs) && Objects.equals(this.organicQuery, other.organicQuery) && this.boost == other.boost;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_7_4_0;
    }

    static {
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> PinnedQueryBuilder.parseInnerQueryBuilder((XContentParser)p), ORGANIC_QUERY_FIELD);
        PARSER.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), IDS_FIELD);
        PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), SpecifiedDocument.PARSER, DOCS_FIELD);
        PinnedQueryBuilder.declareStandardFields(PARSER);
    }
}

