/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.siv;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;
import org.cryptomator.siv.org.bouncycastle.crypto.BlockCipher;
import org.cryptomator.siv.org.bouncycastle.crypto.CipherParameters;
import org.cryptomator.siv.org.bouncycastle.crypto.DataLengthException;
import org.cryptomator.siv.org.bouncycastle.crypto.params.KeyParameter;

final class JceAesBlockCipher
implements BlockCipher {
    private static final String ALG_NAME = "AES";
    private static final String KEY_DESIGNATION = "AES";
    private static final String SINGLE_BLOCK_PLAIN_AES_JCE_CIPHER_NAME = "AES/ECB/NoPadding";
    private final Cipher cipher;
    private Key key;
    private int opmode;

    JceAesBlockCipher() {
        this(null);
    }

    JceAesBlockCipher(Provider provider) {
        try {
            this.cipher = provider != null ? Cipher.getInstance(SINGLE_BLOCK_PLAIN_AES_JCE_CIPHER_NAME, provider) : Cipher.getInstance(SINGLE_BLOCK_PLAIN_AES_JCE_CIPHER_NAME);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new IllegalStateException("Every implementation of the Java platform is required to support AES/ECB/NoPadding.");
        }
    }

    @Override
    public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
        if (!(params instanceof KeyParameter)) {
            throw new IllegalArgumentException("Invalid or missing parameter of type KeyParameter.");
        }
        this.init(forEncryption, (KeyParameter)params);
    }

    private void init(boolean forEncryption, KeyParameter keyParam) throws IllegalArgumentException {
        this.key = new SecretKeySpec(keyParam.getKey(), "AES");
        this.opmode = forEncryption ? 1 : 2;
        try {
            this.cipher.init(this.opmode, this.key);
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException("Invalid key.", e);
        }
    }

    @Override
    public String getAlgorithmName() {
        return "AES";
    }

    @Override
    public int getBlockSize() {
        return this.cipher.getBlockSize();
    }

    @Override
    public int processBlock(byte[] in, int inOff, byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        if (in.length - inOff < this.getBlockSize()) {
            throw new DataLengthException("Insufficient data in 'in'.");
        }
        try {
            return this.cipher.update(in, inOff, this.getBlockSize(), out, outOff);
        }
        catch (ShortBufferException e) {
            throw new DataLengthException("Insufficient space in 'out'.");
        }
    }

    @Override
    public void reset() {
        if (this.key == null) {
            return;
        }
        try {
            this.cipher.init(this.opmode, this.key);
        }
        catch (InvalidKeyException e) {
            throw new IllegalStateException("cipher.init(...) already invoked successfully earlier with same parameters.");
        }
    }
}

