/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.searchablesnapshots.cache.blob;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.TransportBulkAction;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.search.ClosePointInTimeRequest;
import org.elasticsearch.action.search.ClosePointInTimeResponse;
import org.elasticsearch.action.search.OpenPointInTimeRequest;
import org.elasticsearch.action.search.OpenPointInTimeResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.TransportClosePointInTimeAction;
import org.elasticsearch.action.search.TransportOpenPointInTimeAction;
import org.elasticsearch.action.search.TransportSearchAction;
import org.elasticsearch.action.support.RefCountingListener;
import org.elasticsearch.action.support.TransportActions;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.RepositoriesMetadata;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.common.util.concurrent.ThrottledTaskRunner;
import org.elasticsearch.core.AbstractRefCounted;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.RefCounted;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryAction;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.PointInTimeBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.FieldAndFormat;
import org.elasticsearch.threadpool.Scheduler;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.searchablesnapshots.SearchableSnapshots;

public class BlobStoreCacheMaintenanceService
implements ClusterStateListener {
    private static final Logger logger = LogManager.getLogger(BlobStoreCacheMaintenanceService.class);
    public static final Setting<TimeValue> SNAPSHOT_SNAPSHOT_CLEANUP_INTERVAL_SETTING = Setting.timeSetting((String)"searchable_snapshots.blob_cache.periodic_cleanup.interval", (TimeValue)TimeValue.timeValueHours((long)1L), (TimeValue)TimeValue.ZERO, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<TimeValue> SNAPSHOT_SNAPSHOT_CLEANUP_KEEP_ALIVE_SETTING = Setting.timeSetting((String)"searchable_snapshots.blob_cache.periodic_cleanup.pit_keep_alive", (TimeValue)TimeValue.timeValueMinutes((long)10L), (TimeValue)TimeValue.timeValueSeconds((long)30L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<Integer> SNAPSHOT_SNAPSHOT_CLEANUP_BATCH_SIZE_SETTING = Setting.intSetting((String)"searchable_snapshots.blob_cache.periodic_cleanup.batch_size", (int)100, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<TimeValue> SNAPSHOT_SNAPSHOT_CLEANUP_RETENTION_PERIOD = Setting.timeSetting((String)"searchable_snapshots.blob_cache.periodic_cleanup.retention_period", (TimeValue)TimeValue.timeValueHours((long)1L), (TimeValue)TimeValue.ZERO, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    private final ClusterService clusterService;
    private final Client clientWithOrigin;
    private final String systemIndexName;
    private final ThreadPool threadPool;
    private volatile Scheduler.Cancellable periodicTask;
    private volatile TimeValue periodicTaskInterval;
    private volatile TimeValue periodicTaskKeepAlive;
    private volatile TimeValue periodicTaskRetention;
    private volatile int periodicTaskBatchSize;
    private volatile boolean schedulePeriodic;

    public BlobStoreCacheMaintenanceService(Settings settings, ClusterService clusterService, ThreadPool threadPool, Client client, String systemIndexName) {
        this.clientWithOrigin = new OriginSettingClient(Objects.requireNonNull(client), "searchable_snapshots");
        this.systemIndexName = Objects.requireNonNull(systemIndexName);
        this.clusterService = Objects.requireNonNull(clusterService);
        this.threadPool = Objects.requireNonNull(threadPool);
        this.periodicTaskInterval = (TimeValue)SNAPSHOT_SNAPSHOT_CLEANUP_INTERVAL_SETTING.get(settings);
        this.periodicTaskKeepAlive = (TimeValue)SNAPSHOT_SNAPSHOT_CLEANUP_KEEP_ALIVE_SETTING.get(settings);
        this.periodicTaskBatchSize = (Integer)SNAPSHOT_SNAPSHOT_CLEANUP_BATCH_SIZE_SETTING.get(settings);
        this.periodicTaskRetention = (TimeValue)SNAPSHOT_SNAPSHOT_CLEANUP_RETENTION_PERIOD.get(settings);
        ClusterSettings clusterSettings = clusterService.getClusterSettings();
        clusterSettings.addSettingsUpdateConsumer(SNAPSHOT_SNAPSHOT_CLEANUP_INTERVAL_SETTING, this::setPeriodicTaskInterval);
        clusterSettings.addSettingsUpdateConsumer(SNAPSHOT_SNAPSHOT_CLEANUP_KEEP_ALIVE_SETTING, this::setPeriodicTaskKeepAlive);
        clusterSettings.addSettingsUpdateConsumer(SNAPSHOT_SNAPSHOT_CLEANUP_BATCH_SIZE_SETTING, this::setPeriodicTaskBatchSize);
        clusterSettings.addSettingsUpdateConsumer(SNAPSHOT_SNAPSHOT_CLEANUP_RETENTION_PERIOD, this::setPeriodicTaskRetention);
    }

    public void clusterChanged(ClusterChangedEvent event) {
        ClusterState state = event.state();
        if (state.getBlocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            return;
        }
        ShardRouting primary = this.systemIndexPrimaryShard(state);
        if (primary == null || !primary.active() || !Objects.equals(state.nodes().getLocalNodeId(), primary.currentNodeId())) {
            this.stopPeriodicTask();
            return;
        }
        if (!event.indicesDeleted().isEmpty()) {
            this.threadPool.generic().execute((Runnable)((Object)new DeletedIndicesMaintenanceTask(event)));
        }
        if (this.periodicTask == null || this.periodicTask.isCancelled()) {
            this.schedulePeriodic = true;
            this.startPeriodicTask();
        }
    }

    private synchronized void setPeriodicTaskInterval(TimeValue interval) {
        this.periodicTaskInterval = interval;
    }

    private void setPeriodicTaskKeepAlive(TimeValue keepAlive) {
        this.periodicTaskKeepAlive = keepAlive;
    }

    public void setPeriodicTaskRetention(TimeValue retention) {
        this.periodicTaskRetention = retention;
    }

    public void setPeriodicTaskBatchSize(int batchSize) {
        this.periodicTaskBatchSize = batchSize;
    }

    private synchronized void startPeriodicTask() {
        if (this.schedulePeriodic) {
            try {
                TimeValue delay = this.periodicTaskInterval;
                if (delay.getMillis() > 0L) {
                    PeriodicMaintenanceTask task = new PeriodicMaintenanceTask(this.periodicTaskKeepAlive, this.periodicTaskBatchSize);
                    this.periodicTask = this.threadPool.schedule((Runnable)task, delay, (Executor)this.threadPool.generic());
                } else {
                    this.periodicTask = null;
                }
            }
            catch (EsRejectedExecutionException e) {
                if (e.isExecutorShutdown()) {
                    logger.debug("failed to schedule next periodic maintenance task for blob store cache, node is shutting down", (Throwable)e);
                }
                throw e;
            }
        }
    }

    private synchronized void stopPeriodicTask() {
        this.schedulePeriodic = false;
        if (this.periodicTask != null && !this.periodicTask.isCancelled()) {
            this.periodicTask.cancel();
            this.periodicTask = null;
        }
    }

    @Nullable
    private ShardRouting systemIndexPrimaryShard(ClusterState state) {
        IndexRoutingTable indexRoutingTable;
        IndexMetadata indexMetadata = state.metadata().index(this.systemIndexName);
        if (indexMetadata != null && (indexRoutingTable = state.routingTable().index(indexMetadata.getIndex())) != null) {
            return indexRoutingTable.shard(0).primaryShard();
        }
        return null;
    }

    private static boolean hasSearchableSnapshotWith(ClusterState state, String snapshotId, String indexId) {
        for (IndexMetadata indexMetadata : state.metadata()) {
            Settings indexSettings;
            if (!indexMetadata.isSearchableSnapshot() || !Objects.equals(snapshotId, SearchableSnapshots.SNAPSHOT_SNAPSHOT_ID_SETTING.get(indexSettings = indexMetadata.getSettings())) || !Objects.equals(indexId, SearchableSnapshots.SNAPSHOT_INDEX_ID_SETTING.get(indexSettings))) continue;
            return true;
        }
        return false;
    }

    private static Instant getExpirationTime(TimeValue retention, ThreadPool threadPool) {
        return Instant.ofEpochMilli(threadPool.absoluteTimeInMillis()).minus(retention.duration(), retention.timeUnit().toChronoUnit());
    }

    private static Map<String, Set<String>> listSearchableSnapshots(ClusterState state) {
        HashMap<String, Set> snapshots = null;
        for (IndexMetadata indexMetadata : state.metadata()) {
            if (!indexMetadata.isSearchableSnapshot()) continue;
            Settings indexSettings = indexMetadata.getSettings();
            if (snapshots == null) {
                snapshots = new HashMap<String, Set>();
            }
            snapshots.computeIfAbsent((String)SearchableSnapshots.SNAPSHOT_SNAPSHOT_ID_SETTING.get(indexSettings), s -> new HashSet()).add((String)SearchableSnapshots.SNAPSHOT_INDEX_ID_SETTING.get(indexSettings));
        }
        return snapshots != null ? Collections.unmodifiableMap(snapshots) : Collections.emptyMap();
    }

    static QueryBuilder buildDeleteByQuery(int numberOfShards, String snapshotUuid, String indexUuid) {
        Set paths = IntStream.range(0, numberOfShards).mapToObj(shard -> String.join((CharSequence)"/", snapshotUuid, indexUuid, String.valueOf(shard))).collect(Collectors.toSet());
        assert (!paths.isEmpty());
        return QueryBuilders.termsQuery((String)"blob.path", paths);
    }

    private static Instant getCreationTime(SearchHit searchHit) {
        DocumentField creationTimeField = searchHit.field("creation_time");
        assert (creationTimeField != null);
        Object creationTimeValue = creationTimeField.getValue();
        assert (creationTimeValue != null);
        assert (creationTimeValue instanceof String) : "expect a java.lang.String but got " + creationTimeValue.getClass();
        return Instant.ofEpochMilli(Long.parseLong((String)creationTimeField.getValue()));
    }

    private class DeletedIndicesMaintenanceTask
    extends AbstractRunnable {
        private final ClusterChangedEvent event;

        DeletedIndicesMaintenanceTask(ClusterChangedEvent event) {
            assert (!event.indicesDeleted().isEmpty());
            this.event = Objects.requireNonNull(event);
        }

        protected void doRun() {
            LinkedList<Tuple<DeleteByQueryRequest, ActionListener<BulkByScrollResponse>>> queue = new LinkedList<Tuple<DeleteByQueryRequest, ActionListener<BulkByScrollResponse>>>();
            ClusterState state = this.event.state();
            for (final Index deletedIndex : this.event.indicesDeleted()) {
                String indexId;
                IndexMetadata indexMetadata = this.event.previousState().metadata().index(deletedIndex);
                assert (indexMetadata != null || state.metadata().indexGraveyard().containsIndex(deletedIndex)) : "no previous metadata found for " + deletedIndex;
                if (indexMetadata == null || !indexMetadata.isSearchableSnapshot()) continue;
                assert (!state.metadata().hasIndex(deletedIndex));
                Settings indexSetting = indexMetadata.getSettings();
                final String snapshotId = (String)SearchableSnapshots.SNAPSHOT_SNAPSHOT_ID_SETTING.get(indexSetting);
                if (BlobStoreCacheMaintenanceService.hasSearchableSnapshotWith(state, snapshotId, indexId = (String)SearchableSnapshots.SNAPSHOT_INDEX_ID_SETTING.get(indexSetting))) {
                    logger.debug("snapshot [{}] of index {} is in use, skipping maintenance of snapshot blob cache entries", (Object)snapshotId, (Object)indexId);
                    continue;
                }
                DeleteByQueryRequest request = new DeleteByQueryRequest(new String[]{BlobStoreCacheMaintenanceService.this.systemIndexName});
                request.setQuery(BlobStoreCacheMaintenanceService.buildDeleteByQuery(indexMetadata.getNumberOfShards(), snapshotId, indexId));
                request.setRefresh(queue.isEmpty());
                queue.add((Tuple<DeleteByQueryRequest, ActionListener<BulkByScrollResponse>>)Tuple.tuple((Object)request, (Object)new ActionListener<BulkByScrollResponse>(){

                    public void onResponse(BulkByScrollResponse response) {
                        logger.debug("blob cache maintenance task deleted [{}] entries after deletion of {} (snapshot:{}, index:{})", (Object)response.getDeleted(), (Object)deletedIndex, (Object)snapshotId, (Object)indexId);
                    }

                    public void onFailure(Exception e) {
                        logger.debug(() -> Strings.format((String)"exception when executing blob cache maintenance task after deletion of %s (snapshot:%s, index:%s)", (Object[])new Object[]{deletedIndex, snapshotId, indexId}), (Throwable)e);
                    }
                }));
            }
            if (!queue.isEmpty()) {
                this.executeNextCleanUp(queue);
            }
        }

        void executeNextCleanUp(Queue<Tuple<DeleteByQueryRequest, ActionListener<BulkByScrollResponse>>> queue) {
            assert (ThreadPool.assertCurrentThreadPool((String[])new String[]{"generic"}));
            Tuple<DeleteByQueryRequest, ActionListener<BulkByScrollResponse>> next = queue.poll();
            if (next != null) {
                this.cleanUp((DeleteByQueryRequest)next.v1(), (ActionListener<BulkByScrollResponse>)((ActionListener)next.v2()), queue);
            }
        }

        void cleanUp(DeleteByQueryRequest request, ActionListener<BulkByScrollResponse> listener, Queue<Tuple<DeleteByQueryRequest, ActionListener<BulkByScrollResponse>>> queue) {
            assert (ThreadPool.assertCurrentThreadPool((String[])new String[]{"generic"}));
            BlobStoreCacheMaintenanceService.this.clientWithOrigin.execute((ActionType)DeleteByQueryAction.INSTANCE, (ActionRequest)request, ActionListener.runAfter(listener, () -> {
                if (!queue.isEmpty()) {
                    BlobStoreCacheMaintenanceService.this.threadPool.generic().execute(() -> this.executeNextCleanUp(queue));
                }
            }));
        }

        public void onFailure(Exception e) {
            logger.warn(() -> "snapshot blob cache maintenance task failed for cluster state update [" + this.event.source() + "]", (Throwable)e);
        }
    }

    private class PeriodicMaintenanceTask
    implements Runnable {
        private final TimeValue keepAlive;
        private final int batchSize;
        private final ThrottledTaskRunner taskRunner;
        private final AtomicLong deletes = new AtomicLong();
        private final AtomicLong total = new AtomicLong();

        PeriodicMaintenanceTask(TimeValue keepAlive, int batchSize) {
            this.keepAlive = keepAlive;
            this.batchSize = batchSize;
            this.taskRunner = new ThrottledTaskRunner(this.getClass().getCanonicalName(), 2, (Executor)BlobStoreCacheMaintenanceService.this.threadPool.generic());
        }

        @Override
        public void run() {
            ActionListener.run((ActionListener)ActionListener.runAfter((ActionListener)new ActionListener<Void>(){

                public void onResponse(Void unused) {
                    logger.info(() -> Strings.format((String)"periodic maintenance task completed (%s deleted documents out of a total of %s)", (Object[])new Object[]{PeriodicMaintenanceTask.this.deletes.get(), PeriodicMaintenanceTask.this.total.get()}));
                }

                public void onFailure(Exception e) {
                    logger.warn(() -> Strings.format((String)"periodic maintenance task completed with failure (%s deleted documents out of a total of %s)", (Object[])new Object[]{PeriodicMaintenanceTask.this.deletes.get(), PeriodicMaintenanceTask.this.total.get()}), (Throwable)e);
                }
            }, BlobStoreCacheMaintenanceService.this::startPeriodicTask), listener -> {
                OpenPointInTimeRequest openRequest = new OpenPointInTimeRequest(new String[]{".snapshot-blob-cache"});
                openRequest.keepAlive(this.keepAlive);
                BlobStoreCacheMaintenanceService.this.clientWithOrigin.execute(TransportOpenPointInTimeAction.TYPE, (ActionRequest)openRequest, (ActionListener)new ActionListener<OpenPointInTimeResponse>(){

                    public void onResponse(OpenPointInTimeResponse response) {
                        logger.trace("periodic maintenance task initialized with point-in-time id [{}]", (Object)response.getPointInTimeId());
                        BlobStoreCacheMaintenanceService.this.threadPool.generic().execute((Runnable)ActionRunnable.wrap((ActionListener)listener, l -> {
                            ClusterState state = BlobStoreCacheMaintenanceService.this.clusterService.state();
                            new RunningPeriodicMaintenanceTask(response.getPointInTimeId(), PeriodicMaintenanceTask.closingPitBefore(BlobStoreCacheMaintenanceService.this.clientWithOrigin, response.getPointInTimeId(), (ActionListener<Void>)l), BlobStoreCacheMaintenanceService.getExpirationTime(BlobStoreCacheMaintenanceService.this.periodicTaskRetention, BlobStoreCacheMaintenanceService.this.threadPool), BlobStoreCacheMaintenanceService.listSearchableSnapshots(state), RepositoriesMetadata.get((ClusterState)state).repositories().stream().map(RepositoryMetadata::name).collect(Collectors.toSet())).run();
                        }));
                    }

                    public void onFailure(Exception e) {
                        if (TransportActions.isShardNotAvailableException((Throwable)e)) {
                            listener.onResponse(null);
                        } else {
                            listener.onFailure(e);
                        }
                    }
                });
            });
        }

        private static ActionListener<Void> closingPitBefore(final Client client, final BytesReference pointInTimeId, final ActionListener<Void> listener) {
            return new ActionListener<Void>(){

                public void onResponse(Void unused) {
                    PeriodicMaintenanceTask.closePit(client, pointInTimeId, () -> listener.onResponse(null));
                }

                public void onFailure(Exception e) {
                    PeriodicMaintenanceTask.closePit(client, pointInTimeId, () -> listener.onFailure(e));
                }
            };
        }

        private static void closePit(Client client, final BytesReference pointInTimeId, final Runnable onCompletion) {
            client.execute(TransportClosePointInTimeAction.TYPE, (ActionRequest)new ClosePointInTimeRequest(pointInTimeId), (ActionListener)new ActionListener<ClosePointInTimeResponse>(){

                public void onResponse(ClosePointInTimeResponse response) {
                    if (response.isSucceeded()) {
                        logger.debug("periodic maintenance task successfully closed point-in-time id [{}]", (Object)pointInTimeId);
                    } else {
                        logger.debug("point-in-time id [{}] not found", (Object)pointInTimeId);
                    }
                    onCompletion.run();
                }

                public void onFailure(Exception e) {
                    logger.warn(() -> "failed to close point-in-time id [" + pointInTimeId + "]", (Throwable)e);
                    onCompletion.run();
                }
            });
        }

        private class RunningPeriodicMaintenanceTask
        implements Runnable {
            private final BytesReference pointInTimeId;
            private final RefCountingListener listeners;
            private final Instant expirationTime;
            private final Map<String, Set<String>> existingSnapshots;
            private final Set<String> existingRepositories;

            RunningPeriodicMaintenanceTask(BytesReference pointInTimeId, ActionListener<Void> listener, Instant expirationTime, Map<String, Set<String>> existingSnapshots, Set<String> existingRepositories) {
                this.pointInTimeId = pointInTimeId;
                this.listeners = new RefCountingListener(listener);
                this.expirationTime = expirationTime;
                this.existingSnapshots = existingSnapshots;
                this.existingRepositories = existingRepositories;
            }

            @Override
            public void run() {
                assert (ThreadPool.assertCurrentThreadPool((String[])new String[]{"generic"}));
                try (RefCountingListener refCountingListener = this.listeners;){
                    this.executeSearch(new SearchRequest().source(this.getSearchSourceBuilder().trackTotalHits(true)), (searchResponse, refs) -> {
                        assert (PeriodicMaintenanceTask.this.total.get() == 0L);
                        PeriodicMaintenanceTask.this.total.set(searchResponse.getHits().getTotalHits().value);
                        this.handleSearchResponse((SearchResponse)searchResponse, (RefCounted)refs);
                    });
                }
            }

            private void executeSearch(SearchRequest searchRequest, BiConsumer<SearchResponse, RefCounted> responseConsumer) {
                BlobStoreCacheMaintenanceService.this.clientWithOrigin.execute(TransportSearchAction.TYPE, (ActionRequest)searchRequest, this.listeners.acquire(searchResponse -> {
                    searchResponse.mustIncRef();
                    PeriodicMaintenanceTask.this.taskRunner.enqueueTask(ActionListener.runAfter((ActionListener)this.listeners.acquire(ref -> {
                        AbstractRefCounted refs = AbstractRefCounted.of(() -> ((Releasable)ref).close());
                        try {
                            responseConsumer.accept((SearchResponse)searchResponse, (RefCounted)refs);
                        }
                        finally {
                            refs.decRef();
                        }
                    }), () -> ((SearchResponse)searchResponse).decRef()));
                }));
            }

            private SearchSourceBuilder getSearchSourceBuilder() {
                return new SearchSourceBuilder().fetchField(new FieldAndFormat("creation_time", "epoch_millis")).fetchSource(false).trackScores(false).sort("_shard_doc").size(PeriodicMaintenanceTask.this.batchSize).pointInTimeBuilder(new PointInTimeBuilder(this.pointInTimeId).setKeepAlive(PeriodicMaintenanceTask.this.keepAlive));
            }

            private void handleSearchResponse(SearchResponse searchResponse, RefCounted refs) {
                assert (ThreadPool.assertCurrentThreadPool((String[])new String[]{"generic"}));
                if (this.listeners.isFailing()) {
                    return;
                }
                SearchHit[] searchHits = searchResponse.getHits().getHits();
                if (searchHits == null || searchHits.length == 0) {
                    return;
                }
                BulkRequest bulkRequest = new BulkRequest();
                Object[] lastSortValues = null;
                for (SearchHit searchHit : searchHits) {
                    lastSortValues = searchHit.getSortValues();
                    assert (searchHit.getId() != null);
                    try {
                        boolean delete = false;
                        Object[] parts = Objects.requireNonNull(searchHit.getId()).split("/");
                        assert (parts.length == 6) : Arrays.toString(parts) + " vs " + searchHit.getId();
                        String repositoryName = parts[0];
                        if (!this.existingRepositories.contains(repositoryName)) {
                            logger.trace("deleting blob store cache entry with id [{}]: repository does not exist", (Object)searchHit.getId());
                            delete = true;
                        } else {
                            Set<String> knownIndexIds = this.existingSnapshots.get(parts[1]);
                            if (knownIndexIds == null || !knownIndexIds.contains(parts[2])) {
                                logger.trace("deleting blob store cache entry with id [{}]: not used", (Object)searchHit.getId());
                                delete = true;
                            }
                        }
                        if (!delete) continue;
                        Instant creationTime = BlobStoreCacheMaintenanceService.getCreationTime(searchHit);
                        if (creationTime.isAfter(this.expirationTime)) {
                            logger.trace("blob store cache entry with id [{}] was created recently, skipping deletion", (Object)searchHit.getId());
                            continue;
                        }
                        bulkRequest.add(((DeleteRequest)new DeleteRequest().index(searchHit.getIndex())).id(searchHit.getId()));
                    }
                    catch (Exception e) {
                        logger.warn(() -> Strings.format((String)"exception when parsing blob store cache entry with id [%s], skipping", (Object[])new Object[]{searchHit.getId()}), (Throwable)e);
                    }
                }
                if (bulkRequest.numberOfActions() > 0) {
                    refs.mustIncRef();
                    BlobStoreCacheMaintenanceService.this.clientWithOrigin.execute(TransportBulkAction.TYPE, (ActionRequest)bulkRequest, ActionListener.releaseAfter((ActionListener)this.listeners.acquire(bulkResponse -> {
                        for (BulkItemResponse itemResponse : bulkResponse.getItems()) {
                            if (itemResponse.isFailed()) continue;
                            assert (itemResponse.getResponse() instanceof DeleteResponse);
                            PeriodicMaintenanceTask.this.deletes.incrementAndGet();
                        }
                    }), () -> ((RefCounted)refs).decRef()));
                }
                assert (lastSortValues != null);
                this.executeSearch(new SearchRequest().source(this.getSearchSourceBuilder().trackTotalHits(false).searchAfter(lastSortValues)), this::handleSearchResponse);
            }
        }
    }
}

