/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.tasks.TaskAwareRequest;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.transport.TransportMessage;

public abstract class TransportRequest
extends TransportMessage
implements TaskAwareRequest {
    private TaskId parentTaskId = TaskId.EMPTY_TASK_ID;
    private volatile long requestId = -1L;

    public TransportRequest() {
    }

    public TransportRequest(StreamInput in) throws IOException {
        this.parentTaskId = TaskId.readFromStream(in);
    }

    @Override
    public void setParentTask(TaskId taskId) {
        this.parentTaskId = taskId;
    }

    @Override
    public TaskId getParentTask() {
        return this.parentTaskId;
    }

    @Override
    public void setRequestId(long requestId) {
        this.requestId = requestId;
    }

    @Override
    public long getRequestId() {
        return this.requestId;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.parentTaskId.writeTo(out);
    }

    public String toString() {
        return this.getClass().getName() + "/" + this.getParentTask();
    }
}

