/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.threadpool;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.threadpool.ExecutorBuilder;
import org.elasticsearch.threadpool.FixedExecutorBuilder;
import org.elasticsearch.threadpool.ScalingExecutorBuilder;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.threadpool.internal.BuiltInExecutorBuilders;

public class DefaultBuiltInExecutorBuilders
implements BuiltInExecutorBuilders {
    @Override
    public Map<String, ExecutorBuilder> getBuilders(Settings settings, int allocatedProcessors) {
        int halfProc = ThreadPool.halfAllocatedProcessors(allocatedProcessors);
        int halfProcMaxAt5 = ThreadPool.halfAllocatedProcessorsMaxFive(allocatedProcessors);
        int halfProcMaxAt10 = ThreadPool.halfAllocatedProcessorsMaxTen(allocatedProcessors);
        int genericThreadPoolMax = ThreadPool.boundedBy(4 * allocatedProcessors, 128, 512);
        double indexAutoscalingEWMA = ThreadPool.WRITE_THREAD_POOLS_EWMA_ALPHA_SETTING.get(settings);
        HashMap<String, ExecutorBuilder> result = new HashMap<String, ExecutorBuilder>();
        result.put("generic", new ScalingExecutorBuilder("generic", 4, genericThreadPoolMax, TimeValue.timeValueSeconds((long)30L), false));
        result.put("write", new FixedExecutorBuilder(settings, "write", allocatedProcessors, 10000, new EsExecutors.TaskTrackingConfig(true, indexAutoscalingEWMA)));
        int searchOrGetThreadPoolSize = ThreadPool.searchOrGetThreadPoolSize(allocatedProcessors);
        result.put("get", new FixedExecutorBuilder(settings, "get", searchOrGetThreadPoolSize, 1000, EsExecutors.TaskTrackingConfig.DO_NOT_TRACK));
        result.put("analyze", new FixedExecutorBuilder(settings, "analyze", 1, 16, EsExecutors.TaskTrackingConfig.DO_NOT_TRACK));
        result.put("search", new FixedExecutorBuilder(settings, "search", searchOrGetThreadPoolSize, 1000, new EsExecutors.TaskTrackingConfig(true, 0.1)));
        result.put("search_coordination", new FixedExecutorBuilder(settings, "search_coordination", halfProc, 1000, new EsExecutors.TaskTrackingConfig(true, 0.1)));
        result.put("auto_complete", new FixedExecutorBuilder(settings, "auto_complete", Math.max(allocatedProcessors / 4, 1), 100, EsExecutors.TaskTrackingConfig.DEFAULT));
        result.put("search_throttled", new FixedExecutorBuilder(settings, "search_throttled", 1, 100, EsExecutors.TaskTrackingConfig.DEFAULT));
        result.put("management", new ScalingExecutorBuilder("management", 1, ThreadPool.boundedBy(allocatedProcessors, 1, 5), TimeValue.timeValueMinutes((long)5L), false));
        result.put("flush", new ScalingExecutorBuilder("flush", 1, halfProcMaxAt5, TimeValue.timeValueMinutes((long)5L), false));
        int refreshThreads = DiscoveryNode.isStateless(settings) ? allocatedProcessors : halfProcMaxAt10;
        result.put("refresh", new ScalingExecutorBuilder("refresh", 1, refreshThreads, TimeValue.timeValueMinutes((long)5L), false));
        result.put("warmer", new ScalingExecutorBuilder("warmer", 1, halfProcMaxAt5, TimeValue.timeValueMinutes((long)5L), false));
        int maxSnapshotCores = ThreadPool.getMaxSnapshotThreadPoolSize(allocatedProcessors);
        result.put("snapshot", new ScalingExecutorBuilder("snapshot", 1, maxSnapshotCores, TimeValue.timeValueMinutes((long)5L), false));
        result.put("snapshot_meta", new ScalingExecutorBuilder("snapshot_meta", 1, Math.min(allocatedProcessors * 3, 50), TimeValue.timeValueSeconds((long)30L), false));
        result.put("fetch_shard_started", new ScalingExecutorBuilder("fetch_shard_started", 1, 2 * allocatedProcessors, TimeValue.timeValueMinutes((long)5L), false));
        result.put("force_merge", new FixedExecutorBuilder(settings, "force_merge", ThreadPool.oneEighthAllocatedProcessors(allocatedProcessors), -1, EsExecutors.TaskTrackingConfig.DO_NOT_TRACK));
        result.put("cluster_coordination", new FixedExecutorBuilder(settings, "cluster_coordination", 1, -1, EsExecutors.TaskTrackingConfig.DO_NOT_TRACK));
        result.put("fetch_shard_store", new ScalingExecutorBuilder("fetch_shard_store", 1, 2 * allocatedProcessors, TimeValue.timeValueMinutes((long)5L), false));
        result.put("system_read", new FixedExecutorBuilder(settings, "system_read", halfProcMaxAt5, 2000, EsExecutors.TaskTrackingConfig.DO_NOT_TRACK));
        result.put("system_write", new FixedExecutorBuilder(settings, "system_write", halfProcMaxAt5, 1000, new EsExecutors.TaskTrackingConfig(true, indexAutoscalingEWMA)));
        result.put("system_critical_read", new FixedExecutorBuilder(settings, "system_critical_read", halfProcMaxAt5, 2000, EsExecutors.TaskTrackingConfig.DO_NOT_TRACK));
        result.put("system_critical_write", new FixedExecutorBuilder(settings, "system_critical_write", halfProcMaxAt5, 1500, new EsExecutors.TaskTrackingConfig(true, indexAutoscalingEWMA)));
        return Collections.unmodifiableMap(result);
    }
}

