/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.rank.rerank;

import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.rank.RankShardResult;
import org.elasticsearch.search.rank.context.RankFeaturePhaseRankShardContext;
import org.elasticsearch.search.rank.feature.RankFeatureDoc;
import org.elasticsearch.search.rank.feature.RankFeatureShardResult;

public class RerankingRankFeaturePhaseRankShardContext
extends RankFeaturePhaseRankShardContext {
    private static final Logger logger = LogManager.getLogger(RerankingRankFeaturePhaseRankShardContext.class);

    public RerankingRankFeaturePhaseRankShardContext(String field) {
        super(field);
    }

    @Override
    public RankShardResult buildRankFeatureShardResult(SearchHits hits, int shardId) {
        try {
            RankFeatureDoc[] rankFeatureDocs = new RankFeatureDoc[hits.getHits().length];
            for (int i = 0; i < hits.getHits().length; ++i) {
                rankFeatureDocs[i] = new RankFeatureDoc(hits.getHits()[i].docId(), hits.getHits()[i].getScore(), shardId);
                DocumentField docField = hits.getHits()[i].field(this.field);
                if (docField == null) continue;
                rankFeatureDocs[i].featureData(docField.getValue().toString());
            }
            return new RankFeatureShardResult(rankFeatureDocs);
        }
        catch (Exception ex) {
            logger.warn("Error while fetching feature data for {field: [" + this.field + "]} and {docids: [" + Arrays.stream(hits.getHits()).map(SearchHit::docId).toList() + "]}.", (Throwable)ex);
            return null;
        }
    }
}

