/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.search.ScoreDoc;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.RescoreDocIds;
import org.elasticsearch.search.dfs.AggregatedDfs;
import org.elasticsearch.search.fetch.ShardFetchRequest;
import org.elasticsearch.search.internal.ShardSearchContextId;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.search.rank.RankDocShardInfo;

public class ShardFetchSearchRequest
extends ShardFetchRequest
implements IndicesRequest {
    private final OriginalIndices originalIndices;
    private final ShardSearchRequest shardSearchRequest;
    private final RescoreDocIds rescoreDocIds;
    private final AggregatedDfs aggregatedDfs;
    private final RankDocShardInfo rankDocs;

    public ShardFetchSearchRequest(OriginalIndices originalIndices, ShardSearchContextId id, ShardSearchRequest shardSearchRequest, List<Integer> docIds, RankDocShardInfo rankDocs, ScoreDoc lastEmittedDoc, RescoreDocIds rescoreDocIds, AggregatedDfs aggregatedDfs) {
        super(id, docIds, lastEmittedDoc);
        this.originalIndices = originalIndices;
        this.shardSearchRequest = shardSearchRequest;
        this.rescoreDocIds = rescoreDocIds;
        this.aggregatedDfs = aggregatedDfs;
        this.rankDocs = rankDocs;
    }

    public ShardFetchSearchRequest(StreamInput in) throws IOException {
        super(in);
        this.originalIndices = OriginalIndices.readOriginalIndices(in);
        this.shardSearchRequest = in.readOptionalWriteable(ShardSearchRequest::new);
        this.rescoreDocIds = new RescoreDocIds(in);
        this.aggregatedDfs = in.readOptionalWriteable(AggregatedDfs::new);
        this.rankDocs = in.getTransportVersion().onOrAfter(TransportVersions.RANK_DOC_IN_SHARD_FETCH_REQUEST) ? in.readOptionalWriteable(RankDocShardInfo::new) : null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        OriginalIndices.writeOriginalIndices(this.originalIndices, out);
        out.writeOptionalWriteable(this.shardSearchRequest);
        this.rescoreDocIds.writeTo(out);
        out.writeOptionalWriteable(this.aggregatedDfs);
        if (out.getTransportVersion().onOrAfter(TransportVersions.RANK_DOC_IN_SHARD_FETCH_REQUEST)) {
            out.writeOptionalWriteable(this.rankDocs);
        }
    }

    @Override
    public String[] indices() {
        if (this.originalIndices == null) {
            return null;
        }
        return this.originalIndices.indices();
    }

    @Override
    public IndicesOptions indicesOptions() {
        if (this.originalIndices == null) {
            return null;
        }
        return this.originalIndices.indicesOptions();
    }

    @Override
    public ShardSearchRequest getShardSearchRequest() {
        return this.shardSearchRequest;
    }

    @Override
    public RescoreDocIds getRescoreDocIds() {
        return this.rescoreDocIds;
    }

    @Override
    public AggregatedDfs getAggregatedDfs() {
        return this.aggregatedDfs;
    }

    @Override
    public RankDocShardInfo getRankDocks() {
        return this.rankDocs;
    }
}

