/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.LongPredicate;
import java.util.function.LongUnaryOperator;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.common.util.LongHash;
import org.elasticsearch.common.util.ObjectArrayPriorityQueue;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.AggregationExecutionContext;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import org.elasticsearch.search.aggregations.InternalOrder;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.bucket.terms.AbstractStringTermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.BucketPriorityQueue;
import org.elasticsearch.search.aggregations.bucket.terms.BucketSignificancePriorityQueue;
import org.elasticsearch.search.aggregations.bucket.terms.InternalTerms;
import org.elasticsearch.search.aggregations.bucket.terms.LongKeyedBucketOrds;
import org.elasticsearch.search.aggregations.bucket.terms.SignificanceLookup;
import org.elasticsearch.search.aggregations.bucket.terms.SignificantStringTerms;
import org.elasticsearch.search.aggregations.bucket.terms.StringTerms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.heuristic.SignificanceHeuristic;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.xcontent.XContentBuilder;

public class GlobalOrdinalsStringTermsAggregator
extends AbstractStringTermsAggregator {
    protected final ResultStrategy<?, ?, ?> resultStrategy;
    protected final ValuesSource.Bytes.WithOrdinals valuesSource;
    private final LongPredicate acceptedGlobalOrdinals;
    private final CheckedSupplier<SortedSetDocValues, IOException> valuesSupplier;
    private final long valueCount;
    protected final CollectionStrategy collectionStrategy;
    protected int segmentsWithSingleValuedOrds = 0;
    protected int segmentsWithMultiValuedOrds = 0;
    static final LongPredicate ALWAYS_TRUE = l -> true;

    public GlobalOrdinalsStringTermsAggregator(String name, AggregatorFactories factories, Function<GlobalOrdinalsStringTermsAggregator, ResultStrategy<?, ?, ?>> resultStrategy, ValuesSource.Bytes.WithOrdinals valuesSource, CheckedSupplier<SortedSetDocValues, IOException> valuesSupplier, BucketOrder order, DocValueFormat format, TermsAggregator.BucketCountThresholds bucketCountThresholds, LongPredicate acceptedOrds, AggregationContext context, Aggregator parent, boolean remapGlobalOrds, Aggregator.SubAggCollectionMode collectionMode, boolean showTermDocCountError, CardinalityUpperBound cardinality, Map<String, Object> metadata, boolean excludeDeletedDocs) throws IOException {
        super(name, factories, context, parent, order, format, bucketCountThresholds, collectionMode, showTermDocCountError, metadata);
        this.resultStrategy = resultStrategy.apply(this);
        this.valuesSource = valuesSource;
        this.valuesSupplier = valuesSupplier;
        this.valueCount = valuesSupplier.get().getValueCount();
        this.acceptedGlobalOrdinals = acceptedOrds;
        this.collectionStrategy = remapGlobalOrds ? new RemapGlobalOrds(cardinality, excludeDeletedDocs) : (CollectionStrategy)cardinality.map(estimate -> {
            if (estimate > 1) {
                throw new AggregationExecutionException("Dense ords don't know how to collect from many buckets");
            }
            return new DenseGlobalOrds(excludeDeletedDocs);
        });
    }

    String descriptCollectionStrategy() {
        return this.collectionStrategy.describe();
    }

    @Override
    public LeafBucketCollector getLeafCollector(AggregationExecutionContext aggCtx, final LeafBucketCollector sub) throws IOException {
        final SortedSetDocValues globalOrds = this.valuesSource.globalOrdinalsValues(aggCtx.getLeafReaderContext());
        this.collectionStrategy.globalOrdsReady(globalOrds);
        final SortedDocValues singleValues = DocValues.unwrapSingleton((SortedSetDocValues)globalOrds);
        if (singleValues != null) {
            ++this.segmentsWithSingleValuedOrds;
            if (this.acceptedGlobalOrdinals == ALWAYS_TRUE) {
                return this.resultStrategy.wrapCollector(new LeafBucketCollectorBase(sub, globalOrds){

                    @Override
                    public void collect(int doc, long owningBucketOrd) throws IOException {
                        if (!singleValues.advanceExact(doc)) {
                            return;
                        }
                        int globalOrd = singleValues.ordValue();
                        GlobalOrdinalsStringTermsAggregator.this.collectionStrategy.collectGlobalOrd(owningBucketOrd, doc, globalOrd, sub);
                    }
                });
            }
            return this.resultStrategy.wrapCollector(new LeafBucketCollectorBase(sub, globalOrds){

                @Override
                public void collect(int doc, long owningBucketOrd) throws IOException {
                    if (!singleValues.advanceExact(doc)) {
                        return;
                    }
                    int globalOrd = singleValues.ordValue();
                    if (!GlobalOrdinalsStringTermsAggregator.this.acceptedGlobalOrdinals.test(globalOrd)) {
                        return;
                    }
                    GlobalOrdinalsStringTermsAggregator.this.collectionStrategy.collectGlobalOrd(owningBucketOrd, doc, globalOrd, sub);
                }
            });
        }
        ++this.segmentsWithMultiValuedOrds;
        if (this.acceptedGlobalOrdinals == ALWAYS_TRUE) {
            return this.resultStrategy.wrapCollector(new LeafBucketCollectorBase(sub, globalOrds){

                @Override
                public void collect(int doc, long owningBucketOrd) throws IOException {
                    if (!globalOrds.advanceExact(doc)) {
                        return;
                    }
                    long globalOrd = globalOrds.nextOrd();
                    while (globalOrd != -1L) {
                        GlobalOrdinalsStringTermsAggregator.this.collectionStrategy.collectGlobalOrd(owningBucketOrd, doc, globalOrd, sub);
                        globalOrd = globalOrds.nextOrd();
                    }
                }
            });
        }
        return this.resultStrategy.wrapCollector(new LeafBucketCollectorBase(sub, globalOrds){

            @Override
            public void collect(int doc, long owningBucketOrd) throws IOException {
                if (!globalOrds.advanceExact(doc)) {
                    return;
                }
                long globalOrd = globalOrds.nextOrd();
                while (globalOrd != -1L) {
                    if (GlobalOrdinalsStringTermsAggregator.this.acceptedGlobalOrdinals.test(globalOrd)) {
                        GlobalOrdinalsStringTermsAggregator.this.collectionStrategy.collectGlobalOrd(owningBucketOrd, doc, globalOrd, sub);
                    }
                    globalOrd = globalOrds.nextOrd();
                }
            }
        });
    }

    @Override
    public InternalAggregation[] buildAggregations(long[] owningBucketOrds) throws IOException {
        return this.resultStrategy.buildAggregations(owningBucketOrds);
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return this.resultStrategy.buildEmptyResult();
    }

    @Override
    public void collectDebugInfo(BiConsumer<String, Object> add) {
        super.collectDebugInfo(add);
        add.accept("collection_strategy", this.collectionStrategy.describe());
        add.accept("total_buckets", this.collectionStrategy.totalBuckets());
        add.accept("result_strategy", this.resultStrategy.describe());
        add.accept("segments_with_single_valued_ords", this.segmentsWithSingleValuedOrds);
        add.accept("segments_with_multi_valued_ords", this.segmentsWithMultiValuedOrds);
        add.accept("has_filter", this.acceptedGlobalOrdinals != ALWAYS_TRUE);
    }

    @Override
    protected void doClose() {
        Releasables.close((Releasable[])new Releasable[]{this.resultStrategy, this.collectionStrategy});
    }

    abstract class ResultStrategy<R extends InternalAggregation, B extends InternalMultiBucketAggregation.InternalBucket, TB extends InternalMultiBucketAggregation.InternalBucket>
    implements Releasable {
        ResultStrategy() {
        }

        private InternalAggregation[] buildAggregations(long[] owningBucketOrds) throws IOException {
            if (GlobalOrdinalsStringTermsAggregator.this.valueCount == 0L) {
                InternalAggregation[] results = new InternalAggregation[owningBucketOrds.length];
                for (int ordIdx = 0; ordIdx < owningBucketOrds.length; ++ordIdx) {
                    results[ordIdx] = this.buildNoValuesResult(owningBucketOrds[ordIdx]);
                }
                return results;
            }
            InternalMultiBucketAggregation.InternalBucket[][] topBucketsPreOrd = this.buildTopBucketsPerOrd(owningBucketOrds.length);
            final long[] otherDocCount = new long[owningBucketOrds.length];
            GlobalOrdLookupFunction lookupGlobalOrd = arg_0 -> ((SortedSetDocValues)GlobalOrdinalsStringTermsAggregator.this.valuesSupplier.get()).lookupOrd(arg_0);
            for (int ordIdx = 0; ordIdx < owningBucketOrds.length; ++ordIdx) {
                int size = GlobalOrdinalsStringTermsAggregator.this.bucketCountThresholds.getMinDocCount() == 0L ? (int)Math.min(GlobalOrdinalsStringTermsAggregator.this.valueCount, (long)GlobalOrdinalsStringTermsAggregator.this.bucketCountThresholds.getShardSize()) : (int)Math.min(GlobalOrdinalsStringTermsAggregator.this.maxBucketOrd(), (long)GlobalOrdinalsStringTermsAggregator.this.bucketCountThresholds.getShardSize());
                try (final ObjectArrayPriorityQueue<TB> ordered = this.buildPriorityQueue(size);){
                    final int finalOrdIdx = ordIdx;
                    final BucketUpdater<TB> updater = this.bucketUpdater(owningBucketOrds[ordIdx], lookupGlobalOrd);
                    GlobalOrdinalsStringTermsAggregator.this.collectionStrategy.forEach(owningBucketOrds[ordIdx], new BucketInfoConsumer(){
                        TB spare = null;

                        @Override
                        public void accept(long globalOrd, long bucketOrd, long docCount) throws IOException {
                            int n = finalOrdIdx;
                            otherDocCount[n] = otherDocCount[n] + docCount;
                            if (docCount >= GlobalOrdinalsStringTermsAggregator.this.bucketCountThresholds.getShardMinDocCount()) {
                                if (this.spare == null) {
                                    this.spare = ResultStrategy.this.buildEmptyTemporaryBucket();
                                }
                                updater.updateBucket(this.spare, globalOrd, bucketOrd, docCount);
                                this.spare = (InternalMultiBucketAggregation.InternalBucket)ordered.insertWithOverflow(this.spare);
                            }
                        }
                    });
                    topBucketsPreOrd[ordIdx] = this.buildBuckets((int)ordered.size());
                    for (int i = (int)ordered.size() - 1; i >= 0; --i) {
                        topBucketsPreOrd[ordIdx][i] = this.convertTempBucketToRealBucket((InternalMultiBucketAggregation.InternalBucket)ordered.pop(), lookupGlobalOrd);
                        int n = ordIdx;
                        otherDocCount[n] = otherDocCount[n] - topBucketsPreOrd[ordIdx][i].getDocCount();
                    }
                    continue;
                }
            }
            this.buildSubAggs(topBucketsPreOrd);
            InternalAggregation[] results = new InternalAggregation[owningBucketOrds.length];
            for (int ordIdx = 0; ordIdx < owningBucketOrds.length; ++ordIdx) {
                results[ordIdx] = this.buildResult(owningBucketOrds[ordIdx], otherDocCount[ordIdx], topBucketsPreOrd[ordIdx]);
            }
            return results;
        }

        abstract String describe();

        abstract LeafBucketCollector wrapCollector(LeafBucketCollector var1);

        abstract TB buildEmptyTemporaryBucket();

        abstract BucketUpdater<TB> bucketUpdater(long var1, GlobalOrdLookupFunction var3) throws IOException;

        abstract ObjectArrayPriorityQueue<TB> buildPriorityQueue(int var1);

        abstract B[][] buildTopBucketsPerOrd(int var1);

        abstract B[] buildBuckets(int var1);

        abstract B convertTempBucketToRealBucket(TB var1, GlobalOrdLookupFunction var2) throws IOException;

        abstract void buildSubAggs(B[][] var1) throws IOException;

        abstract R buildResult(long var1, long var3, B[] var5);

        abstract R buildEmptyResult();

        abstract R buildNoValuesResult(long var1);
    }

    private class RemapGlobalOrds
    extends CollectionStrategy {
        private final LongKeyedBucketOrds bucketOrds;
        private final boolean excludeDeletedDocs;

        private RemapGlobalOrds(CardinalityUpperBound cardinality, boolean excludeDeletedDocs) {
            this.bucketOrds = LongKeyedBucketOrds.buildForValueRange(GlobalOrdinalsStringTermsAggregator.this.bigArrays(), cardinality, 0L, GlobalOrdinalsStringTermsAggregator.this.valueCount - 1L);
            this.excludeDeletedDocs = excludeDeletedDocs;
        }

        @Override
        String describe() {
            return "remap using " + this.bucketOrds.decribe();
        }

        @Override
        long totalBuckets() {
            return this.bucketOrds.size();
        }

        @Override
        void globalOrdsReady(SortedSetDocValues globalOrds) {
        }

        @Override
        void collectGlobalOrd(long owningBucketOrd, int doc, long globalOrd, LeafBucketCollector sub) throws IOException {
            long bucketOrd = this.bucketOrds.add(owningBucketOrd, globalOrd);
            if (bucketOrd < 0L) {
                bucketOrd = -1L - bucketOrd;
                GlobalOrdinalsStringTermsAggregator.this.collectExistingBucket(sub, doc, bucketOrd);
            } else {
                GlobalOrdinalsStringTermsAggregator.this.collectBucket(sub, doc, bucketOrd);
            }
        }

        @Override
        long globalOrdToBucketOrd(long owningBucketOrd, long globalOrd) {
            return this.bucketOrds.find(owningBucketOrd, globalOrd);
        }

        @Override
        void forEach(long owningBucketOrd, BucketInfoConsumer consumer) throws IOException {
            if (this.excludeDeletedDocs) {
                this.forEachExcludeDeletedDocs(owningBucketOrd, consumer);
            } else {
                this.forEachAllowDeletedDocs(owningBucketOrd, consumer);
            }
        }

        void forEachAllowDeletedDocs(long owningBucketOrd, BucketInfoConsumer consumer) throws IOException {
            if (GlobalOrdinalsStringTermsAggregator.this.bucketCountThresholds.getMinDocCount() == 0L) {
                for (long globalOrd = 0L; globalOrd < GlobalOrdinalsStringTermsAggregator.this.valueCount; ++globalOrd) {
                    if (!GlobalOrdinalsStringTermsAggregator.this.acceptedGlobalOrdinals.test(globalOrd)) continue;
                    this.addBucketForMinDocCountZero(owningBucketOrd, globalOrd, consumer, null);
                }
            } else {
                LongKeyedBucketOrds.BucketOrdsEnum ordsEnum = this.bucketOrds.ordsEnum(owningBucketOrd);
                while (ordsEnum.next()) {
                    if (!GlobalOrdinalsStringTermsAggregator.this.acceptedGlobalOrdinals.test(ordsEnum.value())) continue;
                    consumer.accept(ordsEnum.value(), ordsEnum.ord(), GlobalOrdinalsStringTermsAggregator.this.bucketDocCount(ordsEnum.ord()));
                }
            }
        }

        void forEachExcludeDeletedDocs(long owningBucketOrd, BucketInfoConsumer consumer) throws IOException {
            assert (GlobalOrdinalsStringTermsAggregator.this.bucketCountThresholds.getMinDocCount() == 0L);
            try (LongHash accepted = new LongHash(20L, new BigArrays(null, null, ""));){
                for (LeafReaderContext ctx : GlobalOrdinalsStringTermsAggregator.this.searcher().getTopReaderContext().leaves()) {
                    LeafReader reader = ctx.reader();
                    Bits liveDocs = reader.getLiveDocs();
                    SortedSetDocValues globalOrds = null;
                    for (int docId = 0; docId < reader.maxDoc(); ++docId) {
                        if (liveDocs != null && !liveDocs.get(docId)) continue;
                        SortedSetDocValues sortedSetDocValues = globalOrds = globalOrds == null ? GlobalOrdinalsStringTermsAggregator.this.valuesSource.globalOrdinalsValues(ctx) : globalOrds;
                        if (!globalOrds.advanceExact(docId)) continue;
                        long globalOrd = globalOrds.nextOrd();
                        while (globalOrd != -1L) {
                            if (accepted.find(globalOrd) < 0L && GlobalOrdinalsStringTermsAggregator.this.acceptedGlobalOrdinals.test(globalOrd)) {
                                this.addBucketForMinDocCountZero(owningBucketOrd, globalOrd, consumer, accepted);
                            }
                            globalOrd = globalOrds.nextOrd();
                        }
                    }
                }
            }
        }

        private void addBucketForMinDocCountZero(long owningBucketOrd, long globalOrd, BucketInfoConsumer consumer, @Nullable LongHash accepted) throws IOException {
            long docCount;
            long bucketOrd = this.bucketOrds.add(owningBucketOrd, globalOrd);
            if (bucketOrd < 0L) {
                bucketOrd = -1L - bucketOrd;
                docCount = GlobalOrdinalsStringTermsAggregator.this.bucketDocCount(bucketOrd);
            } else {
                docCount = 0L;
            }
            assert (globalOrd >= 0L);
            consumer.accept(globalOrd, bucketOrd, docCount);
            if (accepted != null) {
                accepted.add(globalOrd);
            }
        }

        public void close() {
            this.bucketOrds.close();
        }
    }

    static abstract class CollectionStrategy
    implements Releasable {
        CollectionStrategy() {
        }

        abstract String describe();

        abstract long totalBuckets();

        abstract void globalOrdsReady(SortedSetDocValues var1);

        abstract void collectGlobalOrd(long var1, int var3, long var4, LeafBucketCollector var6) throws IOException;

        abstract long globalOrdToBucketOrd(long var1, long var3);

        abstract void forEach(long var1, BucketInfoConsumer var3) throws IOException;
    }

    class DenseGlobalOrds
    extends CollectionStrategy {
        private final boolean excludeDeletedDocs;

        DenseGlobalOrds(boolean excludeDeletedDocs) {
            this.excludeDeletedDocs = excludeDeletedDocs;
        }

        @Override
        String describe() {
            return "dense";
        }

        @Override
        long totalBuckets() {
            return GlobalOrdinalsStringTermsAggregator.this.valueCount;
        }

        @Override
        void globalOrdsReady(SortedSetDocValues globalOrds) {
            GlobalOrdinalsStringTermsAggregator.this.grow(globalOrds.getValueCount());
        }

        @Override
        void collectGlobalOrd(long owningBucketOrd, int doc, long globalOrd, LeafBucketCollector sub) throws IOException {
            assert (owningBucketOrd == 0L);
            GlobalOrdinalsStringTermsAggregator.this.collectExistingBucket(sub, doc, globalOrd);
        }

        @Override
        long globalOrdToBucketOrd(long owningBucketOrd, long globalOrd) {
            assert (owningBucketOrd == 0L);
            return globalOrd;
        }

        @Override
        void forEach(long owningBucketOrd, BucketInfoConsumer consumer) throws IOException {
            assert (owningBucketOrd == 0L);
            if (this.excludeDeletedDocs) {
                this.forEachExcludeDeletedDocs(consumer);
            } else {
                this.forEachAllowDeletedDocs(consumer);
            }
        }

        private void forEachAllowDeletedDocs(BucketInfoConsumer consumer) throws IOException {
            for (long globalOrd = 0L; globalOrd < GlobalOrdinalsStringTermsAggregator.this.valueCount; ++globalOrd) {
                if (!GlobalOrdinalsStringTermsAggregator.this.acceptedGlobalOrdinals.test(globalOrd)) continue;
                long docCount = GlobalOrdinalsStringTermsAggregator.this.bucketDocCount(globalOrd);
                if (GlobalOrdinalsStringTermsAggregator.this.bucketCountThresholds.getMinDocCount() != 0L && docCount <= 0L) continue;
                consumer.accept(globalOrd, globalOrd, docCount);
            }
        }

        private void forEachExcludeDeletedDocs(BucketInfoConsumer consumer) throws IOException {
            try (LongHash accepted = new LongHash(20L, new BigArrays(null, null, ""));){
                for (LeafReaderContext ctx : GlobalOrdinalsStringTermsAggregator.this.searcher().getTopReaderContext().leaves()) {
                    LeafReader reader = ctx.reader();
                    Bits liveDocs = reader.getLiveDocs();
                    SortedSetDocValues globalOrds = null;
                    for (int docId = 0; docId < reader.maxDoc(); ++docId) {
                        if (liveDocs != null && !liveDocs.get(docId)) continue;
                        SortedSetDocValues sortedSetDocValues = globalOrds = globalOrds == null ? GlobalOrdinalsStringTermsAggregator.this.valuesSource.globalOrdinalsValues(ctx) : globalOrds;
                        if (!globalOrds.advanceExact(docId)) continue;
                        long globalOrd = globalOrds.nextOrd();
                        while (globalOrd != -1L) {
                            if (accepted.find(globalOrd) < 0L && GlobalOrdinalsStringTermsAggregator.this.acceptedGlobalOrdinals.test(globalOrd)) {
                                long docCount = GlobalOrdinalsStringTermsAggregator.this.bucketDocCount(globalOrd);
                                if (GlobalOrdinalsStringTermsAggregator.this.bucketCountThresholds.getMinDocCount() == 0L || docCount > 0L) {
                                    consumer.accept(globalOrd, globalOrd, docCount);
                                    accepted.add(globalOrd);
                                }
                            }
                            globalOrd = globalOrds.nextOrd();
                        }
                    }
                }
            }
        }

        public void close() {
        }
    }

    class SignificantTermsResults
    extends ResultStrategy<SignificantStringTerms, SignificantStringTerms.Bucket, SignificantStringTerms.Bucket> {
        private final SignificanceLookup.BackgroundFrequencyForBytes backgroundFrequencies;
        private final long supersetSize;
        private final SignificanceHeuristic significanceHeuristic;
        private LongArray subsetSizes;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        SignificantTermsResults(SignificanceLookup significanceLookup, SignificanceHeuristic significanceHeuristic, CardinalityUpperBound cardinality) {
            this.backgroundFrequencies = significanceLookup.bytesLookup(GlobalOrdinalsStringTermsAggregator.this.bigArrays(), cardinality);
            this.supersetSize = significanceLookup.supersetSize();
            this.significanceHeuristic = significanceHeuristic;
            boolean success = false;
            try {
                this.subsetSizes = GlobalOrdinalsStringTermsAggregator.this.bigArrays().newLongArray(1L, true);
                success = true;
            }
            finally {
                if (!success) {
                    this.close();
                }
            }
        }

        @Override
        String describe() {
            return "significant_terms";
        }

        @Override
        LeafBucketCollector wrapCollector(LeafBucketCollector primary) {
            return new LeafBucketCollectorBase(primary, null){

                @Override
                public void collect(int doc, long owningBucketOrd) throws IOException {
                    super.collect(doc, owningBucketOrd);
                    SignificantTermsResults.this.subsetSizes = GlobalOrdinalsStringTermsAggregator.this.bigArrays().grow(SignificantTermsResults.this.subsetSizes, owningBucketOrd + 1L);
                    SignificantTermsResults.this.subsetSizes.increment(owningBucketOrd, 1L);
                }
            };
        }

        SignificantStringTerms.Bucket[][] buildTopBucketsPerOrd(int size) {
            return new SignificantStringTerms.Bucket[size][];
        }

        SignificantStringTerms.Bucket[] buildBuckets(int size) {
            return new SignificantStringTerms.Bucket[size];
        }

        @Override
        SignificantStringTerms.Bucket buildEmptyTemporaryBucket() {
            return new SignificantStringTerms.Bucket(new BytesRef(), 0L, 0L, 0L, 0L, null, GlobalOrdinalsStringTermsAggregator.this.format, 0.0);
        }

        private long subsetSize(long owningBucketOrd) {
            return owningBucketOrd < this.subsetSizes.size() ? this.subsetSizes.get(owningBucketOrd) : 0L;
        }

        @Override
        BucketUpdater<SignificantStringTerms.Bucket> bucketUpdater(long owningBucketOrd, GlobalOrdLookupFunction lookupGlobalOrd) throws IOException {
            long subsetSize = this.subsetSize(owningBucketOrd);
            return (spare, globalOrd, bucketOrd, docCount) -> {
                spare.bucketOrd = bucketOrd;
                SignificantTermsResults.oversizedCopy(lookupGlobalOrd.apply(globalOrd), spare.termBytes);
                spare.subsetDf = docCount;
                spare.subsetSize = subsetSize;
                spare.supersetDf = this.backgroundFrequencies.freq(spare.termBytes);
                spare.supersetSize = this.supersetSize;
                spare.updateScore(this.significanceHeuristic);
            };
        }

        @Override
        ObjectArrayPriorityQueue<SignificantStringTerms.Bucket> buildPriorityQueue(int size) {
            return new BucketSignificancePriorityQueue<SignificantStringTerms.Bucket>(size, GlobalOrdinalsStringTermsAggregator.this.bigArrays());
        }

        @Override
        SignificantStringTerms.Bucket convertTempBucketToRealBucket(SignificantStringTerms.Bucket temp, GlobalOrdLookupFunction lookupGlobalOrd) throws IOException {
            return temp;
        }

        void buildSubAggs(SignificantStringTerms.Bucket[][] topBucketsPreOrd) throws IOException {
            GlobalOrdinalsStringTermsAggregator.this.buildSubAggsForAllBuckets(topBucketsPreOrd, b -> b.bucketOrd, (b, aggs) -> {
                b.aggregations = aggs;
            });
        }

        SignificantStringTerms buildResult(long owningBucketOrd, long otherDocCount, SignificantStringTerms.Bucket[] topBuckets) {
            return new SignificantStringTerms(GlobalOrdinalsStringTermsAggregator.this.name, GlobalOrdinalsStringTermsAggregator.this.bucketCountThresholds.getRequiredSize(), GlobalOrdinalsStringTermsAggregator.this.bucketCountThresholds.getMinDocCount(), GlobalOrdinalsStringTermsAggregator.this.metadata(), GlobalOrdinalsStringTermsAggregator.this.format, this.subsetSize(owningBucketOrd), this.supersetSize, this.significanceHeuristic, Arrays.asList(topBuckets));
        }

        @Override
        SignificantStringTerms buildEmptyResult() {
            return GlobalOrdinalsStringTermsAggregator.this.buildEmptySignificantTermsAggregation(0L, this.supersetSize, this.significanceHeuristic);
        }

        @Override
        SignificantStringTerms buildNoValuesResult(long owningBucketOrdinal) {
            return GlobalOrdinalsStringTermsAggregator.this.buildEmptySignificantTermsAggregation(this.subsetSizes.get(owningBucketOrdinal), this.supersetSize, this.significanceHeuristic);
        }

        public void close() {
            Releasables.close((Releasable[])new Releasable[]{this.backgroundFrequencies, this.subsetSizes});
        }

        private static void oversizedCopy(BytesRef from, BytesRef to) {
            if (to.bytes.length < from.length) {
                to.bytes = new byte[ArrayUtil.oversize((int)from.length, (int)1)];
            }
            to.offset = 0;
            to.length = from.length;
            System.arraycopy(from.bytes, from.offset, to.bytes, 0, from.length);
        }
    }

    class StandardTermsResults
    extends ResultStrategy<StringTerms, StringTerms.Bucket, OrdBucket> {
        StandardTermsResults() {
        }

        @Override
        String describe() {
            return "terms";
        }

        @Override
        LeafBucketCollector wrapCollector(LeafBucketCollector primary) {
            return primary;
        }

        StringTerms.Bucket[][] buildTopBucketsPerOrd(int size) {
            return new StringTerms.Bucket[size][];
        }

        StringTerms.Bucket[] buildBuckets(int size) {
            return new StringTerms.Bucket[size];
        }

        @Override
        OrdBucket buildEmptyTemporaryBucket() {
            return new OrdBucket(GlobalOrdinalsStringTermsAggregator.this.showTermDocCountError, GlobalOrdinalsStringTermsAggregator.this.format);
        }

        @Override
        BucketUpdater<OrdBucket> bucketUpdater(long owningBucketOrd, GlobalOrdLookupFunction lookupGlobalOrd) throws IOException {
            return (spare, globalOrd, bucketOrd, docCount) -> {
                spare.globalOrd = globalOrd;
                spare.bucketOrd = bucketOrd;
                spare.docCount = docCount;
            };
        }

        @Override
        ObjectArrayPriorityQueue<OrdBucket> buildPriorityQueue(int size) {
            return new BucketPriorityQueue<OrdBucket>(size, GlobalOrdinalsStringTermsAggregator.this.bigArrays(), GlobalOrdinalsStringTermsAggregator.this.partiallyBuiltBucketComparator);
        }

        @Override
        StringTerms.Bucket convertTempBucketToRealBucket(OrdBucket temp, GlobalOrdLookupFunction lookupGlobalOrd) throws IOException {
            BytesRef term = BytesRef.deepCopyOf((BytesRef)lookupGlobalOrd.apply(temp.globalOrd));
            StringTerms.Bucket result = new StringTerms.Bucket(term, temp.docCount, null, GlobalOrdinalsStringTermsAggregator.this.showTermDocCountError, 0L, GlobalOrdinalsStringTermsAggregator.this.format);
            result.bucketOrd = temp.bucketOrd;
            result.docCountError = 0L;
            return result;
        }

        void buildSubAggs(StringTerms.Bucket[][] topBucketsPreOrd) throws IOException {
            GlobalOrdinalsStringTermsAggregator.this.buildSubAggsForAllBuckets(topBucketsPreOrd, b -> b.bucketOrd, (b, aggs) -> {
                b.aggregations = aggs;
            });
        }

        StringTerms buildResult(long owningBucketOrd, long otherDocCount, StringTerms.Bucket[] topBuckets) {
            BucketOrder reduceOrder;
            if (!InternalOrder.isKeyOrder(GlobalOrdinalsStringTermsAggregator.this.order)) {
                reduceOrder = InternalOrder.key(true);
                Arrays.sort(topBuckets, reduceOrder.comparator());
            } else {
                reduceOrder = GlobalOrdinalsStringTermsAggregator.this.order;
            }
            return new StringTerms(GlobalOrdinalsStringTermsAggregator.this.name, reduceOrder, GlobalOrdinalsStringTermsAggregator.this.order, GlobalOrdinalsStringTermsAggregator.this.bucketCountThresholds.getRequiredSize(), GlobalOrdinalsStringTermsAggregator.this.bucketCountThresholds.getMinDocCount(), GlobalOrdinalsStringTermsAggregator.this.metadata(), GlobalOrdinalsStringTermsAggregator.this.format, GlobalOrdinalsStringTermsAggregator.this.bucketCountThresholds.getShardSize(), GlobalOrdinalsStringTermsAggregator.this.showTermDocCountError, otherDocCount, Arrays.asList(topBuckets), null);
        }

        @Override
        StringTerms buildEmptyResult() {
            return GlobalOrdinalsStringTermsAggregator.this.buildEmptyTermsAggregation();
        }

        @Override
        StringTerms buildNoValuesResult(long owningBucketOrdinal) {
            return this.buildEmptyResult();
        }

        public void close() {
        }
    }

    static interface BucketUpdater<TB extends InternalMultiBucketAggregation.InternalBucket> {
        public void updateBucket(TB var1, long var2, long var4, long var6) throws IOException;
    }

    static interface BucketInfoConsumer {
        public void accept(long var1, long var3, long var5) throws IOException;
    }

    static class LowCardinality
    extends GlobalOrdinalsStringTermsAggregator {
        private LongUnaryOperator mapping;
        private LongArray segmentDocCounts;
        protected int segmentsWithoutValues = 0;

        LowCardinality(String name, AggregatorFactories factories, Function<GlobalOrdinalsStringTermsAggregator, ResultStrategy<?, ?, ?>> resultStrategy, ValuesSource.Bytes.WithOrdinals valuesSource, CheckedSupplier<SortedSetDocValues, IOException> valuesSupplier, BucketOrder order, DocValueFormat format, TermsAggregator.BucketCountThresholds bucketCountThresholds, AggregationContext context, Aggregator parent, boolean remapGlobalOrds, Aggregator.SubAggCollectionMode collectionMode, boolean showTermDocCountError, Map<String, Object> metadata, boolean excludeDeletedDocs) throws IOException {
            super(name, factories, resultStrategy, valuesSource, valuesSupplier, order, format, bucketCountThresholds, ALWAYS_TRUE, context, parent, remapGlobalOrds, collectionMode, showTermDocCountError, CardinalityUpperBound.ONE, metadata, excludeDeletedDocs);
            assert (factories == null || factories.countAggregators() == 0);
            this.segmentDocCounts = context.bigArrays().newLongArray(1L, true);
        }

        @Override
        public LeafBucketCollector getLeafCollector(AggregationExecutionContext aggCtx, LeafBucketCollector sub) throws IOException {
            if (this.mapping != null) {
                this.mapSegmentCountsToGlobalCounts(this.mapping);
            }
            final SortedSetDocValues segmentOrds = this.valuesSource.ordinalsValues(aggCtx.getLeafReaderContext());
            this.mapping = this.valuesSource.globalOrdinalsMapping(aggCtx.getLeafReaderContext());
            if (segmentOrds.getValueCount() == 0L) {
                ++this.segmentsWithoutValues;
                return LeafBucketCollector.NO_OP_COLLECTOR;
            }
            this.segmentDocCounts = this.bigArrays().grow(this.segmentDocCounts, 1L + segmentOrds.getValueCount());
            assert (sub.isNoop());
            final SortedDocValues singleValues = DocValues.unwrapSingleton((SortedSetDocValues)segmentOrds);
            if (singleValues != null) {
                ++this.segmentsWithSingleValuedOrds;
                return this.resultStrategy.wrapCollector(new LeafBucketCollectorBase(sub, segmentOrds){

                    @Override
                    public void collect(int doc, long owningBucketOrd) throws IOException {
                        assert (owningBucketOrd == 0L);
                        if (!singleValues.advanceExact(doc)) {
                            return;
                        }
                        int ord = singleValues.ordValue();
                        int docCount = docCountProvider.getDocCount(doc);
                        segmentDocCounts.increment(ord + 1, docCount);
                    }
                });
            }
            ++this.segmentsWithMultiValuedOrds;
            return this.resultStrategy.wrapCollector(new LeafBucketCollectorBase(sub, segmentOrds){

                @Override
                public void collect(int doc, long owningBucketOrd) throws IOException {
                    assert (owningBucketOrd == 0L);
                    if (!segmentOrds.advanceExact(doc)) {
                        return;
                    }
                    long segmentOrd = segmentOrds.nextOrd();
                    while (segmentOrd != -1L) {
                        int docCount = docCountProvider.getDocCount(doc);
                        segmentDocCounts.increment(segmentOrd + 1L, docCount);
                        segmentOrd = segmentOrds.nextOrd();
                    }
                }
            });
        }

        @Override
        protected void doPostCollection() throws IOException {
            if (this.mapping != null) {
                this.mapSegmentCountsToGlobalCounts(this.mapping);
                this.mapping = null;
            }
        }

        @Override
        public void collectDebugInfo(BiConsumer<String, Object> add) {
            super.collectDebugInfo(add);
            add.accept("segments_without_values", this.segmentsWithoutValues);
        }

        @Override
        protected void doClose() {
            Releasables.close((Releasable[])new Releasable[]{this.resultStrategy, this.segmentDocCounts, this.collectionStrategy});
        }

        private void mapSegmentCountsToGlobalCounts(LongUnaryOperator mapping) throws IOException {
            for (long i = 1L; i < this.segmentDocCounts.size(); ++i) {
                long inc = this.segmentDocCounts.getAndSet(i, 0L);
                if (inc == 0L) continue;
                long ord = i - 1L;
                long globalOrd = mapping.applyAsLong(ord);
                this.incrementBucketDocCount(this.collectionStrategy.globalOrdToBucketOrd(0L, globalOrd), inc);
            }
        }
    }

    static class OrdBucket
    extends InternalTerms.Bucket<OrdBucket> {
        long globalOrd;

        OrdBucket(boolean showDocCountError, DocValueFormat format) {
            super(0L, null, showDocCountError, 0L, format);
        }

        @Override
        public int compareKey(OrdBucket other) {
            return Long.compare(this.globalOrd, other.globalOrd);
        }

        @Override
        public String getKeyAsString() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object getKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Number getKeyAsNumber() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void writeTermTo(StreamOutput out) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        protected final XContentBuilder keyToXContent(XContentBuilder builder) throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    public static interface GlobalOrdLookupFunction {
        public BytesRef apply(long var1) throws IOException;
    }
}

