/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket;

import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.LongUnaryOperator;
import java.util.function.ToLongFunction;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.search.aggregations.AggregationErrors;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorBase;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.bucket.DocCountProvider;
import org.elasticsearch.search.aggregations.bucket.SingleBucketAggregator;
import org.elasticsearch.search.aggregations.bucket.global.GlobalAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.LongKeyedBucketOrds;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.AggregationPath;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.tasks.TaskCancelledException;

public abstract class BucketsAggregator
extends AggregatorBase {
    private final CircuitBreaker breaker;
    private LongArray docCounts;
    protected final DocCountProvider docCountProvider;
    private int callCount;

    public BucketsAggregator(String name, AggregatorFactories factories, AggregationContext aggCtx, Aggregator parent, CardinalityUpperBound bucketCardinality, Map<String, Object> metadata) throws IOException {
        super(name, factories, aggCtx, parent, bucketCardinality, metadata);
        this.breaker = aggCtx.breaker();
        this.docCounts = this.bigArrays().newLongArray(1L, true);
        this.docCountProvider = new DocCountProvider();
    }

    public final long maxBucketOrd() {
        return this.docCounts.size();
    }

    public final void grow(long maxBucketOrd) {
        this.docCounts = this.bigArrays().grow(this.docCounts, maxBucketOrd);
    }

    public final void collectBucket(LeafBucketCollector subCollector, int doc, long bucketOrd) throws IOException {
        this.grow(bucketOrd + 1L);
        int docCount = this.docCountProvider.getDocCount(doc);
        if (this.docCounts.increment(bucketOrd, docCount) == (long)docCount && (++this.callCount & 0x3FF) == 0) {
            this.breaker.addEstimateBytesAndMaybeBreak(0L, "allocated_buckets");
        }
        subCollector.collect(doc, bucketOrd);
    }

    public final void collectExistingBucket(LeafBucketCollector subCollector, int doc, long bucketOrd) throws IOException {
        this.docCounts.increment(bucketOrd, this.docCountProvider.getDocCount(doc));
        subCollector.collect(doc, bucketOrd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void rewriteBuckets(long newNumBuckets, LongUnaryOperator mergeMap) {
        LongArray oldDocCounts = this.docCounts;
        boolean success = false;
        try {
            this.docCounts = this.bigArrays().newLongArray(newNumBuckets, true);
            success = true;
            this.docCounts.fill(0L, newNumBuckets, 0L);
            for (long i = 0L; i < oldDocCounts.size(); ++i) {
                long destinationOrdinal;
                long docCount = oldDocCounts.get(i);
                if (docCount == 0L || (destinationOrdinal = mergeMap.applyAsLong(i)) == -1L) continue;
                this.docCounts.increment(destinationOrdinal, docCount);
            }
        }
        finally {
            if (success) {
                oldDocCounts.close();
            }
        }
    }

    public LongArray getDocCounts() {
        return this.docCounts;
    }

    public final void incrementBucketDocCount(long bucketOrd, long inc) {
        this.docCounts = this.bigArrays().grow(this.docCounts, bucketOrd + 1L);
        this.docCounts.increment(bucketOrd, inc);
    }

    public final long bucketDocCount(long bucketOrd) {
        if (bucketOrd >= this.docCounts.size()) {
            return 0L;
        }
        return this.docCounts.get(bucketOrd);
    }

    protected void prepareSubAggs(long[] ordsToCollect) throws IOException {
    }

    protected final IntFunction<InternalAggregations> buildSubAggsForBuckets(long[] bucketOrdsToCollect) throws IOException {
        if (this.context.isCancelled()) {
            throw new TaskCancelledException("not building sub-aggregations due to task cancellation");
        }
        this.prepareSubAggs(bucketOrdsToCollect);
        InternalAggregation[][] aggregations = new InternalAggregation[this.subAggregators.length][];
        for (int i = 0; i < this.subAggregators.length; ++i) {
            aggregations[i] = this.subAggregators[i].buildAggregations(bucketOrdsToCollect);
        }
        return BucketsAggregator.subAggsForBucketFunction(aggregations);
    }

    private static IntFunction<InternalAggregations> subAggsForBucketFunction(final InternalAggregation[][] aggregations) {
        return ord -> InternalAggregations.from((List<InternalAggregation>)new AbstractList<InternalAggregation>(){

            @Override
            public InternalAggregation get(int index) {
                return aggregations[index][ord];
            }

            @Override
            public int size() {
                return aggregations.length;
            }
        });
    }

    protected final <B> void buildSubAggsForAllBuckets(B[][] buckets, ToLongFunction<B> bucketToOrd, BiConsumer<B, InternalAggregations> setAggs) throws IOException {
        int totalBucketOrdsToCollect = 0;
        for (B[] bucketsForOneResult : buckets) {
            totalBucketOrdsToCollect += bucketsForOneResult.length;
        }
        long[] bucketOrdsToCollect = new long[totalBucketOrdsToCollect];
        int s = 0;
        B[][] BArray = buckets;
        int n = BArray.length;
        for (int i = 0; i < n; ++i) {
            B[] bucketsForOneResult;
            for (B bucket : bucketsForOneResult = BArray[i]) {
                bucketOrdsToCollect[s++] = bucketToOrd.applyAsLong(bucket);
            }
        }
        IntFunction<InternalAggregations> results = this.buildSubAggsForBuckets(bucketOrdsToCollect);
        s = 0;
        for (B[] bucket : buckets) {
            for (int b = 0; b < bucket.length; ++b) {
                setAggs.accept(bucket[b], results.apply(s++));
            }
        }
    }

    protected final <B> InternalAggregation[] buildAggregationsForFixedBucketCount(long[] owningBucketOrds, int bucketsPerOwningBucketOrd, BucketBuilderForFixedCount<B> bucketBuilder, Function<List<B>, InternalAggregation> resultBuilder) throws IOException {
        int totalBuckets = owningBucketOrds.length * bucketsPerOwningBucketOrd;
        long[] bucketOrdsToCollect = new long[totalBuckets];
        int bucketOrdIdx = 0;
        for (long owningBucketOrd : owningBucketOrds) {
            long ord = owningBucketOrd * (long)bucketsPerOwningBucketOrd;
            for (int offsetInOwningOrd = 0; offsetInOwningOrd < bucketsPerOwningBucketOrd; ++offsetInOwningOrd) {
                bucketOrdsToCollect[bucketOrdIdx++] = ord++;
            }
        }
        bucketOrdIdx = 0;
        IntFunction<InternalAggregations> subAggregationResults = this.buildSubAggsForBuckets(bucketOrdsToCollect);
        InternalAggregation[] results = new InternalAggregation[owningBucketOrds.length];
        for (int owningOrdIdx = 0; owningOrdIdx < owningBucketOrds.length; ++owningOrdIdx) {
            ArrayList<B> buckets = new ArrayList<B>(bucketsPerOwningBucketOrd);
            for (int offsetInOwningOrd = 0; offsetInOwningOrd < bucketsPerOwningBucketOrd; ++offsetInOwningOrd) {
                buckets.add(bucketBuilder.build(offsetInOwningOrd, this.bucketDocCount(bucketOrdsToCollect[bucketOrdIdx]), subAggregationResults.apply(bucketOrdIdx++)));
            }
            results[owningOrdIdx] = resultBuilder.apply(buckets);
        }
        return results;
    }

    protected final InternalAggregation[] buildAggregationsForSingleBucket(long[] owningBucketOrds, SingleBucketResultBuilder resultBuilder) throws IOException {
        IntFunction<InternalAggregations> subAggregationResults = this.buildSubAggsForBuckets(owningBucketOrds);
        InternalAggregation[] results = new InternalAggregation[owningBucketOrds.length];
        for (int ordIdx = 0; ordIdx < owningBucketOrds.length; ++ordIdx) {
            results[ordIdx] = resultBuilder.build(owningBucketOrds[ordIdx], subAggregationResults.apply(ordIdx));
        }
        return results;
    }

    protected final <B> InternalAggregation[] buildAggregationsForVariableBuckets(long[] owningBucketOrds, LongKeyedBucketOrds bucketOrds, BucketBuilderForVariable<B> bucketBuilder, ResultBuilderForVariable<B> resultBuilder) throws IOException {
        long totalOrdsToCollect = 0L;
        int[] bucketsInOrd = new int[owningBucketOrds.length];
        for (int ordIdx = 0; ordIdx < owningBucketOrds.length; ++ordIdx) {
            long bucketCount = bucketOrds.bucketsInOrd(owningBucketOrds[ordIdx]);
            bucketsInOrd[ordIdx] = (int)bucketCount;
            totalOrdsToCollect += bucketCount;
        }
        if (totalOrdsToCollect > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Can't collect more than [2147483647] buckets but attempted [" + totalOrdsToCollect + "]");
        }
        long[] bucketOrdsToCollect = new long[(int)totalOrdsToCollect];
        int b = 0;
        for (long owningBucketOrd : owningBucketOrds) {
            LongKeyedBucketOrds.BucketOrdsEnum ordsEnum = bucketOrds.ordsEnum(owningBucketOrd);
            while (ordsEnum.next()) {
                bucketOrdsToCollect[b++] = ordsEnum.ord();
            }
        }
        IntFunction<InternalAggregations> subAggregationResults = this.buildSubAggsForBuckets(bucketOrdsToCollect);
        InternalAggregation[] results = new InternalAggregation[owningBucketOrds.length];
        b = 0;
        for (int ordIdx = 0; ordIdx < owningBucketOrds.length; ++ordIdx) {
            ArrayList<B> buckets = new ArrayList<B>(bucketsInOrd[ordIdx]);
            LongKeyedBucketOrds.BucketOrdsEnum ordsEnum = bucketOrds.ordsEnum(owningBucketOrds[ordIdx]);
            while (ordsEnum.next()) {
                if (bucketOrdsToCollect[b] != ordsEnum.ord()) {
                    throw AggregationErrors.iterationOrderChangedWithoutMutating(bucketOrds.toString(), ordsEnum.ord(), bucketOrdsToCollect[b]);
                }
                buckets.add(bucketBuilder.build(ordsEnum.value(), this.bucketDocCount(ordsEnum.ord()), subAggregationResults.apply(b++)));
            }
            results[ordIdx] = resultBuilder.build(owningBucketOrds[ordIdx], buckets);
        }
        return results;
    }

    @Override
    public final void close() {
        try (LongArray releasable = this.docCounts;){
            super.close();
        }
    }

    @Override
    public Aggregator resolveSortPath(AggregationPath.PathElement next, Iterator<AggregationPath.PathElement> path) {
        if (this instanceof SingleBucketAggregator) {
            return this.resolveSortPathOnValidAgg(next, path);
        }
        return super.resolveSortPath(next, path);
    }

    @Override
    public Aggregator.BucketComparator bucketComparator(String key, SortOrder order) {
        if (!(this instanceof SingleBucketAggregator)) {
            return super.bucketComparator(key, order);
        }
        if (key == null || "doc_count".equals(key)) {
            return (lhs, rhs) -> order.reverseMul() * Long.compare(this.bucketDocCount(lhs), this.bucketDocCount(rhs));
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "Ordering on a single-bucket aggregation can only be done on its doc_count. Either drop the key (a la \"%s\") or change it to \"doc_count\" (a la \"%s.doc_count\") or \"key\".", this.name(), this.name()));
    }

    public static boolean descendsFromGlobalAggregator(Aggregator parent) {
        while (parent != null) {
            if (parent.getClass() == GlobalAggregator.class) {
                return true;
            }
            parent = parent.parent();
        }
        return false;
    }

    @Override
    protected void preGetSubLeafCollectors(LeafReaderContext ctx) throws IOException {
        super.preGetSubLeafCollectors(ctx);
        this.docCountProvider.setLeafReaderContext(ctx);
    }

    @FunctionalInterface
    protected static interface BucketBuilderForFixedCount<B> {
        public B build(int var1, long var2, InternalAggregations var4);
    }

    @FunctionalInterface
    protected static interface SingleBucketResultBuilder {
        public InternalAggregation build(long var1, InternalAggregations var3);
    }

    @FunctionalInterface
    protected static interface BucketBuilderForVariable<B> {
        public B build(long var1, long var3, InternalAggregations var5);
    }

    @FunctionalInterface
    protected static interface ResultBuilderForVariable<B> {
        public InternalAggregation build(long var1, List<B> var3);
    }
}

